/* ========================================================================
 * Copyright 1988-2006 University of Washington
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * 
 * ========================================================================
 */

/*
 * Program:	Unicode decomposition tables (current as of Unicode 5.0)
 *
 * Author:	Mark Crispin
 *		Networks and Distributed Computing
 *		Computing & Communications
 *		University of Washington
 *		Administration Building, AG-44
 *		Seattle, WA  98195
 *		Internet: MRC@CAC.Washington.EDU
 *
 * Date:	13 April 2006
 * Last Edited:	6 December 2006
 */

/* BMP decompositions */

#define UCS4_BMPLOMIN 0x00a0
#define UCS4_BMPLOMAX 0x33ff
#define UCS4_BMPLOIXMASK 0x1fff
#define UCS4_BMPLOSIZEMASK 0xe000
#define UCS4_BMPLOSIZESHIFT 13

	/* BMP low decomposition indices - sssi iiii iiii iiii */
static unsigned short ucs4_dbmploixtab[13152] = {
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x2001,0x0000,0x0003,0x0000,0x0000,0x0000,0x0000,0x2004,
  0x0000,0x0000,0x0006,0x0007,0x2008,0x000a,0x0000,0x0000,
  0x200b,0x000d,0x000e,0x0000,0x400f,0x4012,0x4015,0x0000,
  0x2018,0x201a,0x201c,0x201e,0x2020,0x2022,0x0000,0x2024,
  0x2026,0x2028,0x202a,0x202c,0x202e,0x2030,0x2032,0x2034,
  0x0000,0x2036,0x2038,0x203a,0x203c,0x203e,0x2040,0x0000,
  0x0000,0x2042,0x2044,0x2046,0x2048,0x204a,0x0000,0x0000,
  0x204c,0x204e,0x2050,0x2052,0x2054,0x2056,0x0000,0x2058,
  0x205a,0x205c,0x205e,0x2060,0x2062,0x2064,0x2066,0x2068,
  0x0000,0x206a,0x206c,0x206e,0x2070,0x2072,0x2074,0x0000,
  0x0000,0x2076,0x2078,0x207a,0x207c,0x207e,0x0000,0x2080,
  0x2082,0x2084,0x2086,0x2088,0x208a,0x208c,0x208e,0x2090,
  0x2092,0x2094,0x2096,0x2098,0x209a,0x209c,0x209e,0x20a0,
  0x0000,0x0000,0x20a2,0x20a4,0x20a6,0x20a8,0x20aa,0x20ac,
  0x20ae,0x20b0,0x20b2,0x20b4,0x20b6,0x20b8,0x20ba,0x20bc,
  0x20be,0x20c0,0x20c2,0x20c4,0x20c6,0x20c8,0x0000,0x0000,
  0x20ca,0x20cc,0x20ce,0x20d0,0x20d2,0x20d4,0x20d6,0x20d8,
  0x20da,0x0000,0x20dc,0x20de,0x20e0,0x20e2,0x20e4,0x20e6,
  0x0000,0x20e8,0x20ea,0x20ec,0x20ee,0x20f0,0x20f2,0x20f4,
  0x20f6,0x0000,0x0000,0x20f8,0x20fa,0x20fc,0x20fe,0x2100,
  0x2102,0x2104,0x0000,0x0000,0x2106,0x2108,0x210a,0x210c,
  0x210e,0x2110,0x0000,0x0000,0x2112,0x2114,0x2116,0x2118,
  0x211a,0x211c,0x211e,0x2120,0x2122,0x2124,0x2126,0x2128,
  0x212a,0x212c,0x212e,0x2130,0x2132,0x2134,0x0000,0x0000,
  0x2136,0x2138,0x213a,0x213c,0x213e,0x2140,0x2142,0x2144,
  0x2146,0x2148,0x214a,0x214c,0x214e,0x2150,0x2152,0x2154,
  0x2156,0x2158,0x215a,0x215c,0x215e,0x2160,0x2162,0x0164,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x2165,0x2167,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x2169,
  0x216b,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x216d,0x216f,0x2171,0x2173,
  0x2175,0x2177,0x2179,0x217b,0x217d,0x217f,0x2181,0x2183,
  0x2185,0x2187,0x2189,0x218b,0x218d,0x218f,0x2191,0x2193,
  0x2195,0x2197,0x2199,0x219b,0x219d,0x0000,0x219f,0x21a1,
  0x21a3,0x21a5,0x21a7,0x21a9,0x0000,0x0000,0x21ab,0x21ad,
  0x21af,0x21b1,0x21b3,0x21b5,0x21b7,0x21b9,0x21bb,0x21bd,
  0x21bf,0x21c1,0x21c3,0x21c5,0x21c7,0x21c9,0x0000,0x0000,
  0x21cb,0x21cd,0x21cf,0x21d1,0x21d3,0x21d5,0x21d7,0x21d9,
  0x21db,0x21dd,0x21df,0x21e1,0x21e3,0x21e5,0x21e7,0x21e9,
  0x21eb,0x21ed,0x21ef,0x21f1,0x21f3,0x21f5,0x21f7,0x21f9,
  0x21fb,0x21fd,0x21ff,0x2201,0x2203,0x2205,0x2207,0x2209,
  0x220b,0x220d,0x220f,0x2211,0x0000,0x0000,0x2213,0x2215,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x2217,0x2219,
  0x221b,0x221d,0x221f,0x2221,0x2223,0x2225,0x2227,0x2229,
  0x222b,0x222d,0x222f,0x2231,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0233,0x0234,0x0235,0x0236,0x0237,0x0238,0x0239,0x023a,
  0x023b,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x223c,0x223e,0x2240,0x2242,0x2244,0x2246,0x0000,0x0000,
  0x0248,0x0249,0x024a,0x024b,0x024c,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x024d,0x024e,0x0000,0x024f,0x2250,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0252,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x2253,0x0000,0x0000,0x0000,0x0255,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x2256,0x2258,0x225a,0x025c,
  0x225d,0x225f,0x2261,0x0000,0x2263,0x0000,0x2265,0x2267,
  0x2269,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x226b,0x226d,0x226f,0x2271,0x2273,0x2275,
  0x2277,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x2279,0x227b,0x227d,0x227f,0x2281,0x0000,
  0x0283,0x0284,0x0285,0x2286,0x2288,0x028a,0x028b,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x028c,0x028d,0x028e,0x0000,0x028f,0x0290,0x0000,0x0000,
  0x0000,0x0291,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x2292,0x2294,0x0000,0x2296,0x0000,0x0000,0x0000,0x2298,
  0x0000,0x0000,0x0000,0x0000,0x229a,0x229c,0x229e,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x22a0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x22a2,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x22a4,0x22a6,0x0000,0x22a8,0x0000,0x0000,0x0000,0x22aa,
  0x0000,0x0000,0x0000,0x0000,0x22ac,0x22ae,0x22b0,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x22b2,0x22b4,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x22b6,0x22b8,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x22ba,0x22bc,0x22be,0x22c0,0x0000,0x0000,0x22c2,0x22c4,
  0x0000,0x0000,0x22c6,0x22c8,0x22ca,0x22cc,0x22ce,0x22d0,
  0x0000,0x0000,0x22d2,0x22d4,0x22d6,0x22d8,0x22da,0x22dc,
  0x0000,0x0000,0x22de,0x22e0,0x22e2,0x22e4,0x22e6,0x22e8,
  0x22ea,0x22ec,0x22ee,0x22f0,0x22f2,0x22f4,0x0000,0x0000,
  0x22f6,0x22f8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x22fa,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x22fc,0x22fe,0x2300,0x2302,0x2304,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x2306,0x2308,0x230a,
  0x230c,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x230e,0x0000,0x2310,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x2312,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x2314,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x2316,0x0000,0x0000,0x2318,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x231a,0x231c,0x231e,0x2320,0x2322,0x2324,0x2326,0x2328,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x232a,0x232c,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x232e,0x2330,0x0000,0x2332,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x2334,0x0000,0x0000,0x2336,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x2338,0x233a,0x233c,0x0000,0x0000,0x233e,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x2340,0x0000,0x0000,0x2342,0x2344,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x2346,0x2348,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x234a,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x234c,0x234e,0x2350,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x2352,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x2354,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x2356,
  0x2358,0x0000,0x235a,0x235c,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x235e,0x2360,0x2362,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x2364,0x0000,0x2366,0x2368,0x236a,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x236c,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x236e,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x2370,0x2372,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0374,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x2375,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x2377,0x0000,0x0000,
  0x0000,0x0000,0x2379,0x0000,0x0000,0x0000,0x0000,0x237b,
  0x0000,0x0000,0x0000,0x0000,0x237d,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x237f,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x2381,0x0000,0x2383,0x2385,0x2387,
  0x2389,0x238b,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x238d,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x238f,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x2391,0x0000,0x0000,
  0x0000,0x0000,0x2393,0x0000,0x0000,0x0000,0x0000,0x2395,
  0x0000,0x0000,0x0000,0x0000,0x2397,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x2399,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x239b,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x039d,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x239e,0x0000,
  0x23a0,0x0000,0x23a2,0x0000,0x23a4,0x0000,0x23a6,0x0000,
  0x0000,0x0000,0x23a8,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x23aa,0x0000,0x23ac,0x0000,0x0000,
  0x23ae,0x23b0,0x0000,0x23b2,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x03b4,0x03b5,0x03b6,0x0000,
  0x03b7,0x03b8,0x03b9,0x03ba,0x03bb,0x03bc,0x03bd,0x03be,
  0x03bf,0x03c0,0x03c1,0x0000,0x03c2,0x03c3,0x03c4,0x03c5,
  0x03c6,0x03c7,0x03c8,0x03c9,0x03ca,0x03cb,0x03cc,0x03cd,
  0x03ce,0x03cf,0x03d0,0x03d1,0x03d2,0x03d3,0x0000,0x03d4,
  0x03d5,0x03d6,0x03d7,0x03d8,0x03d9,0x03da,0x03db,0x03dc,
  0x03dd,0x03de,0x03df,0x03e0,0x03e1,0x03e2,0x03e3,0x03e4,
  0x03e5,0x03e6,0x03e7,0x03e8,0x03e9,0x03ea,0x03eb,0x03ec,
  0x03ed,0x03ee,0x03ef,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x03f0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x03f1,0x03f2,0x03f3,0x03f4,0x03f5,
  0x03f6,0x03f7,0x03f8,0x03f9,0x03fa,0x03fb,0x03fc,0x03fd,
  0x03fe,0x03ff,0x0400,0x0401,0x0402,0x0403,0x0404,0x0405,
  0x0406,0x0407,0x0408,0x0409,0x040a,0x040b,0x040c,0x040d,
  0x040e,0x040f,0x0410,0x0411,0x0412,0x0413,0x0414,0x0415,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x2416,0x2418,0x241a,0x241c,0x241e,0x2420,0x2422,0x2424,
  0x2426,0x2428,0x242a,0x242c,0x242e,0x2430,0x2432,0x2434,
  0x2436,0x2438,0x243a,0x243c,0x243e,0x2440,0x2442,0x2444,
  0x2446,0x2448,0x244a,0x244c,0x244e,0x2450,0x2452,0x2454,
  0x2456,0x2458,0x245a,0x245c,0x245e,0x2460,0x2462,0x2464,
  0x2466,0x2468,0x246a,0x246c,0x246e,0x2470,0x2472,0x2474,
  0x2476,0x2478,0x247a,0x247c,0x247e,0x2480,0x2482,0x2484,
  0x2486,0x2488,0x248a,0x248c,0x248e,0x2490,0x2492,0x2494,
  0x2496,0x2498,0x249a,0x249c,0x249e,0x24a0,0x24a2,0x24a4,
  0x24a6,0x24a8,0x24aa,0x24ac,0x24ae,0x24b0,0x24b2,0x24b4,
  0x24b6,0x24b8,0x24ba,0x24bc,0x24be,0x24c0,0x24c2,0x24c4,
  0x24c6,0x24c8,0x24ca,0x24cc,0x24ce,0x24d0,0x24d2,0x24d4,
  0x24d6,0x24d8,0x24da,0x24dc,0x24de,0x24e0,0x24e2,0x24e4,
  0x24e6,0x24e8,0x24ea,0x24ec,0x24ee,0x24f0,0x24f2,0x24f4,
  0x24f6,0x24f8,0x24fa,0x24fc,0x24fe,0x2500,0x2502,0x2504,
  0x2506,0x2508,0x250a,0x250c,0x250e,0x2510,0x2512,0x2514,
  0x2516,0x2518,0x251a,0x251c,0x251e,0x2520,0x2522,0x2524,
  0x2526,0x2528,0x252a,0x252c,0x252e,0x2530,0x2532,0x2534,
  0x2536,0x2538,0x253a,0x253c,0x253e,0x2540,0x2542,0x2544,
  0x2546,0x2548,0x254a,0x254c,0x0000,0x0000,0x0000,0x0000,
  0x254e,0x2550,0x2552,0x2554,0x2556,0x2558,0x255a,0x255c,
  0x255e,0x2560,0x2562,0x2564,0x2566,0x2568,0x256a,0x256c,
  0x256e,0x2570,0x2572,0x2574,0x2576,0x2578,0x257a,0x257c,
  0x257e,0x2580,0x2582,0x2584,0x2586,0x2588,0x258a,0x258c,
  0x258e,0x2590,0x2592,0x2594,0x2596,0x2598,0x259a,0x259c,
  0x259e,0x25a0,0x25a2,0x25a4,0x25a6,0x25a8,0x25aa,0x25ac,
  0x25ae,0x25b0,0x25b2,0x25b4,0x25b6,0x25b8,0x25ba,0x25bc,
  0x25be,0x25c0,0x25c2,0x25c4,0x25c6,0x25c8,0x25ca,0x25cc,
  0x25ce,0x25d0,0x25d2,0x25d4,0x25d6,0x25d8,0x25da,0x25dc,
  0x25de,0x25e0,0x25e2,0x25e4,0x25e6,0x25e8,0x25ea,0x25ec,
  0x25ee,0x25f0,0x25f2,0x25f4,0x25f6,0x25f8,0x25fa,0x25fc,
  0x25fe,0x2600,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x2602,0x2604,0x2606,0x2608,0x260a,0x260c,0x260e,0x2610,
  0x2612,0x2614,0x2616,0x2618,0x261a,0x261c,0x261e,0x2620,
  0x2622,0x2624,0x2626,0x2628,0x262a,0x262c,0x0000,0x0000,
  0x262e,0x2630,0x2632,0x2634,0x2636,0x2638,0x0000,0x0000,
  0x263a,0x263c,0x263e,0x2640,0x2642,0x2644,0x2646,0x2648,
  0x264a,0x264c,0x264e,0x2650,0x2652,0x2654,0x2656,0x2658,
  0x265a,0x265c,0x265e,0x2660,0x2662,0x2664,0x2666,0x2668,
  0x266a,0x266c,0x266e,0x2670,0x2672,0x2674,0x2676,0x2678,
  0x267a,0x267c,0x267e,0x2680,0x2682,0x2684,0x0000,0x0000,
  0x2686,0x2688,0x268a,0x268c,0x268e,0x2690,0x0000,0x0000,
  0x2692,0x2694,0x2696,0x2698,0x269a,0x269c,0x269e,0x26a0,
  0x0000,0x26a2,0x0000,0x26a4,0x0000,0x26a6,0x0000,0x26a8,
  0x26aa,0x26ac,0x26ae,0x26b0,0x26b2,0x26b4,0x26b6,0x26b8,
  0x26ba,0x26bc,0x26be,0x26c0,0x26c2,0x26c4,0x26c6,0x26c8,
  0x26ca,0x06cc,0x26cd,0x06cf,0x26d0,0x06d2,0x26d3,0x06d5,
  0x26d6,0x06d8,0x26d9,0x06db,0x26dc,0x06de,0x0000,0x0000,
  0x26df,0x26e1,0x26e3,0x26e5,0x26e7,0x26e9,0x26eb,0x26ed,
  0x26ef,0x26f1,0x26f3,0x26f5,0x26f7,0x26f9,0x26fb,0x26fd,
  0x26ff,0x2701,0x2703,0x2705,0x2707,0x2709,0x270b,0x270d,
  0x270f,0x2711,0x2713,0x2715,0x2717,0x2719,0x271b,0x271d,
  0x271f,0x2721,0x2723,0x2725,0x2727,0x2729,0x272b,0x272d,
  0x272f,0x2731,0x2733,0x2735,0x2737,0x2739,0x273b,0x273d,
  0x273f,0x2741,0x2743,0x2745,0x2747,0x0000,0x2749,0x274b,
  0x274d,0x274f,0x2751,0x0753,0x2754,0x2756,0x0758,0x2759,
  0x275b,0x275d,0x275f,0x2761,0x2763,0x0000,0x2765,0x2767,
  0x2769,0x076b,0x276c,0x076e,0x276f,0x2771,0x2773,0x2775,
  0x2777,0x2779,0x277b,0x077d,0x0000,0x0000,0x277e,0x2780,
  0x2782,0x2784,0x2786,0x0788,0x0000,0x2789,0x278b,0x278d,
  0x278f,0x2791,0x2793,0x0795,0x2796,0x2798,0x279a,0x279c,
  0x279e,0x27a0,0x27a2,0x07a4,0x27a5,0x27a7,0x07a9,0x07aa,
  0x0000,0x0000,0x27ab,0x27ad,0x27af,0x0000,0x27b1,0x27b3,
  0x27b5,0x07b7,0x27b8,0x07ba,0x27bb,0x07bd,0x27be,0x0000,
  0x07c0,0x07c1,0x07c2,0x07c3,0x07c4,0x07c5,0x07c6,0x07c7,
  0x07c8,0x07c9,0x07ca,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x07cb,0x0000,0x0000,0x0000,0x0000,0x0000,0x27cc,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x07ce,0x27cf,0x47d1,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x07d4,
  0x0000,0x0000,0x0000,0x27d5,0x47d7,0x0000,0x27da,0x47dc,
  0x0000,0x0000,0x0000,0x0000,0x27df,0x0000,0x27e1,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x27e3,
  0x27e5,0x27e7,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x67e9,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x07ed,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x07ee,0x07ef,0x0000,0x0000,0x07f0,0x07f1,0x07f2,0x07f3,
  0x07f4,0x07f5,0x07f6,0x07f7,0x07f8,0x07f9,0x07fa,0x07fb,
  0x07fc,0x07fd,0x07fe,0x07ff,0x0800,0x0801,0x0802,0x0803,
  0x0804,0x0805,0x0806,0x0807,0x0808,0x0809,0x080a,0x0000,
  0x080b,0x080c,0x080d,0x080e,0x080f,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x2810,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x4812,0x4815,0x0818,0x2819,0x0000,0x481b,0x481e,0x0821,
  0x0000,0x2822,0x0824,0x0825,0x0826,0x0827,0x0828,0x0829,
  0x082a,0x082b,0x082c,0x082d,0x0000,0x082e,0x282f,0x0000,
  0x0000,0x0831,0x0832,0x0833,0x0834,0x0835,0x0000,0x0000,
  0x2836,0x4838,0x283b,0x0000,0x083d,0x0000,0x083e,0x0000,
  0x083f,0x0000,0x0840,0x0841,0x0842,0x0843,0x0000,0x0844,
  0x0845,0x0846,0x0000,0x0847,0x0848,0x0849,0x084a,0x084b,
  0x084c,0x084d,0x0000,0x484e,0x0851,0x0852,0x0853,0x0854,
  0x0855,0x0000,0x0000,0x0000,0x0000,0x0856,0x0857,0x0858,
  0x0859,0x085a,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x485b,0x485e,0x4861,0x4864,0x4867,
  0x486a,0x486d,0x4870,0x4873,0x4876,0x4879,0x487c,0x287f,
  0x0881,0x2882,0x4884,0x2887,0x0889,0x288a,0x488c,0x688f,
  0x2893,0x0895,0x2896,0x4898,0x089b,0x089c,0x089d,0x089e,
  0x089f,0x28a0,0x48a2,0x28a5,0x08a7,0x28a8,0x48aa,0x68ad,
  0x28b1,0x08b3,0x28b4,0x48b6,0x08b9,0x08ba,0x08bb,0x08bc,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x28bd,0x28bf,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x28c1,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x28c3,0x28c5,0x28c7,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x28c9,0x0000,0x0000,0x0000,
  0x0000,0x28cb,0x0000,0x0000,0x28cd,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x28cf,0x0000,0x28d1,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x28d3,0x48d5,0x0000,0x28d8,
  0x48da,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x28dd,0x0000,0x0000,0x28df,0x0000,0x0000,0x28e1,
  0x0000,0x28e3,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x28e5,0x0000,0x28e7,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x28e9,0x28eb,0x28ed,
  0x28ef,0x28f1,0x0000,0x0000,0x28f3,0x28f5,0x0000,0x0000,
  0x28f7,0x28f9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x28fb,0x28fd,0x0000,0x0000,0x28ff,0x2901,0x0000,0x0000,
  0x2903,0x2905,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x2907,0x2909,0x290b,0x290d,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x290f,0x2911,0x2913,0x2915,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x2917,0x2919,0x291b,0x291d,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x091f,0x0920,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0921,0x0922,0x0923,0x0924,0x0925,0x0926,0x0927,0x0928,
  0x0929,0x292a,0x292c,0x292e,0x2930,0x2932,0x2934,0x2936,
  0x2938,0x293a,0x293c,0x293e,0x4940,0x4943,0x4946,0x4949,
  0x494c,0x494f,0x4952,0x4955,0x4958,0x695b,0x695f,0x6963,
  0x6967,0x696b,0x696f,0x6973,0x6977,0x697b,0x697f,0x6983,
  0x2987,0x2989,0x298b,0x298d,0x298f,0x2991,0x2993,0x2995,
  0x2997,0x4999,0x499c,0x499f,0x49a2,0x49a5,0x49a8,0x49ab,
  0x49ae,0x49b1,0x49b4,0x49b7,0x49ba,0x49bd,0x49c0,0x49c3,
  0x49c6,0x49c9,0x49cc,0x49cf,0x49d2,0x49d5,0x49d8,0x49db,
  0x49de,0x49e1,0x49e4,0x49e7,0x49ea,0x49ed,0x49f0,0x49f3,
  0x49f6,0x49f9,0x49fc,0x49ff,0x4a02,0x4a05,0x0a08,0x0a09,
  0x0a0a,0x0a0b,0x0a0c,0x0a0d,0x0a0e,0x0a0f,0x0a10,0x0a11,
  0x0a12,0x0a13,0x0a14,0x0a15,0x0a16,0x0a17,0x0a18,0x0a19,
  0x0a1a,0x0a1b,0x0a1c,0x0a1d,0x0a1e,0x0a1f,0x0a20,0x0a21,
  0x0a22,0x0a23,0x0a24,0x0a25,0x0a26,0x0a27,0x0a28,0x0a29,
  0x0a2a,0x0a2b,0x0a2c,0x0a2d,0x0a2e,0x0a2f,0x0a30,0x0a31,
  0x0a32,0x0a33,0x0a34,0x0a35,0x0a36,0x0a37,0x0a38,0x0a39,
  0x0a3a,0x0a3b,0x0a3c,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x6a3d,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x4a41,0x2a44,0x4a46,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x2a49,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0a4b,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0a4c,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0a4d,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0a4e,0x0a4f,0x0a50,0x0a51,0x0a52,0x0a53,0x0a54,0x0a55,
  0x0a56,0x0a57,0x0a58,0x0a59,0x0a5a,0x0a5b,0x0a5c,0x0a5d,
  0x0a5e,0x0a5f,0x0a60,0x0a61,0x0a62,0x0a63,0x0a64,0x0a65,
  0x0a66,0x0a67,0x0a68,0x0a69,0x0a6a,0x0a6b,0x0a6c,0x0a6d,
  0x0a6e,0x0a6f,0x0a70,0x0a71,0x0a72,0x0a73,0x0a74,0x0a75,
  0x0a76,0x0a77,0x0a78,0x0a79,0x0a7a,0x0a7b,0x0a7c,0x0a7d,
  0x0a7e,0x0a7f,0x0a80,0x0a81,0x0a82,0x0a83,0x0a84,0x0a85,
  0x0a86,0x0a87,0x0a88,0x0a89,0x0a8a,0x0a8b,0x0a8c,0x0a8d,
  0x0a8e,0x0a8f,0x0a90,0x0a91,0x0a92,0x0a93,0x0a94,0x0a95,
  0x0a96,0x0a97,0x0a98,0x0a99,0x0a9a,0x0a9b,0x0a9c,0x0a9d,
  0x0a9e,0x0a9f,0x0aa0,0x0aa1,0x0aa2,0x0aa3,0x0aa4,0x0aa5,
  0x0aa6,0x0aa7,0x0aa8,0x0aa9,0x0aaa,0x0aab,0x0aac,0x0aad,
  0x0aae,0x0aaf,0x0ab0,0x0ab1,0x0ab2,0x0ab3,0x0ab4,0x0ab5,
  0x0ab6,0x0ab7,0x0ab8,0x0ab9,0x0aba,0x0abb,0x0abc,0x0abd,
  0x0abe,0x0abf,0x0ac0,0x0ac1,0x0ac2,0x0ac3,0x0ac4,0x0ac5,
  0x0ac6,0x0ac7,0x0ac8,0x0ac9,0x0aca,0x0acb,0x0acc,0x0acd,
  0x0ace,0x0acf,0x0ad0,0x0ad1,0x0ad2,0x0ad3,0x0ad4,0x0ad5,
  0x0ad6,0x0ad7,0x0ad8,0x0ad9,0x0ada,0x0adb,0x0adc,0x0add,
  0x0ade,0x0adf,0x0ae0,0x0ae1,0x0ae2,0x0ae3,0x0ae4,0x0ae5,
  0x0ae6,0x0ae7,0x0ae8,0x0ae9,0x0aea,0x0aeb,0x0aec,0x0aed,
  0x0aee,0x0aef,0x0af0,0x0af1,0x0af2,0x0af3,0x0af4,0x0af5,
  0x0af6,0x0af7,0x0af8,0x0af9,0x0afa,0x0afb,0x0afc,0x0afd,
  0x0afe,0x0aff,0x0b00,0x0b01,0x0b02,0x0b03,0x0b04,0x0b05,
  0x0b06,0x0b07,0x0b08,0x0b09,0x0b0a,0x0b0b,0x0b0c,0x0b0d,
  0x0b0e,0x0b0f,0x0b10,0x0b11,0x0b12,0x0b13,0x0b14,0x0b15,
  0x0b16,0x0b17,0x0b18,0x0b19,0x0b1a,0x0b1b,0x0b1c,0x0b1d,
  0x0b1e,0x0b1f,0x0b20,0x0b21,0x0b22,0x0b23,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0b24,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0b25,0x0000,
  0x0b26,0x0b27,0x0b28,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x2b29,0x0000,0x2b2b,0x0000,
  0x2b2d,0x0000,0x2b2f,0x0000,0x2b31,0x0000,0x2b33,0x0000,
  0x2b35,0x0000,0x2b37,0x0000,0x2b39,0x0000,0x2b3b,0x0000,
  0x2b3d,0x0000,0x2b3f,0x0000,0x0000,0x2b41,0x0000,0x2b43,
  0x0000,0x2b45,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x2b47,0x2b49,0x0000,0x2b4b,0x2b4d,0x0000,0x2b4f,0x2b51,
  0x0000,0x2b53,0x2b55,0x0000,0x2b57,0x2b59,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x2b5b,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x2b5d,0x2b5f,0x0000,0x2b61,0x2b63,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x2b65,0x0000,0x2b67,0x0000,
  0x2b69,0x0000,0x2b6b,0x0000,0x2b6d,0x0000,0x2b6f,0x0000,
  0x2b71,0x0000,0x2b73,0x0000,0x2b75,0x0000,0x2b77,0x0000,
  0x2b79,0x0000,0x2b7b,0x0000,0x0000,0x2b7d,0x0000,0x2b7f,
  0x0000,0x2b81,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x2b83,0x2b85,0x0000,0x2b87,0x2b89,0x0000,0x2b8b,0x2b8d,
  0x0000,0x2b8f,0x2b91,0x0000,0x2b93,0x2b95,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x2b97,0x0000,0x0000,0x2b99,
  0x2b9b,0x2b9d,0x2b9f,0x0000,0x0000,0x0000,0x2ba1,0x2ba3,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0ba5,0x0ba6,0x0ba7,0x0ba8,0x0ba9,0x0baa,0x0bab,
  0x0bac,0x0bad,0x0bae,0x0baf,0x0bb0,0x0bb1,0x0bb2,0x0bb3,
  0x0bb4,0x0bb5,0x0bb6,0x0bb7,0x0bb8,0x0bb9,0x0bba,0x0bbb,
  0x0bbc,0x0bbd,0x0bbe,0x0bbf,0x0bc0,0x0bc1,0x0bc2,0x0bc3,
  0x0bc4,0x0bc5,0x0bc6,0x0bc7,0x0bc8,0x0bc9,0x0bca,0x0bcb,
  0x0bcc,0x0bcd,0x0bce,0x0bcf,0x0bd0,0x0bd1,0x0bd2,0x0bd3,
  0x0bd4,0x0bd5,0x0bd6,0x0bd7,0x0bd8,0x0bd9,0x0bda,0x0bdb,
  0x0bdc,0x0bdd,0x0bde,0x0bdf,0x0be0,0x0be1,0x0be2,0x0be3,
  0x0be4,0x0be5,0x0be6,0x0be7,0x0be8,0x0be9,0x0bea,0x0beb,
  0x0bec,0x0bed,0x0bee,0x0bef,0x0bf0,0x0bf1,0x0bf2,0x0bf3,
  0x0bf4,0x0bf5,0x0bf6,0x0bf7,0x0bf8,0x0bf9,0x0bfa,0x0bfb,
  0x0bfc,0x0bfd,0x0bfe,0x0bff,0x0c00,0x0c01,0x0c02,0x0000,
  0x0000,0x0000,0x0c03,0x0c04,0x0c05,0x0c06,0x0c07,0x0c08,
  0x0c09,0x0c0a,0x0c0b,0x0c0c,0x0c0d,0x0c0e,0x0c0f,0x0c10,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x4c11,0x4c14,0x4c17,0x4c1a,0x4c1d,0x4c20,0x4c23,0x4c26,
  0x4c29,0x4c2c,0x4c2f,0x4c32,0x4c35,0x4c38,0x6c3b,0x6c3f,
  0x6c43,0x6c47,0x6c4b,0x6c4f,0x6c53,0x6c57,0x6c5b,0x6c5f,
  0x6c63,0x6c67,0x6c6b,0x6c6f,0x6c73,0xcc77,0xac7e,0x0000,
  0x4c84,0x4c87,0x4c8a,0x4c8d,0x4c90,0x4c93,0x4c96,0x4c99,
  0x4c9c,0x4c9f,0x4ca2,0x4ca5,0x4ca8,0x4cab,0x4cae,0x4cb1,
  0x4cb4,0x4cb7,0x4cba,0x4cbd,0x4cc0,0x4cc3,0x4cc6,0x4cc9,
  0x4ccc,0x4ccf,0x4cd2,0x4cd5,0x4cd8,0x4cdb,0x4cde,0x4ce1,
  0x4ce4,0x4ce7,0x4cea,0x4ced,0x0000,0x0000,0x0000,0x0000,
  0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x4cf0,0x2cf3,0x2cf5,0x2cf7,0x2cf9,0x2cfb,0x2cfd,0x2cff,
  0x2d01,0x2d03,0x2d05,0x2d07,0x2d09,0x2d0b,0x2d0d,0x2d0f,
  0x0d11,0x0d12,0x0d13,0x0d14,0x0d15,0x0d16,0x0d17,0x0d18,
  0x0d19,0x0d1a,0x0d1b,0x0d1c,0x0d1d,0x0d1e,0x2d1f,0x2d21,
  0x2d23,0x2d25,0x2d27,0x2d29,0x2d2b,0x2d2d,0x2d2f,0x2d31,
  0x2d33,0x2d35,0x2d37,0x2d39,0x8d3b,0x6d40,0x2d44,0x0000,
  0x0d46,0x0d47,0x0d48,0x0d49,0x0d4a,0x0d4b,0x0d4c,0x0d4d,
  0x0d4e,0x0d4f,0x0d50,0x0d51,0x0d52,0x0d53,0x0d54,0x0d55,
  0x0d56,0x0d57,0x0d58,0x0d59,0x0d5a,0x0d5b,0x0d5c,0x0d5d,
  0x0d5e,0x0d5f,0x0d60,0x0d61,0x0d62,0x0d63,0x0d64,0x0d65,
  0x0d66,0x0d67,0x0d68,0x0d69,0x0d6a,0x0d6b,0x0d6c,0x0d6d,
  0x0d6e,0x0d6f,0x0d70,0x0d71,0x0d72,0x0d73,0x0d74,0x0d75,
  0x0d76,0x2d77,0x2d79,0x2d7b,0x2d7d,0x2d7f,0x2d81,0x2d83,
  0x2d85,0x2d87,0x2d89,0x2d8b,0x2d8d,0x2d8f,0x2d91,0x2d93,
  0x2d95,0x2d97,0x2d99,0x2d9b,0x2d9d,0x2d9f,0x2da1,0x2da3,
  0x2da5,0x4da7,0x4daa,0x4dad,0x2db0,0x4db2,0x2db5,0x4db7,
  0x0dba,0x0dbb,0x0dbc,0x0dbd,0x0dbe,0x0dbf,0x0dc0,0x0dc1,
  0x0dc2,0x0dc3,0x0dc4,0x0dc5,0x0dc6,0x0dc7,0x0dc8,0x0dc9,
  0x0dca,0x0dcb,0x0dcc,0x0dcd,0x0dce,0x0dcf,0x0dd0,0x0dd1,
  0x0dd2,0x0dd3,0x0dd4,0x0dd5,0x0dd6,0x0dd7,0x0dd8,0x0dd9,
  0x0dda,0x0ddb,0x0ddc,0x0ddd,0x0dde,0x0ddf,0x0de0,0x0de1,
  0x0de2,0x0de3,0x0de4,0x0de5,0x0de6,0x0de7,0x0de8,0x0000,
  0x6de9,0x6ded,0x6df1,0x4df5,0x6df8,0x4dfc,0x4dff,0x8e02,
  0x6e07,0x4e0b,0x4e0e,0x4e11,0x6e14,0x6e18,0x4e1c,0x4e1f,
  0x2e22,0x4e24,0x6e27,0x6e2b,0x2e2f,0x8e31,0xae36,0x8e3c,
  0x4e41,0x8e44,0x8e49,0x6e4e,0x4e52,0x4e55,0x4e58,0x6e5b,
  0x8e5f,0x6e64,0x4e68,0x4e6b,0x4e6e,0x2e71,0x2e73,0x2e75,
  0x2e77,0x4e79,0x4e7c,0x8e7f,0x4e84,0x6e87,0x8e8b,0x4e90,
  0x2e93,0x2e95,0x8e97,0x6e9c,0x8ea0,0x4ea5,0x8ea8,0x2ead,
  0x4eaf,0x4eb2,0x4eb5,0x4eb8,0x4ebb,0x6ebe,0x4ec2,0x2ec5,
  0x4ec7,0x4eca,0x4ecd,0x6ed0,0x4ed4,0x4ed7,0x4eda,0x8edd,
  0x6ee2,0x2ee6,0x8ee8,0x2eed,0x6eef,0x6ef3,0x4ef7,0x4efa,
  0x4efd,0x6f00,0x2f04,0x4f06,0x6f09,0x2f0d,0x8f0f,0x4f14,
  0x2f17,0x2f19,0x2f1b,0x2f1d,0x2f1f,0x2f21,0x2f23,0x2f25,
  0x2f27,0x2f29,0x4f2b,0x4f2e,0x4f31,0x4f34,0x4f37,0x4f3a,
  0x4f3d,0x4f40,0x4f43,0x4f46,0x4f49,0x4f4c,0x4f4f,0x4f52,
  0x4f55,0x4f58,0x2f5b,0x2f5d,0x4f5f,0x2f62,0x2f64,0x2f66,
  0x4f68,0x4f6b,0x2f6e,0x2f70,0x2f72,0x2f74,0x2f76,0x6f78,
  0x2f7c,0x2f7e,0x2f80,0x2f82,0x2f84,0x2f86,0x2f88,0x2f8a,
  0x4f8c,0x6f8f,0x2f93,0x2f95,0x2f97,0x2f99,0x2f9b,0x2f9d,
  0x2f9f,0x4fa1,0x4fa4,0x4fa7,0x4faa,0x2fad,0x2faf,0x2fb1,
  0x2fb3,0x2fb5,0x2fb7,0x2fb9,0x2fbb,0x2fbd,0x2fbf,0x4fc1,
  0x4fc4,0x2fc7,0x4fc9,0x4fcc,0x4fcf,0x2fd2,0x4fd4,0x4fd7,
  0x6fda,0x2fde,0x4fe0,0x4fe3,0x4fe6,0x4fe9,0x8fec,0xaff1,
  0x2ff7,0x2ff9,0x2ffb,0x2ffd,0x2fff,0x3001,0x3003,0x3005,
  0x3007,0x3009,0x300b,0x300d,0x300f,0x3011,0x3013,0x3015,
  0x3017,0x3019,0x701b,0x301f,0x3021,0x3023,0x7025,0x5029,
  0x302c,0x302e,0x3030,0x3032,0x3034,0x3036,0x3038,0x303a,
  0x303c,0x303e,0x5040,0x3043,0x3045,0x5047,0x504a,0x304d,
  0x704f,0x5053,0x3056,0x3058,0x305a,0x305c,0x505e,0x5061,
  0x3064,0x3066,0x3068,0x306a,0x306c,0x306e,0x3070,0x3072,
  0x3074,0x5076,0x5079,0x507c,0x507f,0x5082,0x5085,0x5088,
  0x508b,0x508e,0x5091,0x5094,0x5097,0x509a,0x509d,0x50a0,
  0x50a3,0x50a6,0x50a9,0x50ac,0x50af,0x50b2,0x50b5,0x50b8,
};

	/* BMP low decompositions */
static unsigned short ucs4_dbmplotab[4283] = {
  0x0020,0x0020,0x0308,0x0061,0x0020,0x0304,0x0032,0x0033,
  0x0020,0x0301,0x03bc,0x0020,0x0327,0x0031,0x006f,0x0031,
  0x2044,0x0034,0x0031,0x2044,0x0032,0x0033,0x2044,0x0034,
  0x0041,0x0300,0x0041,0x0301,0x0041,0x0302,0x0041,0x0303,
  0x0041,0x0308,0x0041,0x030a,0x0043,0x0327,0x0045,0x0300,
  0x0045,0x0301,0x0045,0x0302,0x0045,0x0308,0x0049,0x0300,
  0x0049,0x0301,0x0049,0x0302,0x0049,0x0308,0x004e,0x0303,
  0x004f,0x0300,0x004f,0x0301,0x004f,0x0302,0x004f,0x0303,
  0x004f,0x0308,0x0055,0x0300,0x0055,0x0301,0x0055,0x0302,
  0x0055,0x0308,0x0059,0x0301,0x0061,0x0300,0x0061,0x0301,
  0x0061,0x0302,0x0061,0x0303,0x0061,0x0308,0x0061,0x030a,
  0x0063,0x0327,0x0065,0x0300,0x0065,0x0301,0x0065,0x0302,
  0x0065,0x0308,0x0069,0x0300,0x0069,0x0301,0x0069,0x0302,
  0x0069,0x0308,0x006e,0x0303,0x006f,0x0300,0x006f,0x0301,
  0x006f,0x0302,0x006f,0x0303,0x006f,0x0308,0x0075,0x0300,
  0x0075,0x0301,0x0075,0x0302,0x0075,0x0308,0x0079,0x0301,
  0x0079,0x0308,0x0041,0x0304,0x0061,0x0304,0x0041,0x0306,
  0x0061,0x0306,0x0041,0x0328,0x0061,0x0328,0x0043,0x0301,
  0x0063,0x0301,0x0043,0x0302,0x0063,0x0302,0x0043,0x0307,
  0x0063,0x0307,0x0043,0x030c,0x0063,0x030c,0x0044,0x030c,
  0x0064,0x030c,0x0045,0x0304,0x0065,0x0304,0x0045,0x0306,
  0x0065,0x0306,0x0045,0x0307,0x0065,0x0307,0x0045,0x0328,
  0x0065,0x0328,0x0045,0x030c,0x0065,0x030c,0x0047,0x0302,
  0x0067,0x0302,0x0047,0x0306,0x0067,0x0306,0x0047,0x0307,
  0x0067,0x0307,0x0047,0x0327,0x0067,0x0327,0x0048,0x0302,
  0x0068,0x0302,0x0049,0x0303,0x0069,0x0303,0x0049,0x0304,
  0x0069,0x0304,0x0049,0x0306,0x0069,0x0306,0x0049,0x0328,
  0x0069,0x0328,0x0049,0x0307,0x0049,0x004a,0x0069,0x006a,
  0x004a,0x0302,0x006a,0x0302,0x004b,0x0327,0x006b,0x0327,
  0x004c,0x0301,0x006c,0x0301,0x004c,0x0327,0x006c,0x0327,
  0x004c,0x030c,0x006c,0x030c,0x004c,0x00b7,0x006c,0x00b7,
  0x004e,0x0301,0x006e,0x0301,0x004e,0x0327,0x006e,0x0327,
  0x004e,0x030c,0x006e,0x030c,0x02bc,0x006e,0x004f,0x0304,
  0x006f,0x0304,0x004f,0x0306,0x006f,0x0306,0x004f,0x030b,
  0x006f,0x030b,0x0052,0x0301,0x0072,0x0301,0x0052,0x0327,
  0x0072,0x0327,0x0052,0x030c,0x0072,0x030c,0x0053,0x0301,
  0x0073,0x0301,0x0053,0x0302,0x0073,0x0302,0x0053,0x0327,
  0x0073,0x0327,0x0053,0x030c,0x0073,0x030c,0x0054,0x0327,
  0x0074,0x0327,0x0054,0x030c,0x0074,0x030c,0x0055,0x0303,
  0x0075,0x0303,0x0055,0x0304,0x0075,0x0304,0x0055,0x0306,
  0x0075,0x0306,0x0055,0x030a,0x0075,0x030a,0x0055,0x030b,
  0x0075,0x030b,0x0055,0x0328,0x0075,0x0328,0x0057,0x0302,
  0x0077,0x0302,0x0059,0x0302,0x0079,0x0302,0x0059,0x0308,
  0x005a,0x0301,0x007a,0x0301,0x005a,0x0307,0x007a,0x0307,
  0x005a,0x030c,0x007a,0x030c,0x0073,0x004f,0x031b,0x006f,
  0x031b,0x0055,0x031b,0x0075,0x031b,0x0044,0x017d,0x0044,
  0x017e,0x0064,0x017e,0x004c,0x004a,0x004c,0x006a,0x006c,
  0x006a,0x004e,0x004a,0x004e,0x006a,0x006e,0x006a,0x0041,
  0x030c,0x0061,0x030c,0x0049,0x030c,0x0069,0x030c,0x004f,
  0x030c,0x006f,0x030c,0x0055,0x030c,0x0075,0x030c,0x00dc,
  0x0304,0x00fc,0x0304,0x00dc,0x0301,0x00fc,0x0301,0x00dc,
  0x030c,0x00fc,0x030c,0x00dc,0x0300,0x00fc,0x0300,0x00c4,
  0x0304,0x00e4,0x0304,0x0226,0x0304,0x0227,0x0304,0x00c6,
  0x0304,0x00e6,0x0304,0x0047,0x030c,0x0067,0x030c,0x004b,
  0x030c,0x006b,0x030c,0x004f,0x0328,0x006f,0x0328,0x01ea,
  0x0304,0x01eb,0x0304,0x01b7,0x030c,0x0292,0x030c,0x006a,
  0x030c,0x0044,0x005a,0x0044,0x007a,0x0064,0x007a,0x0047,
  0x0301,0x0067,0x0301,0x004e,0x0300,0x006e,0x0300,0x00c5,
  0x0301,0x00e5,0x0301,0x00c6,0x0301,0x00e6,0x0301,0x00d8,
  0x0301,0x00f8,0x0301,0x0041,0x030f,0x0061,0x030f,0x0041,
  0x0311,0x0061,0x0311,0x0045,0x030f,0x0065,0x030f,0x0045,
  0x0311,0x0065,0x0311,0x0049,0x030f,0x0069,0x030f,0x0049,
  0x0311,0x0069,0x0311,0x004f,0x030f,0x006f,0x030f,0x004f,
  0x0311,0x006f,0x0311,0x0052,0x030f,0x0072,0x030f,0x0052,
  0x0311,0x0072,0x0311,0x0055,0x030f,0x0075,0x030f,0x0055,
  0x0311,0x0075,0x0311,0x0053,0x0326,0x0073,0x0326,0x0054,
  0x0326,0x0074,0x0326,0x0048,0x030c,0x0068,0x030c,0x0041,
  0x0307,0x0061,0x0307,0x0045,0x0327,0x0065,0x0327,0x00d6,
  0x0304,0x00f6,0x0304,0x00d5,0x0304,0x00f5,0x0304,0x004f,
  0x0307,0x006f,0x0307,0x022e,0x0304,0x022f,0x0304,0x0059,
  0x0304,0x0079,0x0304,0x0068,0x0266,0x006a,0x0072,0x0279,
  0x027b,0x0281,0x0077,0x0079,0x0020,0x0306,0x0020,0x0307,
  0x0020,0x030a,0x0020,0x0328,0x0020,0x0303,0x0020,0x030b,
  0x0263,0x006c,0x0073,0x0078,0x0295,0x0300,0x0301,0x0313,
  0x0308,0x0301,0x02b9,0x0020,0x0345,0x003b,0x0020,0x0301,
  0x00a8,0x0301,0x0391,0x0301,0x00b7,0x0395,0x0301,0x0397,
  0x0301,0x0399,0x0301,0x039f,0x0301,0x03a5,0x0301,0x03a9,
  0x0301,0x03ca,0x0301,0x0399,0x0308,0x03a5,0x0308,0x03b1,
  0x0301,0x03b5,0x0301,0x03b7,0x0301,0x03b9,0x0301,0x03cb,
  0x0301,0x03b9,0x0308,0x03c5,0x0308,0x03bf,0x0301,0x03c5,
  0x0301,0x03c9,0x0301,0x03b2,0x03b8,0x03a5,0x03d2,0x0301,
  0x03d2,0x0308,0x03c6,0x03c0,0x03ba,0x03c1,0x03c2,0x0398,
  0x03b5,0x03a3,0x0415,0x0300,0x0415,0x0308,0x0413,0x0301,
  0x0406,0x0308,0x041a,0x0301,0x0418,0x0300,0x0423,0x0306,
  0x0418,0x0306,0x0438,0x0306,0x0435,0x0300,0x0435,0x0308,
  0x0433,0x0301,0x0456,0x0308,0x043a,0x0301,0x0438,0x0300,
  0x0443,0x0306,0x0474,0x030f,0x0475,0x030f,0x0416,0x0306,
  0x0436,0x0306,0x0410,0x0306,0x0430,0x0306,0x0410,0x0308,
  0x0430,0x0308,0x0415,0x0306,0x0435,0x0306,0x04d8,0x0308,
  0x04d9,0x0308,0x0416,0x0308,0x0436,0x0308,0x0417,0x0308,
  0x0437,0x0308,0x0418,0x0304,0x0438,0x0304,0x0418,0x0308,
  0x0438,0x0308,0x041e,0x0308,0x043e,0x0308,0x04e8,0x0308,
  0x04e9,0x0308,0x042d,0x0308,0x044d,0x0308,0x0423,0x0304,
  0x0443,0x0304,0x0423,0x0308,0x0443,0x0308,0x0423,0x030b,
  0x0443,0x030b,0x0427,0x0308,0x0447,0x0308,0x042b,0x0308,
  0x044b,0x0308,0x0565,0x0582,0x0627,0x0653,0x0627,0x0654,
  0x0648,0x0654,0x0627,0x0655,0x064a,0x0654,0x0627,0x0674,
  0x0648,0x0674,0x06c7,0x0674,0x064a,0x0674,0x06d5,0x0654,
  0x06c1,0x0654,0x06d2,0x0654,0x0928,0x093c,0x0930,0x093c,
  0x0933,0x093c,0x0915,0x093c,0x0916,0x093c,0x0917,0x093c,
  0x091c,0x093c,0x0921,0x093c,0x0922,0x093c,0x092b,0x093c,
  0x092f,0x093c,0x09c7,0x09be,0x09c7,0x09d7,0x09a1,0x09bc,
  0x09a2,0x09bc,0x09af,0x09bc,0x0a32,0x0a3c,0x0a38,0x0a3c,
  0x0a16,0x0a3c,0x0a17,0x0a3c,0x0a1c,0x0a3c,0x0a2b,0x0a3c,
  0x0b47,0x0b56,0x0b47,0x0b3e,0x0b47,0x0b57,0x0b21,0x0b3c,
  0x0b22,0x0b3c,0x0b92,0x0bd7,0x0bc6,0x0bbe,0x0bc7,0x0bbe,
  0x0bc6,0x0bd7,0x0c46,0x0c56,0x0cbf,0x0cd5,0x0cc6,0x0cd5,
  0x0cc6,0x0cd6,0x0cc6,0x0cc2,0x0cca,0x0cd5,0x0d46,0x0d3e,
  0x0d47,0x0d3e,0x0d46,0x0d57,0x0dd9,0x0dca,0x0dd9,0x0dcf,
  0x0ddc,0x0dca,0x0dd9,0x0ddf,0x0e4d,0x0e32,0x0ecd,0x0eb2,
  0x0eab,0x0e99,0x0eab,0x0ea1,0x0f0b,0x0f42,0x0fb7,0x0f4c,
  0x0fb7,0x0f51,0x0fb7,0x0f56,0x0fb7,0x0f5b,0x0fb7,0x0f40,
  0x0fb5,0x0f71,0x0f72,0x0f71,0x0f74,0x0fb2,0x0f80,0x0fb2,
  0x0f81,0x0fb3,0x0f80,0x0fb3,0x0f81,0x0f71,0x0f80,0x0f92,
  0x0fb7,0x0f9c,0x0fb7,0x0fa1,0x0fb7,0x0fa6,0x0fb7,0x0fab,
  0x0fb7,0x0f90,0x0fb5,0x1025,0x102e,0x10dc,0x1b05,0x1b35,
  0x1b07,0x1b35,0x1b09,0x1b35,0x1b0b,0x1b35,0x1b0d,0x1b35,
  0x1b11,0x1b35,0x1b3a,0x1b35,0x1b3c,0x1b35,0x1b3e,0x1b35,
  0x1b3f,0x1b35,0x1b42,0x1b35,0x0041,0x00c6,0x0042,0x0044,
  0x0045,0x018e,0x0047,0x0048,0x0049,0x004a,0x004b,0x004c,
  0x004d,0x004e,0x004f,0x0222,0x0050,0x0052,0x0054,0x0055,
  0x0057,0x0061,0x0250,0x0251,0x1d02,0x0062,0x0064,0x0065,
  0x0259,0x025b,0x025c,0x0067,0x006b,0x006d,0x014b,0x006f,
  0x0254,0x1d16,0x1d17,0x0070,0x0074,0x0075,0x1d1d,0x026f,
  0x0076,0x1d25,0x03b2,0x03b3,0x03b4,0x03c6,0x03c7,0x0069,
  0x0072,0x0075,0x0076,0x03b2,0x03b3,0x03c1,0x03c6,0x03c7,
  0x043d,0x0252,0x0063,0x0255,0x00f0,0x025c,0x0066,0x025f,
  0x0261,0x0265,0x0268,0x0269,0x026a,0x1d7b,0x029d,0x026d,
  0x1d85,0x029f,0x0271,0x0270,0x0272,0x0273,0x0274,0x0275,
  0x0278,0x0282,0x0283,0x01ab,0x0289,0x028a,0x1d1c,0x028b,
  0x028c,0x007a,0x0290,0x0291,0x0292,0x03b8,0x0041,0x0325,
  0x0061,0x0325,0x0042,0x0307,0x0062,0x0307,0x0042,0x0323,
  0x0062,0x0323,0x0042,0x0331,0x0062,0x0331,0x00c7,0x0301,
  0x00e7,0x0301,0x0044,0x0307,0x0064,0x0307,0x0044,0x0323,
  0x0064,0x0323,0x0044,0x0331,0x0064,0x0331,0x0044,0x0327,
  0x0064,0x0327,0x0044,0x032d,0x0064,0x032d,0x0112,0x0300,
  0x0113,0x0300,0x0112,0x0301,0x0113,0x0301,0x0045,0x032d,
  0x0065,0x032d,0x0045,0x0330,0x0065,0x0330,0x0228,0x0306,
  0x0229,0x0306,0x0046,0x0307,0x0066,0x0307,0x0047,0x0304,
  0x0067,0x0304,0x0048,0x0307,0x0068,0x0307,0x0048,0x0323,
  0x0068,0x0323,0x0048,0x0308,0x0068,0x0308,0x0048,0x0327,
  0x0068,0x0327,0x0048,0x032e,0x0068,0x032e,0x0049,0x0330,
  0x0069,0x0330,0x00cf,0x0301,0x00ef,0x0301,0x004b,0x0301,
  0x006b,0x0301,0x004b,0x0323,0x006b,0x0323,0x004b,0x0331,
  0x006b,0x0331,0x004c,0x0323,0x006c,0x0323,0x1e36,0x0304,
  0x1e37,0x0304,0x004c,0x0331,0x006c,0x0331,0x004c,0x032d,
  0x006c,0x032d,0x004d,0x0301,0x006d,0x0301,0x004d,0x0307,
  0x006d,0x0307,0x004d,0x0323,0x006d,0x0323,0x004e,0x0307,
  0x006e,0x0307,0x004e,0x0323,0x006e,0x0323,0x004e,0x0331,
  0x006e,0x0331,0x004e,0x032d,0x006e,0x032d,0x00d5,0x0301,
  0x00f5,0x0301,0x00d5,0x0308,0x00f5,0x0308,0x014c,0x0300,
  0x014d,0x0300,0x014c,0x0301,0x014d,0x0301,0x0050,0x0301,
  0x0070,0x0301,0x0050,0x0307,0x0070,0x0307,0x0052,0x0307,
  0x0072,0x0307,0x0052,0x0323,0x0072,0x0323,0x1e5a,0x0304,
  0x1e5b,0x0304,0x0052,0x0331,0x0072,0x0331,0x0053,0x0307,
  0x0073,0x0307,0x0053,0x0323,0x0073,0x0323,0x015a,0x0307,
  0x015b,0x0307,0x0160,0x0307,0x0161,0x0307,0x1e62,0x0307,
  0x1e63,0x0307,0x0054,0x0307,0x0074,0x0307,0x0054,0x0323,
  0x0074,0x0323,0x0054,0x0331,0x0074,0x0331,0x0054,0x032d,
  0x0074,0x032d,0x0055,0x0324,0x0075,0x0324,0x0055,0x0330,
  0x0075,0x0330,0x0055,0x032d,0x0075,0x032d,0x0168,0x0301,
  0x0169,0x0301,0x016a,0x0308,0x016b,0x0308,0x0056,0x0303,
  0x0076,0x0303,0x0056,0x0323,0x0076,0x0323,0x0057,0x0300,
  0x0077,0x0300,0x0057,0x0301,0x0077,0x0301,0x0057,0x0308,
  0x0077,0x0308,0x0057,0x0307,0x0077,0x0307,0x0057,0x0323,
  0x0077,0x0323,0x0058,0x0307,0x0078,0x0307,0x0058,0x0308,
  0x0078,0x0308,0x0059,0x0307,0x0079,0x0307,0x005a,0x0302,
  0x007a,0x0302,0x005a,0x0323,0x007a,0x0323,0x005a,0x0331,
  0x007a,0x0331,0x0068,0x0331,0x0074,0x0308,0x0077,0x030a,
  0x0079,0x030a,0x0061,0x02be,0x017f,0x0307,0x0041,0x0323,
  0x0061,0x0323,0x0041,0x0309,0x0061,0x0309,0x00c2,0x0301,
  0x00e2,0x0301,0x00c2,0x0300,0x00e2,0x0300,0x00c2,0x0309,
  0x00e2,0x0309,0x00c2,0x0303,0x00e2,0x0303,0x1ea0,0x0302,
  0x1ea1,0x0302,0x0102,0x0301,0x0103,0x0301,0x0102,0x0300,
  0x0103,0x0300,0x0102,0x0309,0x0103,0x0309,0x0102,0x0303,
  0x0103,0x0303,0x1ea0,0x0306,0x1ea1,0x0306,0x0045,0x0323,
  0x0065,0x0323,0x0045,0x0309,0x0065,0x0309,0x0045,0x0303,
  0x0065,0x0303,0x00ca,0x0301,0x00ea,0x0301,0x00ca,0x0300,
  0x00ea,0x0300,0x00ca,0x0309,0x00ea,0x0309,0x00ca,0x0303,
  0x00ea,0x0303,0x1eb8,0x0302,0x1eb9,0x0302,0x0049,0x0309,
  0x0069,0x0309,0x0049,0x0323,0x0069,0x0323,0x004f,0x0323,
  0x006f,0x0323,0x004f,0x0309,0x006f,0x0309,0x00d4,0x0301,
  0x00f4,0x0301,0x00d4,0x0300,0x00f4,0x0300,0x00d4,0x0309,
  0x00f4,0x0309,0x00d4,0x0303,0x00f4,0x0303,0x1ecc,0x0302,
  0x1ecd,0x0302,0x01a0,0x0301,0x01a1,0x0301,0x01a0,0x0300,
  0x01a1,0x0300,0x01a0,0x0309,0x01a1,0x0309,0x01a0,0x0303,
  0x01a1,0x0303,0x01a0,0x0323,0x01a1,0x0323,0x0055,0x0323,
  0x0075,0x0323,0x0055,0x0309,0x0075,0x0309,0x01af,0x0301,
  0x01b0,0x0301,0x01af,0x0300,0x01b0,0x0300,0x01af,0x0309,
  0x01b0,0x0309,0x01af,0x0303,0x01b0,0x0303,0x01af,0x0323,
  0x01b0,0x0323,0x0059,0x0300,0x0079,0x0300,0x0059,0x0323,
  0x0079,0x0323,0x0059,0x0309,0x0079,0x0309,0x0059,0x0303,
  0x0079,0x0303,0x03b1,0x0313,0x03b1,0x0314,0x1f00,0x0300,
  0x1f01,0x0300,0x1f00,0x0301,0x1f01,0x0301,0x1f00,0x0342,
  0x1f01,0x0342,0x0391,0x0313,0x0391,0x0314,0x1f08,0x0300,
  0x1f09,0x0300,0x1f08,0x0301,0x1f09,0x0301,0x1f08,0x0342,
  0x1f09,0x0342,0x03b5,0x0313,0x03b5,0x0314,0x1f10,0x0300,
  0x1f11,0x0300,0x1f10,0x0301,0x1f11,0x0301,0x0395,0x0313,
  0x0395,0x0314,0x1f18,0x0300,0x1f19,0x0300,0x1f18,0x0301,
  0x1f19,0x0301,0x03b7,0x0313,0x03b7,0x0314,0x1f20,0x0300,
  0x1f21,0x0300,0x1f20,0x0301,0x1f21,0x0301,0x1f20,0x0342,
  0x1f21,0x0342,0x0397,0x0313,0x0397,0x0314,0x1f28,0x0300,
  0x1f29,0x0300,0x1f28,0x0301,0x1f29,0x0301,0x1f28,0x0342,
  0x1f29,0x0342,0x03b9,0x0313,0x03b9,0x0314,0x1f30,0x0300,
  0x1f31,0x0300,0x1f30,0x0301,0x1f31,0x0301,0x1f30,0x0342,
  0x1f31,0x0342,0x0399,0x0313,0x0399,0x0314,0x1f38,0x0300,
  0x1f39,0x0300,0x1f38,0x0301,0x1f39,0x0301,0x1f38,0x0342,
  0x1f39,0x0342,0x03bf,0x0313,0x03bf,0x0314,0x1f40,0x0300,
  0x1f41,0x0300,0x1f40,0x0301,0x1f41,0x0301,0x039f,0x0313,
  0x039f,0x0314,0x1f48,0x0300,0x1f49,0x0300,0x1f48,0x0301,
  0x1f49,0x0301,0x03c5,0x0313,0x03c5,0x0314,0x1f50,0x0300,
  0x1f51,0x0300,0x1f50,0x0301,0x1f51,0x0301,0x1f50,0x0342,
  0x1f51,0x0342,0x03a5,0x0314,0x1f59,0x0300,0x1f59,0x0301,
  0x1f59,0x0342,0x03c9,0x0313,0x03c9,0x0314,0x1f60,0x0300,
  0x1f61,0x0300,0x1f60,0x0301,0x1f61,0x0301,0x1f60,0x0342,
  0x1f61,0x0342,0x03a9,0x0313,0x03a9,0x0314,0x1f68,0x0300,
  0x1f69,0x0300,0x1f68,0x0301,0x1f69,0x0301,0x1f68,0x0342,
  0x1f69,0x0342,0x03b1,0x0300,0x03ac,0x03b5,0x0300,0x03ad,
  0x03b7,0x0300,0x03ae,0x03b9,0x0300,0x03af,0x03bf,0x0300,
  0x03cc,0x03c5,0x0300,0x03cd,0x03c9,0x0300,0x03ce,0x1f00,
  0x0345,0x1f01,0x0345,0x1f02,0x0345,0x1f03,0x0345,0x1f04,
  0x0345,0x1f05,0x0345,0x1f06,0x0345,0x1f07,0x0345,0x1f08,
  0x0345,0x1f09,0x0345,0x1f0a,0x0345,0x1f0b,0x0345,0x1f0c,
  0x0345,0x1f0d,0x0345,0x1f0e,0x0345,0x1f0f,0x0345,0x1f20,
  0x0345,0x1f21,0x0345,0x1f22,0x0345,0x1f23,0x0345,0x1f24,
  0x0345,0x1f25,0x0345,0x1f26,0x0345,0x1f27,0x0345,0x1f28,
  0x0345,0x1f29,0x0345,0x1f2a,0x0345,0x1f2b,0x0345,0x1f2c,
  0x0345,0x1f2d,0x0345,0x1f2e,0x0345,0x1f2f,0x0345,0x1f60,
  0x0345,0x1f61,0x0345,0x1f62,0x0345,0x1f63,0x0345,0x1f64,
  0x0345,0x1f65,0x0345,0x1f66,0x0345,0x1f67,0x0345,0x1f68,
  0x0345,0x1f69,0x0345,0x1f6a,0x0345,0x1f6b,0x0345,0x1f6c,
  0x0345,0x1f6d,0x0345,0x1f6e,0x0345,0x1f6f,0x0345,0x03b1,
  0x0306,0x03b1,0x0304,0x1f70,0x0345,0x03b1,0x0345,0x03ac,
  0x0345,0x03b1,0x0342,0x1fb6,0x0345,0x0391,0x0306,0x0391,
  0x0304,0x0391,0x0300,0x0386,0x0391,0x0345,0x0020,0x0313,
  0x03b9,0x0020,0x0313,0x0020,0x0342,0x00a8,0x0342,0x1f74,
  0x0345,0x03b7,0x0345,0x03ae,0x0345,0x03b7,0x0342,0x1fc6,
  0x0345,0x0395,0x0300,0x0388,0x0397,0x0300,0x0389,0x0397,
  0x0345,0x1fbf,0x0300,0x1fbf,0x0301,0x1fbf,0x0342,0x03b9,
  0x0306,0x03b9,0x0304,0x03ca,0x0300,0x0390,0x03b9,0x0342,
  0x03ca,0x0342,0x0399,0x0306,0x0399,0x0304,0x0399,0x0300,
  0x038a,0x1ffe,0x0300,0x1ffe,0x0301,0x1ffe,0x0342,0x03c5,
  0x0306,0x03c5,0x0304,0x03cb,0x0300,0x03b0,0x03c1,0x0313,
  0x03c1,0x0314,0x03c5,0x0342,0x03cb,0x0342,0x03a5,0x0306,
  0x03a5,0x0304,0x03a5,0x0300,0x038e,0x03a1,0x0314,0x00a8,
  0x0300,0x0385,0x0060,0x1f7c,0x0345,0x03c9,0x0345,0x03ce,
  0x0345,0x03c9,0x0342,0x1ff6,0x0345,0x039f,0x0300,0x038c,
  0x03a9,0x0300,0x038f,0x03a9,0x0345,0x00b4,0x0020,0x0314,
  0x2002,0x2003,0x0020,0x0020,0x0020,0x0020,0x0020,0x0020,
  0x0020,0x0020,0x0020,0x2010,0x0020,0x0333,0x002e,0x002e,
  0x002e,0x002e,0x002e,0x002e,0x0020,0x2032,0x2032,0x2032,
  0x2032,0x2032,0x2035,0x2035,0x2035,0x2035,0x2035,0x0021,
  0x0021,0x0020,0x0305,0x003f,0x003f,0x003f,0x0021,0x0021,
  0x003f,0x2032,0x2032,0x2032,0x2032,0x0020,0x0030,0x0069,
  0x0034,0x0035,0x0036,0x0037,0x0038,0x0039,0x002b,0x2212,
  0x003d,0x0028,0x0029,0x006e,0x0030,0x0031,0x0032,0x0033,
  0x0034,0x0035,0x0036,0x0037,0x0038,0x0039,0x002b,0x2212,
  0x003d,0x0028,0x0029,0x0061,0x0065,0x006f,0x0078,0x0259,
  0x0052,0x0073,0x0061,0x002f,0x0063,0x0061,0x002f,0x0073,
  0x0043,0x00b0,0x0043,0x0063,0x002f,0x006f,0x0063,0x002f,
  0x0075,0x0190,0x00b0,0x0046,0x0067,0x0048,0x0048,0x0048,
  0x0068,0x0127,0x0049,0x0049,0x004c,0x006c,0x004e,0x004e,
  0x006f,0x0050,0x0051,0x0052,0x0052,0x0052,0x0053,0x004d,
  0x0054,0x0045,0x004c,0x0054,0x004d,0x005a,0x03a9,0x005a,
  0x004b,0x00c5,0x0042,0x0043,0x0065,0x0045,0x0046,0x004d,
  0x006f,0x05d0,0x05d1,0x05d2,0x05d3,0x0069,0x0046,0x0041,
  0x0058,0x03c0,0x03b3,0x0393,0x03a0,0x2211,0x0044,0x0064,
  0x0065,0x0069,0x006a,0x0031,0x2044,0x0033,0x0032,0x2044,
  0x0033,0x0031,0x2044,0x0035,0x0032,0x2044,0x0035,0x0033,
  0x2044,0x0035,0x0034,0x2044,0x0035,0x0031,0x2044,0x0036,
  0x0035,0x2044,0x0036,0x0031,0x2044,0x0038,0x0033,0x2044,
  0x0038,0x0035,0x2044,0x0038,0x0037,0x2044,0x0038,0x0031,
  0x2044,0x0049,0x0049,0x0049,0x0049,0x0049,0x0049,0x0049,
  0x0056,0x0056,0x0056,0x0049,0x0056,0x0049,0x0049,0x0056,
  0x0049,0x0049,0x0049,0x0049,0x0058,0x0058,0x0058,0x0049,
  0x0058,0x0049,0x0049,0x004c,0x0043,0x0044,0x004d,0x0069,
  0x0069,0x0069,0x0069,0x0069,0x0069,0x0069,0x0076,0x0076,
  0x0076,0x0069,0x0076,0x0069,0x0069,0x0076,0x0069,0x0069,
  0x0069,0x0069,0x0078,0x0078,0x0078,0x0069,0x0078,0x0069,
  0x0069,0x006c,0x0063,0x0064,0x006d,0x2190,0x0338,0x2192,
  0x0338,0x2194,0x0338,0x21d0,0x0338,0x21d4,0x0338,0x21d2,
  0x0338,0x2203,0x0338,0x2208,0x0338,0x220b,0x0338,0x2223,
  0x0338,0x2225,0x0338,0x222b,0x222b,0x222b,0x222b,0x222b,
  0x222e,0x222e,0x222e,0x222e,0x222e,0x223c,0x0338,0x2243,
  0x0338,0x2245,0x0338,0x2248,0x0338,0x003d,0x0338,0x2261,
  0x0338,0x224d,0x0338,0x003c,0x0338,0x003e,0x0338,0x2264,
  0x0338,0x2265,0x0338,0x2272,0x0338,0x2273,0x0338,0x2276,
  0x0338,0x2277,0x0338,0x227a,0x0338,0x227b,0x0338,0x2282,
  0x0338,0x2283,0x0338,0x2286,0x0338,0x2287,0x0338,0x22a2,
  0x0338,0x22a8,0x0338,0x22a9,0x0338,0x22ab,0x0338,0x227c,
  0x0338,0x227d,0x0338,0x2291,0x0338,0x2292,0x0338,0x22b2,
  0x0338,0x22b3,0x0338,0x22b4,0x0338,0x22b5,0x0338,0x3008,
  0x3009,0x0031,0x0032,0x0033,0x0034,0x0035,0x0036,0x0037,
  0x0038,0x0039,0x0031,0x0030,0x0031,0x0031,0x0031,0x0032,
  0x0031,0x0033,0x0031,0x0034,0x0031,0x0035,0x0031,0x0036,
  0x0031,0x0037,0x0031,0x0038,0x0031,0x0039,0x0032,0x0030,
  0x0028,0x0031,0x0029,0x0028,0x0032,0x0029,0x0028,0x0033,
  0x0029,0x0028,0x0034,0x0029,0x0028,0x0035,0x0029,0x0028,
  0x0036,0x0029,0x0028,0x0037,0x0029,0x0028,0x0038,0x0029,
  0x0028,0x0039,0x0029,0x0028,0x0031,0x0030,0x0029,0x0028,
  0x0031,0x0031,0x0029,0x0028,0x0031,0x0032,0x0029,0x0028,
  0x0031,0x0033,0x0029,0x0028,0x0031,0x0034,0x0029,0x0028,
  0x0031,0x0035,0x0029,0x0028,0x0031,0x0036,0x0029,0x0028,
  0x0031,0x0037,0x0029,0x0028,0x0031,0x0038,0x0029,0x0028,
  0x0031,0x0039,0x0029,0x0028,0x0032,0x0030,0x0029,0x0031,
  0x002e,0x0032,0x002e,0x0033,0x002e,0x0034,0x002e,0x0035,
  0x002e,0x0036,0x002e,0x0037,0x002e,0x0038,0x002e,0x0039,
  0x002e,0x0031,0x0030,0x002e,0x0031,0x0031,0x002e,0x0031,
  0x0032,0x002e,0x0031,0x0033,0x002e,0x0031,0x0034,0x002e,
  0x0031,0x0035,0x002e,0x0031,0x0036,0x002e,0x0031,0x0037,
  0x002e,0x0031,0x0038,0x002e,0x0031,0x0039,0x002e,0x0032,
  0x0030,0x002e,0x0028,0x0061,0x0029,0x0028,0x0062,0x0029,
  0x0028,0x0063,0x0029,0x0028,0x0064,0x0029,0x0028,0x0065,
  0x0029,0x0028,0x0066,0x0029,0x0028,0x0067,0x0029,0x0028,
  0x0068,0x0029,0x0028,0x0069,0x0029,0x0028,0x006a,0x0029,
  0x0028,0x006b,0x0029,0x0028,0x006c,0x0029,0x0028,0x006d,
  0x0029,0x0028,0x006e,0x0029,0x0028,0x006f,0x0029,0x0028,
  0x0070,0x0029,0x0028,0x0071,0x0029,0x0028,0x0072,0x0029,
  0x0028,0x0073,0x0029,0x0028,0x0074,0x0029,0x0028,0x0075,
  0x0029,0x0028,0x0076,0x0029,0x0028,0x0077,0x0029,0x0028,
  0x0078,0x0029,0x0028,0x0079,0x0029,0x0028,0x007a,0x0029,
  0x0041,0x0042,0x0043,0x0044,0x0045,0x0046,0x0047,0x0048,
  0x0049,0x004a,0x004b,0x004c,0x004d,0x004e,0x004f,0x0050,
  0x0051,0x0052,0x0053,0x0054,0x0055,0x0056,0x0057,0x0058,
  0x0059,0x005a,0x0061,0x0062,0x0063,0x0064,0x0065,0x0066,
  0x0067,0x0068,0x0069,0x006a,0x006b,0x006c,0x006d,0x006e,
  0x006f,0x0070,0x0071,0x0072,0x0073,0x0074,0x0075,0x0076,
  0x0077,0x0078,0x0079,0x007a,0x0030,0x222b,0x222b,0x222b,
  0x222b,0x003a,0x003a,0x003d,0x003d,0x003d,0x003d,0x003d,
  0x003d,0x2add,0x0338,0x2d61,0x6bcd,0x9f9f,0x4e00,0x4e28,
  0x4e36,0x4e3f,0x4e59,0x4e85,0x4e8c,0x4ea0,0x4eba,0x513f,
  0x5165,0x516b,0x5182,0x5196,0x51ab,0x51e0,0x51f5,0x5200,
  0x529b,0x52f9,0x5315,0x531a,0x5338,0x5341,0x535c,0x5369,
  0x5382,0x53b6,0x53c8,0x53e3,0x56d7,0x571f,0x58eb,0x5902,
  0x590a,0x5915,0x5927,0x5973,0x5b50,0x5b80,0x5bf8,0x5c0f,
  0x5c22,0x5c38,0x5c6e,0x5c71,0x5ddb,0x5de5,0x5df1,0x5dfe,
  0x5e72,0x5e7a,0x5e7f,0x5ef4,0x5efe,0x5f0b,0x5f13,0x5f50,
  0x5f61,0x5f73,0x5fc3,0x6208,0x6236,0x624b,0x652f,0x6534,
  0x6587,0x6597,0x65a4,0x65b9,0x65e0,0x65e5,0x66f0,0x6708,
  0x6728,0x6b20,0x6b62,0x6b79,0x6bb3,0x6bcb,0x6bd4,0x6bdb,
  0x6c0f,0x6c14,0x6c34,0x706b,0x722a,0x7236,0x723b,0x723f,
  0x7247,0x7259,0x725b,0x72ac,0x7384,0x7389,0x74dc,0x74e6,
  0x7518,0x751f,0x7528,0x7530,0x758b,0x7592,0x7676,0x767d,
  0x76ae,0x76bf,0x76ee,0x77db,0x77e2,0x77f3,0x793a,0x79b8,
  0x79be,0x7a74,0x7acb,0x7af9,0x7c73,0x7cf8,0x7f36,0x7f51,
  0x7f8a,0x7fbd,0x8001,0x800c,0x8012,0x8033,0x807f,0x8089,
  0x81e3,0x81ea,0x81f3,0x81fc,0x820c,0x821b,0x821f,0x826e,
  0x8272,0x8278,0x864d,0x866b,0x8840,0x884c,0x8863,0x897e,
  0x898b,0x89d2,0x8a00,0x8c37,0x8c46,0x8c55,0x8c78,0x8c9d,
  0x8d64,0x8d70,0x8db3,0x8eab,0x8eca,0x8f9b,0x8fb0,0x8fb5,
  0x9091,0x9149,0x91c6,0x91cc,0x91d1,0x9577,0x9580,0x961c,
  0x96b6,0x96b9,0x96e8,0x9751,0x975e,0x9762,0x9769,0x97cb,
  0x97ed,0x97f3,0x9801,0x98a8,0x98db,0x98df,0x9996,0x9999,
  0x99ac,0x9aa8,0x9ad8,0x9adf,0x9b25,0x9b2f,0x9b32,0x9b3c,
  0x9b5a,0x9ce5,0x9e75,0x9e7f,0x9ea5,0x9ebb,0x9ec3,0x9ecd,
  0x9ed1,0x9ef9,0x9efd,0x9f0e,0x9f13,0x9f20,0x9f3b,0x9f4a,
  0x9f52,0x9f8d,0x9f9c,0x9fa0,0x0020,0x3012,0x5341,0x5344,
  0x5345,0x304b,0x3099,0x304d,0x3099,0x304f,0x3099,0x3051,
  0x3099,0x3053,0x3099,0x3055,0x3099,0x3057,0x3099,0x3059,
  0x3099,0x305b,0x3099,0x305d,0x3099,0x305f,0x3099,0x3061,
  0x3099,0x3064,0x3099,0x3066,0x3099,0x3068,0x3099,0x306f,
  0x3099,0x306f,0x309a,0x3072,0x3099,0x3072,0x309a,0x3075,
  0x3099,0x3075,0x309a,0x3078,0x3099,0x3078,0x309a,0x307b,
  0x3099,0x307b,0x309a,0x3046,0x3099,0x0020,0x3099,0x0020,
  0x309a,0x309d,0x3099,0x3088,0x308a,0x30ab,0x3099,0x30ad,
  0x3099,0x30af,0x3099,0x30b1,0x3099,0x30b3,0x3099,0x30b5,
  0x3099,0x30b7,0x3099,0x30b9,0x3099,0x30bb,0x3099,0x30bd,
  0x3099,0x30bf,0x3099,0x30c1,0x3099,0x30c4,0x3099,0x30c6,
  0x3099,0x30c8,0x3099,0x30cf,0x3099,0x30cf,0x309a,0x30d2,
  0x3099,0x30d2,0x309a,0x30d5,0x3099,0x30d5,0x309a,0x30d8,
  0x3099,0x30d8,0x309a,0x30db,0x3099,0x30db,0x309a,0x30a6,
  0x3099,0x30ef,0x3099,0x30f0,0x3099,0x30f1,0x3099,0x30f2,
  0x3099,0x30fd,0x3099,0x30b3,0x30c8,0x1100,0x1101,0x11aa,
  0x1102,0x11ac,0x11ad,0x1103,0x1104,0x1105,0x11b0,0x11b1,
  0x11b2,0x11b3,0x11b4,0x11b5,0x111a,0x1106,0x1107,0x1108,
  0x1121,0x1109,0x110a,0x110b,0x110c,0x110d,0x110e,0x110f,
  0x1110,0x1111,0x1112,0x1161,0x1162,0x1163,0x1164,0x1165,
  0x1166,0x1167,0x1168,0x1169,0x116a,0x116b,0x116c,0x116d,
  0x116e,0x116f,0x1170,0x1171,0x1172,0x1173,0x1174,0x1175,
  0x1160,0x1114,0x1115,0x11c7,0x11c8,0x11cc,0x11ce,0x11d3,
  0x11d7,0x11d9,0x111c,0x11dd,0x11df,0x111d,0x111e,0x1120,
  0x1122,0x1123,0x1127,0x1129,0x112b,0x112c,0x112d,0x112e,
  0x112f,0x1132,0x1136,0x1140,0x1147,0x114c,0x11f1,0x11f2,
  0x1157,0x1158,0x1159,0x1184,0x1185,0x1188,0x1191,0x1192,
  0x1194,0x119e,0x11a1,0x4e00,0x4e8c,0x4e09,0x56db,0x4e0a,
  0x4e2d,0x4e0b,0x7532,0x4e59,0x4e19,0x4e01,0x5929,0x5730,
  0x4eba,0x0028,0x1100,0x0029,0x0028,0x1102,0x0029,0x0028,
  0x1103,0x0029,0x0028,0x1105,0x0029,0x0028,0x1106,0x0029,
  0x0028,0x1107,0x0029,0x0028,0x1109,0x0029,0x0028,0x110b,
  0x0029,0x0028,0x110c,0x0029,0x0028,0x110e,0x0029,0x0028,
  0x110f,0x0029,0x0028,0x1110,0x0029,0x0028,0x1111,0x0029,
  0x0028,0x1112,0x0029,0x0028,0x1100,0x1161,0x0029,0x0028,
  0x1102,0x1161,0x0029,0x0028,0x1103,0x1161,0x0029,0x0028,
  0x1105,0x1161,0x0029,0x0028,0x1106,0x1161,0x0029,0x0028,
  0x1107,0x1161,0x0029,0x0028,0x1109,0x1161,0x0029,0x0028,
  0x110b,0x1161,0x0029,0x0028,0x110c,0x1161,0x0029,0x0028,
  0x110e,0x1161,0x0029,0x0028,0x110f,0x1161,0x0029,0x0028,
  0x1110,0x1161,0x0029,0x0028,0x1111,0x1161,0x0029,0x0028,
  0x1112,0x1161,0x0029,0x0028,0x110c,0x116e,0x0029,0x0028,
  0x110b,0x1169,0x110c,0x1165,0x11ab,0x0029,0x0028,0x110b,
  0x1169,0x1112,0x116e,0x0029,0x0028,0x4e00,0x0029,0x0028,
  0x4e8c,0x0029,0x0028,0x4e09,0x0029,0x0028,0x56db,0x0029,
  0x0028,0x4e94,0x0029,0x0028,0x516d,0x0029,0x0028,0x4e03,
  0x0029,0x0028,0x516b,0x0029,0x0028,0x4e5d,0x0029,0x0028,
  0x5341,0x0029,0x0028,0x6708,0x0029,0x0028,0x706b,0x0029,
  0x0028,0x6c34,0x0029,0x0028,0x6728,0x0029,0x0028,0x91d1,
  0x0029,0x0028,0x571f,0x0029,0x0028,0x65e5,0x0029,0x0028,
  0x682a,0x0029,0x0028,0x6709,0x0029,0x0028,0x793e,0x0029,
  0x0028,0x540d,0x0029,0x0028,0x7279,0x0029,0x0028,0x8ca1,
  0x0029,0x0028,0x795d,0x0029,0x0028,0x52b4,0x0029,0x0028,
  0x4ee3,0x0029,0x0028,0x547c,0x0029,0x0028,0x5b66,0x0029,
  0x0028,0x76e3,0x0029,0x0028,0x4f01,0x0029,0x0028,0x8cc7,
  0x0029,0x0028,0x5354,0x0029,0x0028,0x796d,0x0029,0x0028,
  0x4f11,0x0029,0x0028,0x81ea,0x0029,0x0028,0x81f3,0x0029,
  0x0050,0x0054,0x0045,0x0032,0x0031,0x0032,0x0032,0x0032,
  0x0033,0x0032,0x0034,0x0032,0x0035,0x0032,0x0036,0x0032,
  0x0037,0x0032,0x0038,0x0032,0x0039,0x0033,0x0030,0x0033,
  0x0031,0x0033,0x0032,0x0033,0x0033,0x0033,0x0034,0x0033,
  0x0035,0x1100,0x1102,0x1103,0x1105,0x1106,0x1107,0x1109,
  0x110b,0x110c,0x110e,0x110f,0x1110,0x1111,0x1112,0x1100,
  0x1161,0x1102,0x1161,0x1103,0x1161,0x1105,0x1161,0x1106,
  0x1161,0x1107,0x1161,0x1109,0x1161,0x110b,0x1161,0x110c,
  0x1161,0x110e,0x1161,0x110f,0x1161,0x1110,0x1161,0x1111,
  0x1161,0x1112,0x1161,0x110e,0x1161,0x11b7,0x1100,0x1169,
  0x110c,0x116e,0x110b,0x1174,0x110b,0x116e,0x4e00,0x4e8c,
  0x4e09,0x56db,0x4e94,0x516d,0x4e03,0x516b,0x4e5d,0x5341,
  0x6708,0x706b,0x6c34,0x6728,0x91d1,0x571f,0x65e5,0x682a,
  0x6709,0x793e,0x540d,0x7279,0x8ca1,0x795d,0x52b4,0x79d8,
  0x7537,0x5973,0x9069,0x512a,0x5370,0x6ce8,0x9805,0x4f11,
  0x5199,0x6b63,0x4e0a,0x4e2d,0x4e0b,0x5de6,0x53f3,0x533b,
  0x5b97,0x5b66,0x76e3,0x4f01,0x8cc7,0x5354,0x591c,0x0033,
  0x0036,0x0033,0x0037,0x0033,0x0038,0x0033,0x0039,0x0034,
  0x0030,0x0034,0x0031,0x0034,0x0032,0x0034,0x0033,0x0034,
  0x0034,0x0034,0x0035,0x0034,0x0036,0x0034,0x0037,0x0034,
  0x0038,0x0034,0x0039,0x0035,0x0030,0x0031,0x6708,0x0032,
  0x6708,0x0033,0x6708,0x0034,0x6708,0x0035,0x6708,0x0036,
  0x6708,0x0037,0x6708,0x0038,0x6708,0x0039,0x6708,0x0031,
  0x0030,0x6708,0x0031,0x0031,0x6708,0x0031,0x0032,0x6708,
  0x0048,0x0067,0x0065,0x0072,0x0067,0x0065,0x0056,0x004c,
  0x0054,0x0044,0x30a2,0x30a4,0x30a6,0x30a8,0x30aa,0x30ab,
  0x30ad,0x30af,0x30b1,0x30b3,0x30b5,0x30b7,0x30b9,0x30bb,
  0x30bd,0x30bf,0x30c1,0x30c4,0x30c6,0x30c8,0x30ca,0x30cb,
  0x30cc,0x30cd,0x30ce,0x30cf,0x30d2,0x30d5,0x30d8,0x30db,
  0x30de,0x30df,0x30e0,0x30e1,0x30e2,0x30e4,0x30e6,0x30e8,
  0x30e9,0x30ea,0x30eb,0x30ec,0x30ed,0x30ef,0x30f0,0x30f1,
  0x30f2,0x30a2,0x30d1,0x30fc,0x30c8,0x30a2,0x30eb,0x30d5,
  0x30a1,0x30a2,0x30f3,0x30da,0x30a2,0x30a2,0x30fc,0x30eb,
  0x30a4,0x30cb,0x30f3,0x30b0,0x30a4,0x30f3,0x30c1,0x30a6,
  0x30a9,0x30f3,0x30a8,0x30b9,0x30af,0x30fc,0x30c9,0x30a8,
  0x30fc,0x30ab,0x30fc,0x30aa,0x30f3,0x30b9,0x30aa,0x30fc,
  0x30e0,0x30ab,0x30a4,0x30ea,0x30ab,0x30e9,0x30c3,0x30c8,
  0x30ab,0x30ed,0x30ea,0x30fc,0x30ac,0x30ed,0x30f3,0x30ac,
  0x30f3,0x30de,0x30ae,0x30ac,0x30ae,0x30cb,0x30fc,0x30ad,
  0x30e5,0x30ea,0x30fc,0x30ae,0x30eb,0x30c0,0x30fc,0x30ad,
  0x30ed,0x30ad,0x30ed,0x30b0,0x30e9,0x30e0,0x30ad,0x30ed,
  0x30e1,0x30fc,0x30c8,0x30eb,0x30ad,0x30ed,0x30ef,0x30c3,
  0x30c8,0x30b0,0x30e9,0x30e0,0x30b0,0x30e9,0x30e0,0x30c8,
  0x30f3,0x30af,0x30eb,0x30bc,0x30a4,0x30ed,0x30af,0x30ed,
  0x30fc,0x30cd,0x30b1,0x30fc,0x30b9,0x30b3,0x30eb,0x30ca,
  0x30b3,0x30fc,0x30dd,0x30b5,0x30a4,0x30af,0x30eb,0x30b5,
  0x30f3,0x30c1,0x30fc,0x30e0,0x30b7,0x30ea,0x30f3,0x30b0,
  0x30bb,0x30f3,0x30c1,0x30bb,0x30f3,0x30c8,0x30c0,0x30fc,
  0x30b9,0x30c7,0x30b7,0x30c9,0x30eb,0x30c8,0x30f3,0x30ca,
  0x30ce,0x30ce,0x30c3,0x30c8,0x30cf,0x30a4,0x30c4,0x30d1,
  0x30fc,0x30bb,0x30f3,0x30c8,0x30d1,0x30fc,0x30c4,0x30d0,
  0x30fc,0x30ec,0x30eb,0x30d4,0x30a2,0x30b9,0x30c8,0x30eb,
  0x30d4,0x30af,0x30eb,0x30d4,0x30b3,0x30d3,0x30eb,0x30d5,
  0x30a1,0x30e9,0x30c3,0x30c9,0x30d5,0x30a3,0x30fc,0x30c8,
  0x30d6,0x30c3,0x30b7,0x30a7,0x30eb,0x30d5,0x30e9,0x30f3,
  0x30d8,0x30af,0x30bf,0x30fc,0x30eb,0x30da,0x30bd,0x30da,
  0x30cb,0x30d2,0x30d8,0x30eb,0x30c4,0x30da,0x30f3,0x30b9,
  0x30da,0x30fc,0x30b8,0x30d9,0x30fc,0x30bf,0x30dd,0x30a4,
  0x30f3,0x30c8,0x30dc,0x30eb,0x30c8,0x30db,0x30f3,0x30dd,
  0x30f3,0x30c9,0x30db,0x30fc,0x30eb,0x30db,0x30fc,0x30f3,
  0x30de,0x30a4,0x30af,0x30ed,0x30de,0x30a4,0x30eb,0x30de,
  0x30c3,0x30cf,0x30de,0x30eb,0x30af,0x30de,0x30f3,0x30b7,
  0x30e7,0x30f3,0x30df,0x30af,0x30ed,0x30f3,0x30df,0x30ea,
  0x30df,0x30ea,0x30d0,0x30fc,0x30eb,0x30e1,0x30ac,0x30e1,
  0x30ac,0x30c8,0x30f3,0x30e1,0x30fc,0x30c8,0x30eb,0x30e4,
  0x30fc,0x30c9,0x30e4,0x30fc,0x30eb,0x30e6,0x30a2,0x30f3,
  0x30ea,0x30c3,0x30c8,0x30eb,0x30ea,0x30e9,0x30eb,0x30d4,
  0x30fc,0x30eb,0x30fc,0x30d6,0x30eb,0x30ec,0x30e0,0x30ec,
  0x30f3,0x30c8,0x30b2,0x30f3,0x30ef,0x30c3,0x30c8,0x0030,
  0x70b9,0x0031,0x70b9,0x0032,0x70b9,0x0033,0x70b9,0x0034,
  0x70b9,0x0035,0x70b9,0x0036,0x70b9,0x0037,0x70b9,0x0038,
  0x70b9,0x0039,0x70b9,0x0031,0x0030,0x70b9,0x0031,0x0031,
  0x70b9,0x0031,0x0032,0x70b9,0x0031,0x0033,0x70b9,0x0031,
  0x0034,0x70b9,0x0031,0x0035,0x70b9,0x0031,0x0036,0x70b9,
  0x0031,0x0037,0x70b9,0x0031,0x0038,0x70b9,0x0031,0x0039,
  0x70b9,0x0032,0x0030,0x70b9,0x0032,0x0031,0x70b9,0x0032,
  0x0032,0x70b9,0x0032,0x0033,0x70b9,0x0032,0x0034,0x70b9,
  0x0068,0x0050,0x0061,0x0064,0x0061,0x0041,0x0055,0x0062,
  0x0061,0x0072,0x006f,0x0056,0x0070,0x0063,0x0064,0x006d,
  0x0064,0x006d,0x00b2,0x0064,0x006d,0x00b3,0x0049,0x0055,
  0x5e73,0x6210,0x662d,0x548c,0x5927,0x6b63,0x660e,0x6cbb,
  0x682a,0x5f0f,0x4f1a,0x793e,0x0070,0x0041,0x006e,0x0041,
  0x03bc,0x0041,0x006d,0x0041,0x006b,0x0041,0x004b,0x0042,
  0x004d,0x0042,0x0047,0x0042,0x0063,0x0061,0x006c,0x006b,
  0x0063,0x0061,0x006c,0x0070,0x0046,0x006e,0x0046,0x03bc,
  0x0046,0x03bc,0x0067,0x006d,0x0067,0x006b,0x0067,0x0048,
  0x007a,0x006b,0x0048,0x007a,0x004d,0x0048,0x007a,0x0047,
  0x0048,0x007a,0x0054,0x0048,0x007a,0x03bc,0x2113,0x006d,
  0x2113,0x0064,0x2113,0x006b,0x2113,0x0066,0x006d,0x006e,
  0x006d,0x03bc,0x006d,0x006d,0x006d,0x0063,0x006d,0x006b,
  0x006d,0x006d,0x006d,0x00b2,0x0063,0x006d,0x00b2,0x006d,
  0x00b2,0x006b,0x006d,0x00b2,0x006d,0x006d,0x00b3,0x0063,
  0x006d,0x00b3,0x006d,0x00b3,0x006b,0x006d,0x00b3,0x006d,
  0x2215,0x0073,0x006d,0x2215,0x0073,0x00b2,0x0050,0x0061,
  0x006b,0x0050,0x0061,0x004d,0x0050,0x0061,0x0047,0x0050,
  0x0061,0x0072,0x0061,0x0064,0x0072,0x0061,0x0064,0x2215,
  0x0073,0x0072,0x0061,0x0064,0x2215,0x0073,0x00b2,0x0070,
  0x0073,0x006e,0x0073,0x03bc,0x0073,0x006d,0x0073,0x0070,
  0x0056,0x006e,0x0056,0x03bc,0x0056,0x006d,0x0056,0x006b,
  0x0056,0x004d,0x0056,0x0070,0x0057,0x006e,0x0057,0x03bc,
  0x0057,0x006d,0x0057,0x006b,0x0057,0x004d,0x0057,0x006b,
  0x03a9,0x004d,0x03a9,0x0061,0x002e,0x006d,0x002e,0x0042,
  0x0071,0x0063,0x0063,0x0063,0x0064,0x0043,0x2215,0x006b,
  0x0067,0x0043,0x006f,0x002e,0x0064,0x0042,0x0047,0x0079,
  0x0068,0x0061,0x0048,0x0050,0x0069,0x006e,0x004b,0x004b,
  0x004b,0x004d,0x006b,0x0074,0x006c,0x006d,0x006c,0x006e,
  0x006c,0x006f,0x0067,0x006c,0x0078,0x006d,0x0062,0x006d,
  0x0069,0x006c,0x006d,0x006f,0x006c,0x0050,0x0048,0x0070,
  0x002e,0x006d,0x002e,0x0050,0x0050,0x004d,0x0050,0x0052,
  0x0073,0x0072,0x0053,0x0076,0x0057,0x0062,0x0056,0x2215,
  0x006d,0x0041,0x2215,0x006d,0x0031,0x65e5,0x0032,0x65e5,
  0x0033,0x65e5,0x0034,0x65e5,0x0035,0x65e5,0x0036,0x65e5,
  0x0037,0x65e5,0x0038,0x65e5,0x0039,0x65e5,0x0031,0x0030,
  0x65e5,0x0031,0x0031,0x65e5,0x0031,0x0032,0x65e5,0x0031,
  0x0033,0x65e5,0x0031,0x0034,0x65e5,0x0031,0x0035,0x65e5,
  0x0031,0x0036,0x65e5,0x0031,0x0037,0x65e5,0x0031,0x0038,
  0x65e5,0x0031,0x0039,0x65e5,0x0032,0x0030,0x65e5,0x0032,
  0x0031,0x65e5,0x0032,0x0032,0x65e5,0x0032,0x0033,0x65e5,
  0x0032,0x0034,0x65e5,0x0032,0x0035,0x65e5,0x0032,0x0036,
  0x65e5,0x0032,0x0037,0x65e5,0x0032,0x0038,0x65e5,0x0032,
  0x0039,0x65e5,0x0033,0x0030,0x65e5,0x0033,0x0031,0x65e5,
  0x0067,0x0061,0x006c
};


#define UCS4_BMPCJKMIN 0xf900
#define UCS4_BMPCJKMAX 0xface

	/* CJK Compatibility - 0 means hole (no decomposition) */
static const unsigned short ucs4_bmpcjk1decomptab[463] = {
  0x8c48,0x66f4,0x8eca,0x8cc8,0x6ed1,0x4e32,0x53e5,0x9f9c,
  0x9f9c,0x5951,0x91d1,0x5587,0x5948,0x61f6,0x7669,0x7f85,
  0x863f,0x87ba,0x88f8,0x908f,0x6a02,0x6d1b,0x70d9,0x73de,
  0x843d,0x916a,0x99f1,0x4e82,0x5375,0x6b04,0x721b,0x862d,
  0x9e1e,0x5d50,0x6feb,0x85cd,0x8964,0x62c9,0x81d8,0x881f,
  0x5eca,0x6717,0x6d6a,0x72fc,0x90ce,0x4f86,0x51b7,0x52de,
  0x64c4,0x6ad3,0x7210,0x76e7,0x8001,0x8606,0x865c,0x8def,
  0x9732,0x9b6f,0x9dfa,0x788c,0x797f,0x7da0,0x83c9,0x9304,
  0x9e7f,0x8ad6,0x58df,0x5f04,0x7c60,0x807e,0x7262,0x78ca,
  0x8cc2,0x96f7,0x58d8,0x5c62,0x6a13,0x6dda,0x6f0f,0x7d2f,
  0x7e37,0x964b,0x52d2,0x808b,0x51dc,0x51cc,0x7a1c,0x7dbe,
  0x83f1,0x9675,0x8b80,0x62cf,0x6a02,0x8afe,0x4e39,0x5be7,
  0x6012,0x7387,0x7570,0x5317,0x78fb,0x4fbf,0x5fa9,0x4e0d,
  0x6ccc,0x6578,0x7d22,0x53c3,0x585e,0x7701,0x8449,0x8aaa,
  0x6bba,0x8fb0,0x6c88,0x62fe,0x82e5,0x63a0,0x7565,0x4eae,
  0x5169,0x51c9,0x6881,0x7ce7,0x826f,0x8ad2,0x91cf,0x52f5,
  0x5442,0x5973,0x5eec,0x65c5,0x6ffe,0x792a,0x95ad,0x9a6a,
  0x9e97,0x9ece,0x529b,0x66c6,0x6b77,0x8f62,0x5e74,0x6190,
  0x6200,0x649a,0x6f23,0x7149,0x7489,0x79ca,0x7df4,0x806f,
  0x8f26,0x84ee,0x9023,0x934a,0x5217,0x52a3,0x54bd,0x70c8,
  0x88c2,0x8aaa,0x5ec9,0x5ff5,0x637b,0x6bae,0x7c3e,0x7375,
  0x4ee4,0x56f9,0x5be7,0x5dba,0x601c,0x73b2,0x7469,0x7f9a,
  0x8046,0x9234,0x96f6,0x9748,0x9818,0x4f8b,0x79ae,0x91b4,
  0x96b8,0x60e1,0x4e86,0x50da,0x5bee,0x5c3f,0x6599,0x6a02,
  0x71ce,0x7642,0x84fc,0x907c,0x9f8d,0x6688,0x962e,0x5289,
  0x677b,0x67f3,0x6d41,0x6e9c,0x7409,0x7559,0x786b,0x7d10,
  0x985e,0x516d,0x622e,0x9678,0x502b,0x5d19,0x6dea,0x8f2a,
  0x5f8b,0x6144,0x6817,0x7387,0x9686,0x5229,0x540f,0x5c65,
  0x6613,0x674e,0x68a8,0x6ce5,0x7406,0x75e2,0x7f79,0x88cf,
  0x88e1,0x91cc,0x96e2,0x533f,0x6eba,0x541d,0x71d0,0x7498,
  0x85fa,0x96a3,0x9c57,0x9e9f,0x6797,0x6dcb,0x81e8,0x7acb,
  0x7b20,0x7c92,0x72c0,0x7099,0x8b58,0x4ec0,0x8336,0x523a,
  0x5207,0x5ea6,0x62d3,0x7cd6,0x5b85,0x6d1e,0x66b4,0x8f3b,
  0x884c,0x964d,0x898b,0x5ed3,0x5140,0x55c0,0x0000,0x0000,
  0x585a,0x0000,0x6674,0x0000,0x0000,0x51de,0x732a,0x76ca,
  0x793c,0x795e,0x7965,0x798f,0x9756,0x7cbe,0x7fbd,0x0000,
  0x8612,0x0000,0x8af8,0x0000,0x0000,0x9038,0x90fd,0x0000,
  0x0000,0x0000,0x98ef,0x98fc,0x9928,0x9db4,0x0000,0x0000,
  0x4fae,0x50e7,0x514d,0x52c9,0x52e4,0x5351,0x559d,0x5606,
  0x5668,0x5840,0x58a8,0x5c64,0x5c6e,0x6094,0x6168,0x618e,
  0x61f2,0x654f,0x65e2,0x6691,0x6885,0x6d77,0x6e1a,0x6f22,
  0x716e,0x722b,0x7422,0x7891,0x793e,0x7949,0x7948,0x7950,
  0x7956,0x795d,0x798d,0x798e,0x7a40,0x7a81,0x7bc0,0x7df4,
  0x7e09,0x7e41,0x7f72,0x8005,0x81ed,0x8279,0x8279,0x8457,
  0x8910,0x8996,0x8b01,0x8b39,0x8cd3,0x8d08,0x8fb6,0x9038,
  0x96e3,0x97ff,0x983b,0x0000,0x0000,0x0000,0x0000,0x0000,
  0x4e26,0x51b5,0x5168,0x4f80,0x5145,0x5180,0x52c7,0x52fa,
  0x559d,0x5555,0x5599,0x55e2,0x585a,0x58b3,0x5944,0x5954,
  0x5a62,0x5b28,0x5ed2,0x5ed9,0x5f69,0x5fad,0x60d8,0x614e,
  0x6108,0x618e,0x6160,0x61f2,0x6234,0x63c4,0x641c,0x6452,
  0x6556,0x6674,0x6717,0x671b,0x6756,0x6b79,0x6bba,0x6d41,
  0x6edb,0x6ecb,0x6f22,0x701e,0x716e,0x77a7,0x7235,0x72af,
  0x732a,0x7471,0x7506,0x753b,0x761d,0x761f,0x76ca,0x76db,
  0x76f4,0x774a,0x7740,0x78cc,0x7ab1,0x7bc0,0x7c7b,0x7d5b,
  0x7df4,0x7f3e,0x8005,0x8352,0x83ef,0x8779,0x8941,0x8986,
  0x8996,0x8abf,0x8af8,0x8acb,0x8b01,0x8afe,0x8aed,0x8b39,
  0x8b8a,0x8d08,0x8f38,0x9072,0x9199,0x9276,0x967c,0x96e3,
  0x9756,0x97db,0x97ff,0x980b,0x983b,0x9b12,0x9f9c
};


#define UCS4_BMPCJK2MIN 0xfacf
#define UCS4_BMPCJK2MAX 0xfad9


	/* CJK Compatibility - some values not in BMP */
static const unsigned long ucs4_bmpcjk2decomptab[11] = {
  0x2284a,0x22844,0x233d5, 0x3b9d, 0x4018, 0x4039,
  0x25249,0x25cd0,0x27ed3, 0x9f43, 0x9f8e
};


#define UCS4_BMPHIMIN 0xfb00
#define UCS4_BMPHIMAX 0xfefc
#define UCS4_BMPHIIXMASK 0x7ff
#define UCS4_BMPHISIZEMASK 0xf800
#define UCS4_BMPHISIZESHIFT 11

	/* BMP hi decomposition indices - ssss siii iiii iiii */
static unsigned short ucs4_dbmphiixtab[1021] = {
0x0800,0x0802,0x0804,0x1006,0x1009,0x080c,0x080e,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0810,0x0812,0x0814,0x0816,0x0818,
0x0000,0x0000,0x0000,0x0000,0x0000,0x081a,0x0000,0x081c,
0x001e,0x001f,0x0020,0x0021,0x0022,0x0023,0x0024,0x0025,
0x0026,0x0027,0x0828,0x082a,0x082c,0x082e,0x0830,0x0832,
0x0834,0x0836,0x0838,0x083a,0x083c,0x083e,0x0840,0x0000,
0x0842,0x0844,0x0846,0x0848,0x084a,0x0000,0x084c,0x0000,
0x084e,0x0850,0x0000,0x0852,0x0854,0x0000,0x0856,0x0858,
0x085a,0x085c,0x085e,0x0860,0x0862,0x0864,0x0866,0x0868,
0x006a,0x006b,0x006c,0x006d,0x006e,0x006f,0x0070,0x0071,
0x0072,0x0073,0x0074,0x0075,0x0076,0x0077,0x0078,0x0079,
0x007a,0x007b,0x007c,0x007d,0x007e,0x007f,0x0080,0x0081,
0x0082,0x0083,0x0084,0x0085,0x0086,0x0087,0x0088,0x0089,
0x008a,0x008b,0x008c,0x008d,0x008e,0x008f,0x0090,0x0091,
0x0092,0x0093,0x0094,0x0095,0x0096,0x0097,0x0098,0x0099,
0x009a,0x009b,0x009c,0x009d,0x009e,0x009f,0x00a0,0x00a1,
0x00a2,0x00a3,0x00a4,0x00a5,0x00a6,0x00a7,0x00a8,0x00a9,
0x00aa,0x00ab,0x00ac,0x00ad,0x00ae,0x00af,0x00b0,0x00b1,
0x00b2,0x00b3,0x00b4,0x00b5,0x00b6,0x00b7,0x00b8,0x00b9,
0x00ba,0x00bb,0x00bc,0x00bd,0x00be,0x00bf,0x00c0,0x00c1,
0x00c2,0x00c3,0x00c4,0x00c5,0x00c6,0x00c7,0x00c8,0x00c9,
0x00ca,0x00cb,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x00cc,0x00cd,0x00ce,0x00cf,0x00d0,
0x00d1,0x00d2,0x00d3,0x00d4,0x00d5,0x00d6,0x00d7,0x00d8,
0x00d9,0x00da,0x00db,0x00dc,0x00dd,0x00de,0x00df,0x00e0,
0x00e1,0x00e2,0x08e3,0x08e5,0x08e7,0x08e9,0x08eb,0x08ed,
0x08ef,0x08f1,0x08f3,0x08f5,0x08f7,0x08f9,0x08fb,0x08fd,
0x08ff,0x0901,0x0903,0x0905,0x0107,0x0108,0x0109,0x010a,
0x090b,0x090d,0x090f,0x0911,0x0913,0x0915,0x0917,0x0919,
0x091b,0x091d,0x091f,0x0921,0x0923,0x0925,0x0927,0x0929,
0x092b,0x092d,0x092f,0x0931,0x0933,0x0935,0x0937,0x0939,
0x093b,0x093d,0x093f,0x0941,0x0943,0x0945,0x0947,0x0949,
0x094b,0x094d,0x094f,0x0951,0x0953,0x0955,0x0957,0x0959,
0x095b,0x095d,0x095f,0x0961,0x0963,0x0965,0x0967,0x0969,
0x096b,0x096d,0x096f,0x0971,0x0973,0x0975,0x0977,0x0979,
0x097b,0x097d,0x097f,0x0981,0x0983,0x0985,0x0987,0x0989,
0x098b,0x098d,0x098f,0x0991,0x0993,0x0995,0x0997,0x0999,
0x099b,0x099d,0x099f,0x09a1,0x09a3,0x09a5,0x09a7,0x09a9,
0x09ab,0x09ad,0x09af,0x09b1,0x09b3,0x09b5,0x09b7,0x09b9,
0x09bb,0x09bd,0x09bf,0x09c1,0x09c3,0x09c5,0x11c7,0x11ca,
0x11cd,0x11d0,0x11d3,0x11d6,0x09d9,0x09db,0x09dd,0x09df,
0x09e1,0x09e3,0x09e5,0x09e7,0x09e9,0x09eb,0x09ed,0x09ef,
0x09f1,0x09f3,0x09f5,0x09f7,0x09f9,0x09fb,0x09fd,0x09ff,
0x0a01,0x0a03,0x0a05,0x0a07,0x0a09,0x0a0b,0x0a0d,0x0a0f,
0x0a11,0x0a13,0x0a15,0x0a17,0x0a19,0x0a1b,0x0a1d,0x0a1f,
0x0a21,0x0a23,0x0a25,0x0a27,0x0a29,0x0a2b,0x0a2d,0x0a2f,
0x0a31,0x0a33,0x0a35,0x0a37,0x0a39,0x0a3b,0x0a3d,0x0a3f,
0x0a41,0x0a43,0x0a45,0x0a47,0x0a49,0x0a4b,0x0a4d,0x0a4f,
0x0a51,0x0a53,0x0a55,0x0a57,0x0a59,0x0a5b,0x0a5d,0x0a5f,
0x0a61,0x0a63,0x0a65,0x0a67,0x0a69,0x0a6b,0x0a6d,0x0a6f,
0x0a71,0x0a73,0x0a75,0x0a77,0x0a79,0x0a7b,0x0a7d,0x0a7f,
0x0a81,0x0a83,0x0a85,0x0a87,0x0a89,0x0a8b,0x0a8d,0x0a8f,
0x0a91,0x0a93,0x0a95,0x0a97,0x0a99,0x0a9b,0x0a9d,0x0a9f,
0x0aa1,0x0aa3,0x0aa5,0x0aa7,0x0aa9,0x0aab,0x0aad,0x0aaf,
0x0ab1,0x0ab3,0x0ab5,0x0ab7,0x0ab9,0x0abb,0x0abd,0x0abf,
0x0ac1,0x0ac3,0x0ac5,0x0ac7,0x0ac9,0x0acb,0x0acd,0x0acf,
0x0ad1,0x0ad3,0x0ad5,0x0ad7,0x0ad9,0x0adb,0x0add,0x0adf,
0x0ae1,0x0ae3,0x0ae5,0x0ae7,0x0ae9,0x0aeb,0x0aed,0x0aef,
0x0af1,0x0af3,0x12f5,0x12f8,0x12fb,0x0afe,0x0b00,0x0b02,
0x0b04,0x0b06,0x0b08,0x0b0a,0x0b0c,0x0b0e,0x0b10,0x0b12,
0x0b14,0x0b16,0x0b18,0x0b1a,0x0b1c,0x0b1e,0x0b20,0x0b22,
0x0b24,0x0b26,0x0b28,0x0b2a,0x0b2c,0x0b2e,0x0b30,0x0b32,
0x0b34,0x0b36,0x0b38,0x0b3a,0x0b3c,0x0b3e,0x0b40,0x0b42,
0x0b44,0x0b46,0x0b48,0x0b4a,0x0b4c,0x0b4e,0x0b50,0x0b52,
0x0b54,0x0b56,0x0b58,0x0b5a,0x0b5c,0x0b5e,0x0b60,0x0b62,
0x0b64,0x0b66,0x0b68,0x0b6a,0x0b6c,0x0b6e,0x0b70,0x0b72,
0x0b74,0x0b76,0x0b78,0x0b7a,0x0b7c,0x0b7e,0x0b80,0x0b82,
0x0b84,0x0b86,0x0b88,0x0b8a,0x0b8c,0x0b8e,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x1390,0x1393,0x1396,0x1399,0x139c,0x139f,0x13a2,0x13a5,
0x13a8,0x13ab,0x13ae,0x13b1,0x13b4,0x13b7,0x13ba,0x13bd,
0x13c0,0x13c3,0x13c6,0x13c9,0x13cc,0x13cf,0x13d2,0x13d5,
0x13d8,0x13db,0x13de,0x13e1,0x13e4,0x13e7,0x13ea,0x13ed,
0x13f0,0x13f3,0x13f6,0x13f9,0x13fc,0x13ff,0x1402,0x1405,
0x1408,0x140b,0x140e,0x1411,0x1414,0x1417,0x141a,0x141d,
0x1420,0x1423,0x1426,0x1429,0x142c,0x142f,0x1432,0x1435,
0x1438,0x143b,0x143e,0x1441,0x1444,0x1447,0x144a,0x144d,
0x0000,0x0000,0x1450,0x1453,0x1456,0x1459,0x145c,0x145f,
0x1462,0x1465,0x1468,0x146b,0x146e,0x1471,0x1474,0x1477,
0x147a,0x147d,0x1480,0x1483,0x1486,0x1489,0x148c,0x148f,
0x1492,0x1495,0x1498,0x149b,0x149e,0x14a1,0x14a4,0x14a7,
0x14aa,0x14ad,0x14b0,0x14b3,0x14b6,0x14b9,0x14bc,0x14bf,
0x14c2,0x14c5,0x14c8,0x14cb,0x14ce,0x14d1,0x14d4,0x14d7,
0x14da,0x14dd,0x14e0,0x14e3,0x14e6,0x14e9,0x14ec,0x14ef,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x14f2,0x14f5,0x1cf8,0x1cfc,0x1d00,0x1d04,0x1d08,0x1d0c,
0x1d10,0x1514,0x8d17,0x3d29,0x1d31,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0535,0x0536,0x0537,0x0538,0x0539,0x053a,0x053b,0x053c,
0x053d,0x053e,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
0x053f,0x0540,0x0541,0x0542,0x0543,0x0544,0x0545,0x0546,
0x0547,0x0548,0x0549,0x054a,0x054b,0x054c,0x054d,0x054e,
0x054f,0x0550,0x0551,0x0552,0x0553,0x0000,0x0000,0x0554,
0x0555,0x0556,0x0557,0x0558,0x0559,0x055a,0x055b,0x055c,
0x055d,0x055e,0x055f,0x0000,0x0560,0x0561,0x0562,0x0563,
0x0564,0x0565,0x0566,0x0567,0x0568,0x0569,0x056a,0x056b,
0x056c,0x056d,0x056e,0x056f,0x0570,0x0571,0x0572,0x0000,
0x0573,0x0574,0x0575,0x0576,0x0000,0x0000,0x0000,0x0000,
0x0d77,0x0d79,0x0d7b,0x0000,0x0d7d,0x0000,0x0d7f,0x0d81,
0x0d83,0x0d85,0x0d87,0x0d89,0x0d8b,0x0d8d,0x0d8f,0x0d91,
0x0593,0x0594,0x0595,0x0596,0x0597,0x0598,0x0599,0x059a,
0x059b,0x059c,0x059d,0x059e,0x059f,0x05a0,0x05a1,0x05a2,
0x05a3,0x05a4,0x05a5,0x05a6,0x05a7,0x05a8,0x05a9,0x05aa,
0x05ab,0x05ac,0x05ad,0x05ae,0x05af,0x05b0,0x05b1,0x05b2,
0x05b3,0x05b4,0x05b5,0x05b6,0x05b7,0x05b8,0x05b9,0x05ba,
0x05bb,0x05bc,0x05bd,0x05be,0x05bf,0x05c0,0x05c1,0x05c2,
0x05c3,0x05c4,0x05c5,0x05c6,0x05c7,0x05c8,0x05c9,0x05ca,
0x05cb,0x05cc,0x05cd,0x05ce,0x05cf,0x05d0,0x05d1,0x05d2,
0x05d3,0x05d4,0x05d5,0x05d6,0x05d7,0x05d8,0x05d9,0x05da,
0x05db,0x05dc,0x05dd,0x05de,0x05df,0x05e0,0x05e1,0x05e2,
0x05e3,0x05e4,0x05e5,0x05e6,0x05e7,0x05e8,0x05e9,0x05ea,
0x05eb,0x05ec,0x05ed,0x05ee,0x05ef,0x05f0,0x05f1,0x05f2,
0x05f3,0x05f4,0x05f5,0x05f6,0x05f7,0x05f8,0x05f9,0x05fa,
0x05fb,0x05fc,0x05fd,0x05fe,0x05ff,0x0600,0x0601,0x0602,
0x0603,0x0604,0x0605,0x0606,0x0607,0x0e08,0x0e0a,0x0e0c,
0x0e0e,0x0e10,0x0e12,0x0e14,0x0e16
};

	/* BMP high decompositions */
static unsigned short ucs4_dbmphitab[1560] = {
0x0066,0x0066,0x0066,0x0069,0x0066,0x006c,0x0066,0x0066,
0x0069,0x0066,0x0066,0x006c,0x017f,0x0074,0x0073,0x0074,
0x0574,0x0576,0x0574,0x0565,0x0574,0x056b,0x057e,0x0576,
0x0574,0x056d,0x05d9,0x05b4,0x05f2,0x05b7,0x05e2,0x05d0,
0x05d3,0x05d4,0x05db,0x05dc,0x05dd,0x05e8,0x05ea,0x002b,
0x05e9,0x05c1,0x05e9,0x05c2,0xfb49,0x05c1,0xfb49,0x05c2,
0x05d0,0x05b7,0x05d0,0x05b8,0x05d0,0x05bc,0x05d1,0x05bc,
0x05d2,0x05bc,0x05d3,0x05bc,0x05d4,0x05bc,0x05d5,0x05bc,
0x05d6,0x05bc,0x05d8,0x05bc,0x05d9,0x05bc,0x05da,0x05bc,
0x05db,0x05bc,0x05dc,0x05bc,0x05de,0x05bc,0x05e0,0x05bc,
0x05e1,0x05bc,0x05e3,0x05bc,0x05e4,0x05bc,0x05e6,0x05bc,
0x05e7,0x05bc,0x05e8,0x05bc,0x05e9,0x05bc,0x05ea,0x05bc,
0x05d5,0x05b9,0x05d1,0x05bf,0x05db,0x05bf,0x05e4,0x05bf,
0x05d0,0x05dc,0x0671,0x0671,0x067b,0x067b,0x067b,0x067b,
0x067e,0x067e,0x067e,0x067e,0x0680,0x0680,0x0680,0x0680,
0x067a,0x067a,0x067a,0x067a,0x067f,0x067f,0x067f,0x067f,
0x0679,0x0679,0x0679,0x0679,0x06a4,0x06a4,0x06a4,0x06a4,
0x06a6,0x06a6,0x06a6,0x06a6,0x0684,0x0684,0x0684,0x0684,
0x0683,0x0683,0x0683,0x0683,0x0686,0x0686,0x0686,0x0686,
0x0687,0x0687,0x0687,0x0687,0x068d,0x068d,0x068c,0x068c,
0x068e,0x068e,0x0688,0x0688,0x0698,0x0698,0x0691,0x0691,
0x06a9,0x06a9,0x06a9,0x06a9,0x06af,0x06af,0x06af,0x06af,
0x06b3,0x06b3,0x06b3,0x06b3,0x06b1,0x06b1,0x06b1,0x06b1,
0x06ba,0x06ba,0x06bb,0x06bb,0x06bb,0x06bb,0x06c0,0x06c0,
0x06c1,0x06c1,0x06c1,0x06c1,0x06be,0x06be,0x06be,0x06be,
0x06d2,0x06d2,0x06d3,0x06d3,0x06ad,0x06ad,0x06ad,0x06ad,
0x06c7,0x06c7,0x06c6,0x06c6,0x06c8,0x06c8,0x0677,0x06cb,
0x06cb,0x06c5,0x06c5,0x06c9,0x06c9,0x06d0,0x06d0,0x06d0,
0x06d0,0x0649,0x0649,0x0626,0x0627,0x0626,0x0627,0x0626,
0x06d5,0x0626,0x06d5,0x0626,0x0648,0x0626,0x0648,0x0626,
0x06c7,0x0626,0x06c7,0x0626,0x06c6,0x0626,0x06c6,0x0626,
0x06c8,0x0626,0x06c8,0x0626,0x06d0,0x0626,0x06d0,0x0626,
0x06d0,0x0626,0x0649,0x0626,0x0649,0x0626,0x0649,0x06cc,
0x06cc,0x06cc,0x06cc,0x0626,0x062c,0x0626,0x062d,0x0626,
0x0645,0x0626,0x0649,0x0626,0x064a,0x0628,0x062c,0x0628,
0x062d,0x0628,0x062e,0x0628,0x0645,0x0628,0x0649,0x0628,
0x064a,0x062a,0x062c,0x062a,0x062d,0x062a,0x062e,0x062a,
0x0645,0x062a,0x0649,0x062a,0x064a,0x062b,0x062c,0x062b,
0x0645,0x062b,0x0649,0x062b,0x064a,0x062c,0x062d,0x062c,
0x0645,0x062d,0x062c,0x062d,0x0645,0x062e,0x062c,0x062e,
0x062d,0x062e,0x0645,0x0633,0x062c,0x0633,0x062d,0x0633,
0x062e,0x0633,0x0645,0x0635,0x062d,0x0635,0x0645,0x0636,
0x062c,0x0636,0x062d,0x0636,0x062e,0x0636,0x0645,0x0637,
0x062d,0x0637,0x0645,0x0638,0x0645,0x0639,0x062c,0x0639,
0x0645,0x063a,0x062c,0x063a,0x0645,0x0641,0x062c,0x0641,
0x062d,0x0641,0x062e,0x0641,0x0645,0x0641,0x0649,0x0641,
0x064a,0x0642,0x062d,0x0642,0x0645,0x0642,0x0649,0x0642,
0x064a,0x0643,0x0627,0x0643,0x062c,0x0643,0x062d,0x0643,
0x062e,0x0643,0x0644,0x0643,0x0645,0x0643,0x0649,0x0643,
0x064a,0x0644,0x062c,0x0644,0x062d,0x0644,0x062e,0x0644,
0x0645,0x0644,0x0649,0x0644,0x064a,0x0645,0x062c,0x0645,
0x062d,0x0645,0x062e,0x0645,0x0645,0x0645,0x0649,0x0645,
0x064a,0x0646,0x062c,0x0646,0x062d,0x0646,0x062e,0x0646,
0x0645,0x0646,0x0649,0x0646,0x064a,0x0647,0x062c,0x0647,
0x0645,0x0647,0x0649,0x0647,0x064a,0x064a,0x062c,0x064a,
0x062d,0x064a,0x062e,0x064a,0x0645,0x064a,0x0649,0x064a,
0x064a,0x0630,0x0670,0x0631,0x0670,0x0649,0x0670,0x0020,
0x064c,0x0651,0x0020,0x064d,0x0651,0x0020,0x064e,0x0651,
0x0020,0x064f,0x0651,0x0020,0x0650,0x0651,0x0020,0x0651,
0x0670,0x0626,0x0631,0x0626,0x0632,0x0626,0x0645,0x0626,
0x0646,0x0626,0x0649,0x0626,0x064a,0x0628,0x0631,0x0628,
0x0632,0x0628,0x0645,0x0628,0x0646,0x0628,0x0649,0x0628,
0x064a,0x062a,0x0631,0x062a,0x0632,0x062a,0x0645,0x062a,
0x0646,0x062a,0x0649,0x062a,0x064a,0x062b,0x0631,0x062b,
0x0632,0x062b,0x0645,0x062b,0x0646,0x062b,0x0649,0x062b,
0x064a,0x0641,0x0649,0x0641,0x064a,0x0642,0x0649,0x0642,
0x064a,0x0643,0x0627,0x0643,0x0644,0x0643,0x0645,0x0643,
0x0649,0x0643,0x064a,0x0644,0x0645,0x0644,0x0649,0x0644,
0x064a,0x0645,0x0627,0x0645,0x0645,0x0646,0x0631,0x0646,
0x0632,0x0646,0x0645,0x0646,0x0646,0x0646,0x0649,0x0646,
0x064a,0x0649,0x0670,0x064a,0x0631,0x064a,0x0632,0x064a,
0x0645,0x064a,0x0646,0x064a,0x0649,0x064a,0x064a,0x0626,
0x062c,0x0626,0x062d,0x0626,0x062e,0x0626,0x0645,0x0626,
0x0647,0x0628,0x062c,0x0628,0x062d,0x0628,0x062e,0x0628,
0x0645,0x0628,0x0647,0x062a,0x062c,0x062a,0x062d,0x062a,
0x062e,0x062a,0x0645,0x062a,0x0647,0x062b,0x0645,0x062c,
0x062d,0x062c,0x0645,0x062d,0x062c,0x062d,0x0645,0x062e,
0x062c,0x062e,0x0645,0x0633,0x062c,0x0633,0x062d,0x0633,
0x062e,0x0633,0x0645,0x0635,0x062d,0x0635,0x062e,0x0635,
0x0645,0x0636,0x062c,0x0636,0x062d,0x0636,0x062e,0x0636,
0x0645,0x0637,0x062d,0x0638,0x0645,0x0639,0x062c,0x0639,
0x0645,0x063a,0x062c,0x063a,0x0645,0x0641,0x062c,0x0641,
0x062d,0x0641,0x062e,0x0641,0x0645,0x0642,0x062d,0x0642,
0x0645,0x0643,0x062c,0x0643,0x062d,0x0643,0x062e,0x0643,
0x0644,0x0643,0x0645,0x0644,0x062c,0x0644,0x062d,0x0644,
0x062e,0x0644,0x0645,0x0644,0x0647,0x0645,0x062c,0x0645,
0x062d,0x0645,0x062e,0x0645,0x0645,0x0646,0x062c,0x0646,
0x062d,0x0646,0x062e,0x0646,0x0645,0x0646,0x0647,0x0647,
0x062c,0x0647,0x0645,0x0647,0x0670,0x064a,0x062c,0x064a,
0x062d,0x064a,0x062e,0x064a,0x0645,0x064a,0x0647,0x0626,
0x0645,0x0626,0x0647,0x0628,0x0645,0x0628,0x0647,0x062a,
0x0645,0x062a,0x0647,0x062b,0x0645,0x062b,0x0647,0x0633,
0x0645,0x0633,0x0647,0x0634,0x0645,0x0634,0x0647,0x0643,
0x0644,0x0643,0x0645,0x0644,0x0645,0x0646,0x0645,0x0646,
0x0647,0x064a,0x0645,0x064a,0x0647,0x0640,0x064e,0x0651,
0x0640,0x064f,0x0651,0x0640,0x0650,0x0651,0x0637,0x0649,
0x0637,0x064a,0x0639,0x0649,0x0639,0x064a,0x063a,0x0649,
0x063a,0x064a,0x0633,0x0649,0x0633,0x064a,0x0634,0x0649,
0x0634,0x064a,0x062d,0x0649,0x062d,0x064a,0x062c,0x0649,
0x062c,0x064a,0x062e,0x0649,0x062e,0x064a,0x0635,0x0649,
0x0635,0x064a,0x0636,0x0649,0x0636,0x064a,0x0634,0x062c,
0x0634,0x062d,0x0634,0x062e,0x0634,0x0645,0x0634,0x0631,
0x0633,0x0631,0x0635,0x0631,0x0636,0x0631,0x0637,0x0649,
0x0637,0x064a,0x0639,0x0649,0x0639,0x064a,0x063a,0x0649,
0x063a,0x064a,0x0633,0x0649,0x0633,0x064a,0x0634,0x0649,
0x0634,0x064a,0x062d,0x0649,0x062d,0x064a,0x062c,0x0649,
0x062c,0x064a,0x062e,0x0649,0x062e,0x064a,0x0635,0x0649,
0x0635,0x064a,0x0636,0x0649,0x0636,0x064a,0x0634,0x062c,
0x0634,0x062d,0x0634,0x062e,0x0634,0x0645,0x0634,0x0631,
0x0633,0x0631,0x0635,0x0631,0x0636,0x0631,0x0634,0x062c,
0x0634,0x062d,0x0634,0x062e,0x0634,0x0645,0x0633,0x0647,
0x0634,0x0647,0x0637,0x0645,0x0633,0x062c,0x0633,0x062d,
0x0633,0x062e,0x0634,0x062c,0x0634,0x062d,0x0634,0x062e,
0x0637,0x0645,0x0638,0x0645,0x0627,0x064b,0x0627,0x064b,
0x062a,0x062c,0x0645,0x062a,0x062d,0x062c,0x062a,0x062d,
0x062c,0x062a,0x062d,0x0645,0x062a,0x062e,0x0645,0x062a,
0x0645,0x062c,0x062a,0x0645,0x062d,0x062a,0x0645,0x062e,
0x062c,0x0645,0x062d,0x062c,0x0645,0x062d,0x062d,0x0645,
0x064a,0x062d,0x0645,0x0649,0x0633,0x062d,0x062c,0x0633,
0x062c,0x062d,0x0633,0x062c,0x0649,0x0633,0x0645,0x062d,
0x0633,0x0645,0x062d,0x0633,0x0645,0x062c,0x0633,0x0645,
0x0645,0x0633,0x0645,0x0645,0x0635,0x062d,0x062d,0x0635,
0x062d,0x062d,0x0635,0x0645,0x0645,0x0634,0x062d,0x0645,
0x0634,0x062d,0x0645,0x0634,0x062c,0x064a,0x0634,0x0645,
0x062e,0x0634,0x0645,0x062e,0x0634,0x0645,0x0645,0x0634,
0x0645,0x0645,0x0636,0x062d,0x0649,0x0636,0x062e,0x0645,
0x0636,0x062e,0x0645,0x0637,0x0645,0x062d,0x0637,0x0645,
0x062d,0x0637,0x0645,0x0645,0x0637,0x0645,0x064a,0x0639,
0x062c,0x0645,0x0639,0x0645,0x0645,0x0639,0x0645,0x0645,
0x0639,0x0645,0x0649,0x063a,0x0645,0x0645,0x063a,0x0645,
0x064a,0x063a,0x0645,0x0649,0x0641,0x062e,0x0645,0x0641,
0x062e,0x0645,0x0642,0x0645,0x062d,0x0642,0x0645,0x0645,
0x0644,0x062d,0x0645,0x0644,0x062d,0x064a,0x0644,0x062d,
0x0649,0x0644,0x062c,0x062c,0x0644,0x062c,0x062c,0x0644,
0x062e,0x0645,0x0644,0x062e,0x0645,0x0644,0x0645,0x062d,
0x0644,0x0645,0x062d,0x0645,0x062d,0x062c,0x0645,0x062d,
0x0645,0x0645,0x062d,0x064a,0x0645,0x062c,0x062d,0x0645,
0x062c,0x0645,0x0645,0x062e,0x062c,0x0645,0x062e,0x0645,
0x0645,0x062c,0x062e,0x0647,0x0645,0x062c,0x0647,0x0645,
0x0645,0x0646,0x062d,0x0645,0x0646,0x062d,0x0649,0x0646,
0x062c,0x0645,0x0646,0x062c,0x0645,0x0646,0x062c,0x0649,
0x0646,0x0645,0x064a,0x0646,0x0645,0x0649,0x064a,0x0645,
0x0645,0x064a,0x0645,0x0645,0x0628,0x062e,0x064a,0x062a,
0x062c,0x064a,0x062a,0x062c,0x0649,0x062a,0x062e,0x064a,
0x062a,0x062e,0x0649,0x062a,0x0645,0x064a,0x062a,0x0645,
0x0649,0x062c,0x0645,0x064a,0x062c,0x062d,0x0649,0x062c,
0x0645,0x0649,0x0633,0x062e,0x0649,0x0635,0x062d,0x064a,
0x0634,0x062d,0x064a,0x0636,0x062d,0x064a,0x0644,0x062c,
0x064a,0x0644,0x0645,0x064a,0x064a,0x062d,0x064a,0x064a,
0x062c,0x064a,0x064a,0x0645,0x064a,0x0645,0x0645,0x064a,
0x0642,0x0645,0x064a,0x0646,0x062d,0x064a,0x0642,0x0645,
0x062d,0x0644,0x062d,0x0645,0x0639,0x0645,0x064a,0x0643,
0x0645,0x064a,0x0646,0x062c,0x062d,0x0645,0x062e,0x064a,
0x0644,0x062c,0x0645,0x0643,0x0645,0x0645,0x0644,0x062c,
0x0645,0x0646,0x062c,0x062d,0x062c,0x062d,0x064a,0x062d,
0x062c,0x064a,0x0645,0x062c,0x064a,0x0641,0x0645,0x064a,
0x0628,0x062d,0x064a,0x0643,0x0645,0x0645,0x0639,0x062c,
0x0645,0x0635,0x0645,0x0645,0x0633,0x062e,0x064a,0x0646,
0x062c,0x064a,0x0635,0x0644,0x06d2,0x0642,0x0644,0x06d2,
0x0627,0x0644,0x0644,0x0647,0x0627,0x0643,0x0628,0x0631,
0x0645,0x062d,0x0645,0x062f,0x0635,0x0644,0x0639,0x0645,
0x0631,0x0633,0x0648,0x0644,0x0639,0x0644,0x064a,0x0647,
0x0648,0x0633,0x0644,0x0645,0x0635,0x0644,0x0649,0x0635,
0x0644,0x0649,0x0020,0x0627,0x0644,0x0644,0x0647,0x0020,
0x0639,0x0644,0x064a,0x0647,0x0020,0x0648,0x0633,0x0644,
0x0645,0x062c,0x0644,0x0020,0x062c,0x0644,0x0627,0x0644,
0x0647,0x0631,0x06cc,0x0627,0x0644,0x002c,0x3001,0x3002,
0x003a,0x003b,0x0021,0x003f,0x3016,0x3017,0x2026,0x2025,
0x2014,0x2013,0x005f,0x005f,0x0028,0x0029,0x007b,0x007d,
0x3014,0x3015,0x3010,0x3011,0x300a,0x300b,0x3008,0x3009,
0x300c,0x300d,0x300e,0x300f,0x005b,0x005d,0x203e,0x203e,
0x203e,0x203e,0x005f,0x005f,0x005f,0x002c,0x3001,0x002e,
0x003b,0x003a,0x003f,0x0021,0x2014,0x0028,0x0029,0x007b,
0x007d,0x3014,0x3015,0x0023,0x0026,0x002a,0x002b,0x002d,
0x003c,0x003e,0x003d,0x005c,0x0024,0x0025,0x0040,0x0020,
0x064b,0x0640,0x064b,0x0020,0x064c,0x0020,0x064d,0x0020,
0x064e,0x0640,0x064e,0x0020,0x064f,0x0640,0x064f,0x0020,
0x0650,0x0640,0x0650,0x0020,0x0651,0x0640,0x0651,0x0020,
0x0652,0x0640,0x0652,0x0621,0x0622,0x0622,0x0623,0x0623,
0x0624,0x0624,0x0625,0x0625,0x0626,0x0626,0x0626,0x0626,
0x0627,0x0627,0x0628,0x0628,0x0628,0x0628,0x0629,0x0629,
0x062a,0x062a,0x062a,0x062a,0x062b,0x062b,0x062b,0x062b,
0x062c,0x062c,0x062c,0x062c,0x062d,0x062d,0x062d,0x062d,
0x062e,0x062e,0x062e,0x062e,0x062f,0x062f,0x0630,0x0630,
0x0631,0x0631,0x0632,0x0632,0x0633,0x0633,0x0633,0x0633,
0x0634,0x0634,0x0634,0x0634,0x0635,0x0635,0x0635,0x0635,
0x0636,0x0636,0x0636,0x0636,0x0637,0x0637,0x0637,0x0637,
0x0638,0x0638,0x0638,0x0638,0x0639,0x0639,0x0639,0x0639,
0x063a,0x063a,0x063a,0x063a,0x0641,0x0641,0x0641,0x0641,
0x0642,0x0642,0x0642,0x0642,0x0643,0x0643,0x0643,0x0643,
0x0644,0x0644,0x0644,0x0644,0x0645,0x0645,0x0645,0x0645,
0x0646,0x0646,0x0646,0x0646,0x0647,0x0647,0x0647,0x0647,
0x0648,0x0648,0x0649,0x0649,0x064a,0x064a,0x064a,0x064a,
0x0644,0x0622,0x0644,0x0622,0x0644,0x0623,0x0644,0x0623,
0x0644,0x0625,0x0644,0x0625,0x0644,0x0627,0x0644,0x0627,
};


#define UCS4_BMPHALFFULLMIN 0xff00
#define UCS4_BMPHALFFULLMAX 0xffef

static const unsigned short ucs4_bmphalffulldecomptab[240] = {
  0x0000,0x0021,0x0022,0x0023,0x0024,0x0025,0x0026,0x0027,
  0x0028,0x0029,0x002a,0x002b,0x002c,0x002d,0x002e,0x002f,
  0x0030,0x0031,0x0032,0x0033,0x0034,0x0035,0x0036,0x0037,
  0x0038,0x0039,0x003a,0x003b,0x003c,0x003d,0x003e,0x003f,
  0x0040,0x0041,0x0042,0x0043,0x0044,0x0045,0x0046,0x0047,
  0x0048,0x0049,0x004a,0x004b,0x004c,0x004d,0x004e,0x004f,
  0x0050,0x0051,0x0052,0x0053,0x0054,0x0055,0x0056,0x0057,
  0x0058,0x0059,0x005a,0x005b,0x005c,0x005d,0x005e,0x005f,
  0x0060,0x0061,0x0062,0x0063,0x0064,0x0065,0x0066,0x0067,
  0x0068,0x0069,0x006a,0x006b,0x006c,0x006d,0x006e,0x006f,
  0x0070,0x0071,0x0072,0x0073,0x0074,0x0075,0x0076,0x0077,
  0x0078,0x0079,0x007a,0x007b,0x007c,0x007d,0x007e,0x2985,
  0x2986,0x3002,0x300c,0x300d,0x3001,0x30fb,0x30f2,0x30a1,
  0x30a3,0x30a5,0x30a7,0x30a9,0x30e3,0x30e5,0x30e7,0x30c3,
  0x30fc,0x30a2,0x30a4,0x30a6,0x30a8,0x30aa,0x30ab,0x30ad,
  0x30af,0x30b1,0x30b3,0x30b5,0x30b7,0x30b9,0x30bb,0x30bd,
  0x30bf,0x30c1,0x30c4,0x30c6,0x30c8,0x30ca,0x30cb,0x30cc,
  0x30cd,0x30ce,0x30cf,0x30d2,0x30d5,0x30d8,0x30db,0x30de,
  0x30df,0x30e0,0x30e1,0x30e2,0x30e4,0x30e6,0x30e8,0x30e9,
  0x30ea,0x30eb,0x30ec,0x30ed,0x30ef,0x30f3,0x3099,0x309a,
  0x3164,0x3131,0x3132,0x3133,0x3134,0x3135,0x3136,0x3137,
  0x3138,0x3139,0x313a,0x313b,0x313c,0x313d,0x313e,0x313f,
  0x3140,0x3141,0x3142,0x3143,0x3144,0x3145,0x3146,0x3147,
  0x3148,0x3149,0x314a,0x314b,0x314c,0x314d,0x314e,0x0000,
  0x0000,0x0000,0x314f,0x3150,0x3151,0x3152,0x3153,0x3154,
  0x0000,0x0000,0x3155,0x3156,0x3157,0x3158,0x3159,0x315a,
  0x0000,0x0000,0x315b,0x315c,0x315d,0x315e,0x315f,0x3160,
  0x0000,0x0000,0x3161,0x3162,0x3163,0x0000,0x0000,0x0000,
  0x00a2,0x00a3,0x00ac,0x00af,0x00a6,0x00a5,0x20a9,0x0000,
  0x2502,0x2190,0x2191,0x2192,0x2193,0x25a0,0x25cb,0x0000
};

/* SMP decompositions */

	/* Musical */

#define UCS4_SMPMUSIC1MIN 0x1d15e
#define UCS4_SMPMUSIC1MAX 0x1d164

static const unsigned long ucs4_smpmusic1decomptab[7][2] = {
  {0x1d157,0x1d165},{0x1d158,0x1d165},{0x1d15f,0x1d16e},{0x1d15f,0x1d16f},
  {0x1d15f,0x1d170},{0x1d15f,0x1d171},{0x1d15f,0x1d172}
};


#define UCS4_SMPMUSIC2MIN 0x1d1bb
#define UCS4_SMPMUSIC2MAX 0x1d1c0

static const unsigned long ucs4_smpmusic2decomptab[6][2] = {
  {0x1d1b9,0x1d165},{0x1d1ba,0x1d165},{0x1d1bb,0x1d16e},
  {0x1d1bc,0x1d16e},{0x1d1bb,0x1d16f},{0x1d1bc,0x1d16f}
};


#define UCS4_SMPMATHMIN 0x1d400
#define UCS4_SMPMATHMAX 0x1d7ff

	/* Mathematical - 0 means hole (no decomposition) */
static const unsigned short ucs4_smpmathdecomptab[1024] = {
  0x0041,0x0042,0x0043,0x0044,0x0045,0x0046,0x0047,0x0048,
  0x0049,0x004a,0x004b,0x004c,0x004d,0x004e,0x004f,0x0050,
  0x0051,0x0052,0x0053,0x0054,0x0055,0x0056,0x0057,0x0058,
  0x0059,0x005a,0x0061,0x0062,0x0063,0x0064,0x0065,0x0066,
  0x0067,0x0068,0x0069,0x006a,0x006b,0x006c,0x006d,0x006e,
  0x006f,0x0070,0x0071,0x0072,0x0073,0x0074,0x0075,0x0076,
  0x0077,0x0078,0x0079,0x007a,0x0041,0x0042,0x0043,0x0044,
  0x0045,0x0046,0x0047,0x0048,0x0049,0x004a,0x004b,0x004c,
  0x004d,0x004e,0x004f,0x0050,0x0051,0x0052,0x0053,0x0054,
  0x0055,0x0056,0x0057,0x0058,0x0059,0x005a,0x0061,0x0062,
  0x0063,0x0064,0x0065,0x0066,0x0067,0x0000,0x0069,0x006a,
  0x006b,0x006c,0x006d,0x006e,0x006f,0x0070,0x0071,0x0072,
  0x0073,0x0074,0x0075,0x0076,0x0077,0x0078,0x0079,0x007a,
  0x0041,0x0042,0x0043,0x0044,0x0045,0x0046,0x0047,0x0048,
  0x0049,0x004a,0x004b,0x004c,0x004d,0x004e,0x004f,0x0050,
  0x0051,0x0052,0x0053,0x0054,0x0055,0x0056,0x0057,0x0058,
  0x0059,0x005a,0x0061,0x0062,0x0063,0x0064,0x0065,0x0066,
  0x0067,0x0068,0x0069,0x006a,0x006b,0x006c,0x006d,0x006e,
  0x006f,0x0070,0x0071,0x0072,0x0073,0x0074,0x0075,0x0076,
  0x0077,0x0078,0x0079,0x007a,0x0041,0x0000,0x0043,0x0044,
  0x0000,0x0000,0x0047,0x0000,0x004a,0x004b,0x0000,0x0000,
  0x004e,0x004f,0x0050,0x0051,0x0000,0x0053,0x0054,0x0055,
  0x0000,0x0056,0x0057,0x0058,0x0059,0x005a,0x0061,0x0062,
  0x0063,0x0064,0x0000,0x0066,0x0000,0x0068,0x0069,0x006a,
  0x006b,0x006c,0x006d,0x006e,0x0000,0x0070,0x0071,0x0072,
  0x0073,0x0074,0x0075,0x0076,0x0077,0x0078,0x0079,0x007a,
  0x0041,0x0042,0x0043,0x0044,0x0045,0x0046,0x0047,0x0048,
  0x0049,0x004a,0x004b,0x004c,0x004d,0x004e,0x004f,0x0050,
  0x0051,0x0052,0x0053,0x0054,0x0055,0x0056,0x0057,0x0058,
  0x0059,0x005a,0x0061,0x0062,0x0063,0x0064,0x0065,0x0066,
  0x0067,0x0068,0x0069,0x006a,0x006b,0x006c,0x006d,0x006e,
  0x006f,0x0070,0x0071,0x0072,0x0073,0x0074,0x0075,0x0076,
  0x0077,0x0078,0x0079,0x007a,0x0041,0x0042,0x0000,0x0044,
  0x0045,0x0046,0x0047,0x0000,0x004a,0x004b,0x004c,0x004d,
  0x0000,0x004e,0x004f,0x0050,0x0051,0x0000,0x0053,0x0054,
  0x0055,0x0056,0x0057,0x0058,0x0059,0x0000,0x0061,0x0062,
  0x0063,0x0064,0x0065,0x0066,0x0067,0x0068,0x0069,0x006a,
  0x006b,0x006c,0x006d,0x006e,0x006f,0x0070,0x0071,0x0072,
  0x0073,0x0074,0x0075,0x0076,0x0077,0x0078,0x0079,0x007a,
  0x0041,0x0042,0x0000,0x0044,0x0045,0x0046,0x0047,0x0000,
  0x0049,0x004a,0x004b,0x004c,0x004d,0x0000,0x004f,0x0000,
  0x0000,0x0000,0x0053,0x0054,0x0055,0x0056,0x0057,0x0058,
  0x0059,0x0000,0x0061,0x0062,0x0063,0x0064,0x0065,0x0066,
  0x0067,0x0068,0x0069,0x006a,0x006b,0x006c,0x006d,0x006e,
  0x006f,0x0070,0x0071,0x0072,0x0073,0x0074,0x0075,0x0076,
  0x0077,0x0078,0x0079,0x007a,0x0041,0x0042,0x0043,0x0044,
  0x0045,0x0046,0x0047,0x0048,0x0049,0x004a,0x004b,0x004c,
  0x004d,0x004e,0x004f,0x0050,0x0051,0x0052,0x0053,0x0054,
  0x0055,0x0056,0x0057,0x0058,0x0059,0x005a,0x0061,0x0062,
  0x0063,0x0064,0x0065,0x0066,0x0067,0x0068,0x0069,0x006a,
  0x006b,0x006c,0x006d,0x006e,0x006f,0x0070,0x0071,0x0072,
  0x0073,0x0074,0x0075,0x0076,0x0077,0x0078,0x0079,0x007a,
  0x0041,0x0042,0x0043,0x0044,0x0045,0x0046,0x0047,0x0048,
  0x0049,0x004a,0x004b,0x004c,0x004d,0x004e,0x004f,0x0050,
  0x0051,0x0052,0x0053,0x0054,0x0055,0x0056,0x0057,0x0058,
  0x0059,0x005a,0x0061,0x0062,0x0063,0x0064,0x0065,0x0066,
  0x0067,0x0068,0x0069,0x006a,0x006b,0x006c,0x006d,0x006e,
  0x006f,0x0070,0x0071,0x0072,0x0073,0x0074,0x0075,0x0076,
  0x0077,0x0078,0x0079,0x007a,0x0041,0x0042,0x0043,0x0044,
  0x0045,0x0046,0x0047,0x0048,0x0049,0x004a,0x004b,0x004c,
  0x004d,0x004e,0x004f,0x0050,0x0051,0x0052,0x0053,0x0054,
  0x0055,0x0056,0x0057,0x0058,0x0059,0x005a,0x0061,0x0062,
  0x0063,0x0064,0x0065,0x0066,0x0067,0x0068,0x0069,0x006a,
  0x006b,0x006c,0x006d,0x006e,0x006f,0x0070,0x0071,0x0072,
  0x0073,0x0074,0x0075,0x0076,0x0077,0x0078,0x0079,0x007a,
  0x0041,0x0042,0x0043,0x0044,0x0045,0x0046,0x0047,0x0048,
  0x0049,0x004a,0x004b,0x004c,0x004d,0x004e,0x004f,0x0050,
  0x0051,0x0052,0x0053,0x0054,0x0055,0x0056,0x0057,0x0058,
  0x0059,0x005a,0x0061,0x0062,0x0063,0x0064,0x0065,0x0066,
  0x0067,0x0068,0x0069,0x006a,0x006b,0x006c,0x006d,0x006e,
  0x006f,0x0070,0x0071,0x0072,0x0073,0x0074,0x0075,0x0076,
  0x0077,0x0078,0x0079,0x007a,0x0041,0x0042,0x0043,0x0044,
  0x0045,0x0046,0x0047,0x0048,0x0049,0x004a,0x004b,0x004c,
  0x004d,0x004e,0x004f,0x0050,0x0051,0x0052,0x0053,0x0054,
  0x0055,0x0056,0x0057,0x0058,0x0059,0x005a,0x0061,0x0062,
  0x0063,0x0064,0x0065,0x0066,0x0067,0x0068,0x0069,0x006a,
  0x006b,0x006c,0x006d,0x006e,0x006f,0x0070,0x0071,0x0072,
  0x0073,0x0074,0x0075,0x0076,0x0077,0x0078,0x0079,0x007a,
  0x0041,0x0042,0x0043,0x0044,0x0045,0x0046,0x0047,0x0048,
  0x0049,0x004a,0x004b,0x004c,0x004d,0x004e,0x004f,0x0050,
  0x0051,0x0052,0x0053,0x0054,0x0055,0x0056,0x0057,0x0058,
  0x0059,0x005a,0x0061,0x0062,0x0063,0x0064,0x0065,0x0066,
  0x0067,0x0068,0x0069,0x006a,0x006b,0x006c,0x006d,0x006e,
  0x006f,0x0070,0x0071,0x0072,0x0073,0x0074,0x0075,0x0076,
  0x0077,0x0078,0x0079,0x007a,0x0131,0x0237,0x0000,0x0000,
  0x0391,0x0392,0x0393,0x0394,0x0395,0x0396,0x0397,0x0398,
  0x0399,0x039a,0x039b,0x039c,0x039d,0x039e,0x039f,0x03a0,
  0x03a1,0x03f4,0x03a3,0x03a4,0x03a5,0x03a6,0x03a7,0x03a8,
  0x03a9,0x2207,0x03b1,0x03b2,0x03b3,0x03b4,0x03b5,0x03b6,
  0x03b7,0x03b8,0x03b9,0x03ba,0x03bb,0x03bc,0x03bd,0x03be,
  0x03bf,0x03c0,0x03c1,0x03c2,0x03c3,0x03c4,0x03c5,0x03c6,
  0x03c7,0x03c8,0x03c9,0x2202,0x03f5,0x03d1,0x03f0,0x03d5,
  0x03f1,0x03d6,0x0391,0x0392,0x0393,0x0394,0x0395,0x0396,
  0x0397,0x0398,0x0399,0x039a,0x039b,0x039c,0x039d,0x039e,
  0x039f,0x03a0,0x03a1,0x03f4,0x03a3,0x03a4,0x03a5,0x03a6,
  0x03a7,0x03a8,0x03a9,0x2207,0x03b1,0x03b2,0x03b3,0x03b4,
  0x03b5,0x03b6,0x03b7,0x03b8,0x03b9,0x03ba,0x03bb,0x03bc,
  0x03bd,0x03be,0x03bf,0x03c0,0x03c1,0x03c2,0x03c3,0x03c4,
  0x03c5,0x03c6,0x03c7,0x03c8,0x03c9,0x2202,0x03f5,0x03d1,
  0x03f0,0x03d5,0x03f1,0x03d6,0x0391,0x0392,0x0393,0x0394,
  0x0395,0x0396,0x0397,0x0398,0x0399,0x039a,0x039b,0x039c,
  0x039d,0x039e,0x039f,0x03a0,0x03a1,0x03f4,0x03a3,0x03a4,
  0x03a5,0x03a6,0x03a7,0x03a8,0x03a9,0x2207,0x03b1,0x03b2,
  0x03b3,0x03b4,0x03b5,0x03b6,0x03b7,0x03b8,0x03b9,0x03ba,
  0x03bb,0x03bc,0x03bd,0x03be,0x03bf,0x03c0,0x03c1,0x03c2,
  0x03c3,0x03c4,0x03c5,0x03c6,0x03c7,0x03c8,0x03c9,0x2202,
  0x03f5,0x03d1,0x03f0,0x03d5,0x03f1,0x03d6,0x0391,0x0392,
  0x0393,0x0394,0x0395,0x0396,0x0397,0x0398,0x0399,0x039a,
  0x039b,0x039c,0x039d,0x039e,0x039f,0x03a0,0x03a1,0x03f4,
  0x03a3,0x03a4,0x03a5,0x03a6,0x03a7,0x03a8,0x03a9,0x2207,
  0x03b1,0x03b2,0x03b3,0x03b4,0x03b5,0x03b6,0x03b7,0x03b8,
  0x03b9,0x03ba,0x03bb,0x03bc,0x03bd,0x03be,0x03bf,0x03c0,
  0x03c1,0x03c2,0x03c3,0x03c4,0x03c5,0x03c6,0x03c7,0x03c8,
  0x03c9,0x2202,0x03f5,0x03d1,0x03f0,0x03d5,0x03f1,0x03d6,
  0x0391,0x0392,0x0393,0x0394,0x0395,0x0396,0x0397,0x0398,
  0x0399,0x039a,0x039b,0x039c,0x039d,0x039e,0x039f,0x03a0,
  0x03a1,0x03f4,0x03a3,0x03a4,0x03a5,0x03a6,0x03a7,0x03a8,
  0x03a9,0x2207,0x03b1,0x03b2,0x03b3,0x03b4,0x03b5,0x03b6,
  0x03b7,0x03b8,0x03b9,0x03ba,0x03bb,0x03bc,0x03bd,0x03be,
  0x03bf,0x03c0,0x03c1,0x03c2,0x03c3,0x03c4,0x03c5,0x03c6,
  0x03c7,0x03c8,0x03c9,0x2202,0x03f5,0x03d1,0x03f0,0x03d5,
  0x03f1,0x03d6,0x03dc,0x03dd,0x0000,0x0000,0x0030,0x0031,
  0x0032,0x0033,0x0034,0x0035,0x0036,0x0037,0x0038,0x0039,
  0x0030,0x0031,0x0032,0x0033,0x0034,0x0035,0x0036,0x0037,
  0x0038,0x0039,0x0030,0x0031,0x0032,0x0033,0x0034,0x0035,
  0x0036,0x0037,0x0038,0x0039,0x0030,0x0031,0x0032,0x0033,
  0x0034,0x0035,0x0036,0x0037,0x0038,0x0039,0x0030,0x0031,
  0x0032,0x0033,0x0034,0x0035,0x0036,0x0037,0x0038,0x0039
};

/* SIP decompositions */

#define UCS4_SIPMIN 0x2f800
#define UCS4_SIPMAX 0x2fa1d

	/* CJK compatibility ideographs - no holes */
static const unsigned long ucs4_sipdecomptab[542] = {
   0x4e3d, 0x4e38, 0x4e41,0x20122, 0x4f60, 0x4fae, 0x4fbb, 0x5002,
   0x507a, 0x5099, 0x50e7, 0x50cf, 0x349e,0x2063a, 0x514d, 0x5154,
   0x5164, 0x5177,0x2051c, 0x34b9, 0x5167, 0x518d,0x2054b, 0x5197,
   0x51a4, 0x4ecc, 0x51ac, 0x51b5,0x291df, 0x51f5, 0x5203, 0x34df,
   0x523b, 0x5246, 0x5272, 0x5277, 0x3515, 0x52c7, 0x52c9, 0x52e4,
   0x52fa, 0x5305, 0x5306, 0x5317, 0x5349, 0x5351, 0x535a, 0x5373,
   0x537d, 0x537f, 0x537f, 0x537f,0x20a2c, 0x7070, 0x53ca, 0x53df,
  0x20b63, 0x53eb, 0x53f1, 0x5406, 0x549e, 0x5438, 0x5448, 0x5468,
   0x54a2, 0x54f6, 0x5510, 0x5553, 0x5563, 0x5584, 0x5584, 0x5599,
   0x55ab, 0x55b3, 0x55c2, 0x5716, 0x5606, 0x5717, 0x5651, 0x5674,
   0x5207, 0x58ee, 0x57ce, 0x57f4, 0x580d, 0x578b, 0x5832, 0x5831,
   0x58ac,0x214e4, 0x58f2, 0x58f7, 0x5906, 0x591a, 0x5922, 0x5962,
  0x216a8,0x216ea, 0x59ec, 0x5a1b, 0x5a27, 0x59d8, 0x5a66, 0x36ee,
   0x36fc, 0x5b08, 0x5b3e, 0x5b3e,0x219c8, 0x5bc3, 0x5bd8, 0x5be7,
   0x5bf3,0x21b18, 0x5bff, 0x5c06, 0x5f53, 0x5c22, 0x3781, 0x5c60,
   0x5c6e, 0x5cc0, 0x5c8d,0x21de4, 0x5d43,0x21de6, 0x5d6e, 0x5d6b,
   0x5d7c, 0x5de1, 0x5de2, 0x382f, 0x5dfd, 0x5e28, 0x5e3d, 0x5e69,
   0x3862,0x22183, 0x387c, 0x5eb0, 0x5eb3, 0x5eb6, 0x5eca,0x2a392,
   0x5efe,0x22331,0x22331, 0x8201, 0x5f22, 0x5f22, 0x38c7,0x232b8,
  0x261da, 0x5f62, 0x5f6b, 0x38e3, 0x5f9a, 0x5fcd, 0x5fd7, 0x5ff9,
   0x6081, 0x393a, 0x391c, 0x6094,0x226d4, 0x60c7, 0x6148, 0x614c,
   0x614e, 0x614c, 0x617a, 0x618e, 0x61b2, 0x61a4, 0x61af, 0x61de,
   0x61f2, 0x61f6, 0x6210, 0x621b, 0x625d, 0x62b1, 0x62d4, 0x6350,
  0x22b0c, 0x633d, 0x62fc, 0x6368, 0x6383, 0x63e4,0x22bf1, 0x6422,
   0x63c5, 0x63a9, 0x3a2e, 0x6469, 0x647e, 0x649d, 0x6477, 0x3a6c,
   0x654f, 0x656c,0x2300a, 0x65e3, 0x66f8, 0x6649, 0x3b19, 0x6691,
   0x3b08, 0x3ae4, 0x5192, 0x5195, 0x6700, 0x669c, 0x80ad, 0x43d9,
   0x6717, 0x671b, 0x6721, 0x675e, 0x6753,0x233c3, 0x3b49, 0x67fa,
   0x6785, 0x6852, 0x6885,0x2346d, 0x688e, 0x681f, 0x6914, 0x3b9d,
   0x6942, 0x69a3, 0x69ea, 0x6aa8,0x236a3, 0x6adb, 0x3c18, 0x6b21,
  0x238a7, 0x6b54, 0x3c4e, 0x6b72, 0x6b9f, 0x6bba, 0x6bbb,0x23a8d,
  0x21d0b,0x23afa, 0x6c4e,0x23cbc, 0x6cbf, 0x6ccd, 0x6c67, 0x6d16,
   0x6d3e, 0x6d77, 0x6d41, 0x6d69, 0x6d78, 0x6d85,0x23d1e, 0x6d34,
   0x6e2f, 0x6e6e, 0x3d33, 0x6ecb, 0x6ec7,0x23ed1, 0x6df9, 0x6f6e,
  0x23f5e,0x23f8e, 0x6fc6, 0x7039, 0x701e, 0x701b, 0x3d96, 0x704a,
   0x707d, 0x7077, 0x70ad,0x20525, 0x7145,0x24263, 0x719c,0x243ab,
   0x7228, 0x7235, 0x7250,0x24608, 0x7280, 0x7295,0x24735,0x24814,
   0x737a, 0x738b, 0x3eac, 0x73a5, 0x3eb8, 0x3eb8, 0x7447, 0x745c,
   0x7471, 0x7485, 0x74ca, 0x3f1b, 0x7524,0x24c36, 0x753e,0x24c92,
   0x7570,0x2219f, 0x7610,0x24fa1,0x24fb8,0x25044, 0x3ffc, 0x4008,
   0x76f4,0x250f3,0x250f2,0x25119,0x25133, 0x771e, 0x771f, 0x771f,
   0x774a, 0x4039, 0x778b, 0x4046, 0x4096,0x2541d, 0x784e, 0x788c,
   0x78cc, 0x40e3,0x25626, 0x7956,0x2569a,0x256c5, 0x798f, 0x79eb,
   0x412f, 0x7a40, 0x7a4a, 0x7a4f,0x2597c,0x25aa7,0x25aa7, 0x7aee,
   0x4202,0x25bab, 0x7bc6, 0x7bc9, 0x4227,0x25c80, 0x7cd2, 0x42a0,
   0x7ce8, 0x7ce3, 0x7d00,0x25f86, 0x7d63, 0x4301, 0x7dc7, 0x7e02,
   0x7e45, 0x4334,0x26228,0x26247, 0x4359,0x262d9, 0x7f7a,0x2633e,
   0x7f95, 0x7ffa, 0x8005,0x264da,0x26523, 0x8060,0x265a8, 0x8070,
  0x2335f, 0x43d5, 0x80b2, 0x8103, 0x440b, 0x813e, 0x5ab5,0x267a7,
  0x267b5,0x23393,0x2339c, 0x8201, 0x8204, 0x8f9e, 0x446b, 0x8291,
   0x828b, 0x829d, 0x52b3, 0x82b1, 0x82b3, 0x82bd, 0x82e6,0x26b3c,
   0x82e5, 0x831d, 0x8363, 0x83ad, 0x8323, 0x83bd, 0x83e7, 0x8457,
   0x8353, 0x83ca, 0x83cc, 0x83dc,0x26c36,0x26d6b,0x26cd5, 0x452b,
   0x84f1, 0x84f3, 0x8516,0x273ca, 0x8564,0x26f2c, 0x455d, 0x4561,
  0x26fb1,0x270d2, 0x456b, 0x8650, 0x865c, 0x8667, 0x8669, 0x86a9,
   0x8688, 0x870e, 0x86e2, 0x8779, 0x8728, 0x876b, 0x8786, 0x45d7,
   0x87e1, 0x8801, 0x45f9, 0x8860, 0x8863,0x27667, 0x88d7, 0x88de,
   0x4635, 0x88fa, 0x34bb,0x278ae,0x27966, 0x46be, 0x46c7, 0x8aa0,
   0x8aed, 0x8b8a, 0x8c55,0x27ca8, 0x8cab, 0x8cc1, 0x8d1b, 0x8d77,
  0x27f2f,0x20804, 0x8dcb, 0x8dbc, 0x8df0,0x208de, 0x8ed4, 0x8f38,
  0x285d2,0x285ed, 0x9094, 0x90f1, 0x9111,0x2872e, 0x911b, 0x9238,
   0x92d7, 0x92d8, 0x927c, 0x93f9, 0x9415,0x28bfa, 0x958b, 0x4995,
   0x95b7,0x28d77, 0x49e6, 0x96c3, 0x5db2, 0x9723,0x29145,0x2921a,
   0x4a6e, 0x4a76, 0x97e0,0x2940a, 0x4ab2,0x29496, 0x980b, 0x980b,
   0x9829,0x295b6, 0x98e2, 0x4b33, 0x9929, 0x99a7, 0x99c2, 0x99fe,
   0x4bce,0x29b30, 0x9b12, 0x9c40, 0x9cfd, 0x4cce, 0x4ced, 0x9d67,
  0x2a0ce, 0x4cf8,0x2a105,0x2a20e,0x2a291, 0x9ebb, 0x4d56, 0x9ef9,
   0x9efe, 0x9f05, 0x9f0f, 0x9f16, 0x9f3b,0x2a600
};
