/*
 * Decompiled with CFR 0.152.
 */
package cds.healpix;

import cds.healpix.AngularDistanceComputer;
import cds.healpix.CompassPoint;
import cds.healpix.ConeOrdinalHashComputer;
import cds.healpix.HashComputer;
import cds.healpix.Healpix;
import cds.healpix.NewtonMethod;
import cds.healpix.VerticesAndPathComputer;
import cds.healpix.common.math.Math;
import java.util.EnumMap;

final class SmallConeOrdinalHashComputer
implements ConeOrdinalHashComputer {
    public static final SmallConeOrdinalHashComputer UI = new SmallConeOrdinalHashComputer();

    private SmallConeOrdinalHashComputer() {
    }

    @Override
    public int computeOrdinalHash(double coneCenterLonRad, double coneCenterLatRad, double coneRadiusRad, HashComputer hashComputer, AngularDistanceComputer angDistComputer, double relativePrecision, int nIterMax, long hashCenterAtSmallestDepth, VerticesAndPathComputer verticesComputerAtSmallestDepth, EnumMap<CompassPoint.Cardinal, double[]> vertices, double cosConeCenterLat, double sinConeCenterLat, double twoSineOfHalfConeRadius, double squareOfsinOfHalfR, long[] result) {
        double sinOfConeRadius = angDistComputer.sin(coneRadiusRad);
        verticesComputerAtSmallestDepth.vertices(hashCenterAtSmallestDepth, vertices);
        int resultSize = 0;
        resultSize = Healpix.isLatInNorthPolarCap(coneCenterLatRad) ? this.edgesNEWinNPC(coneCenterLonRad, coneCenterLatRad, coneRadiusRad, hashComputer, angDistComputer, relativePrecision, nIterMax, cosConeCenterLat, sinConeCenterLat, twoSineOfHalfConeRadius, squareOfsinOfHalfR, sinOfConeRadius, vertices, result, resultSize) : (Healpix.isLatInSouthPolarCap(coneCenterLatRad + coneRadiusRad) ? this.edgesNEWinSPC(coneCenterLonRad, coneCenterLatRad, coneRadiusRad, hashComputer, angDistComputer, relativePrecision, nIterMax, cosConeCenterLat, sinConeCenterLat, twoSineOfHalfConeRadius, squareOfsinOfHalfR, sinOfConeRadius, vertices, result, resultSize) : this.edgesNEWinEQR(coneCenterLonRad, coneCenterLatRad, coneRadiusRad, hashComputer, angDistComputer, relativePrecision, nIterMax, cosConeCenterLat, sinConeCenterLat, twoSineOfHalfConeRadius, squareOfsinOfHalfR, sinOfConeRadius, vertices, result, resultSize));
        resultSize = Healpix.isLatInNorthPolarCap(coneCenterLatRad - coneRadiusRad) ? this.edgesSEWinNPC(coneCenterLonRad, coneCenterLatRad, coneRadiusRad, hashComputer, angDistComputer, relativePrecision, nIterMax, cosConeCenterLat, sinConeCenterLat, twoSineOfHalfConeRadius, squareOfsinOfHalfR, sinOfConeRadius, vertices, result, resultSize) : (Healpix.isLatInSouthPolarCap(coneCenterLatRad) ? this.edgesSEWinSPC(coneCenterLonRad, coneCenterLatRad, coneRadiusRad, hashComputer, angDistComputer, relativePrecision, nIterMax, cosConeCenterLat, sinConeCenterLat, twoSineOfHalfConeRadius, squareOfsinOfHalfR, sinOfConeRadius, vertices, result, resultSize) : this.edgesSEWinEQR(coneCenterLonRad, coneCenterLatRad, coneRadiusRad, hashComputer, angDistComputer, relativePrecision, nIterMax, cosConeCenterLat, sinConeCenterLat, twoSineOfHalfConeRadius, squareOfsinOfHalfR, sinOfConeRadius, vertices, result, resultSize));
        return resultSize;
    }

    private double toLocalX(double lonRad, double latRad, double coneCenterLonRad, double coneCenterLatRad, double cosConeCenterLat, AngularDistanceComputer angDistComputer) {
        return cosConeCenterLat * angDistComputer.sin(lonRad - coneCenterLonRad) / angDistComputer.cos(lonRad - coneCenterLonRad);
    }

    private static double toLocalY(double latRad, double coneCenterLatRad, AngularDistanceComputer angDistComputer) {
        return angDistComputer.sin(latRad - coneCenterLatRad);
    }

    private double latOfParallelLineTangentToCone(double sinOfConeRadius, double coneCenterLonRad, double coneCenterLatRad, double cosConeCenterLat, double sinConeCenterLat, double lonA, double latA, double lonB, double latB, boolean northSolution, AngularDistanceComputer angDistComputer) {
        double xA = this.toLocalX(lonA, latA, coneCenterLonRad, coneCenterLatRad, cosConeCenterLat, angDistComputer);
        double yA = SmallConeOrdinalHashComputer.toLocalY(latA, coneCenterLatRad, angDistComputer);
        double xB = this.toLocalX(lonB, latB, coneCenterLonRad, coneCenterLatRad, cosConeCenterLat, angDistComputer);
        double yB = SmallConeOrdinalHashComputer.toLocalY(latB, coneCenterLatRad, angDistComputer);
        double slope = (yB - yA) / (xB - xA);
        double r = sinOfConeRadius;
        if (!Math.isFinite(slope)) {
            assert (Math.abs(xB - xA) < 1.0E-15);
            return coneCenterLatRad;
        }
        double a = slope * slope + 1.0;
        double interceptUniqSolution = (northSolution ? r : -r) * java.lang.Math.sqrt(a);
        double bUniqSolution = 2.0 * slope * interceptUniqSolution;
        double x = -bUniqSolution / (2.0 * a);
        double y = slope * x + interceptUniqSolution;
        return coneCenterLatRad + angDistComputer.asin(y);
    }

    private final int edgesNEWinEQR(double coneCenterLonRad, double coneCenterLatRad, double coneRadiusRad, HashComputer hashComputer, AngularDistanceComputer angDistComputer, double relativePrecision, int nIterMax, double cosConeCenterLat, double sinConeCenterLat, double twoSineOfHalfConeRadius, double squareOfsinOfHalfR, double sinOfConeRadius, EnumMap<CompassPoint.Cardinal, double[]> vertices, long[] result, int resultSize) {
        double[] lonLatN = vertices.get((Object)CompassPoint.Cardinal.N);
        double[] lonLatE = vertices.get((Object)CompassPoint.Cardinal.E);
        double latRad = this.latOfParallelLineTangentToCone(sinOfConeRadius, coneCenterLonRad, coneCenterLatRad, cosConeCenterLat, sinConeCenterLat, lonLatN[0], lonLatN[1], lonLatE[0], lonLatE[1], true, angDistComputer);
        latRad = NewtonMethod.newtonSolveEquatorialZone(latRad, coneCenterLatRad, cosConeCenterLat, squareOfsinOfHalfR, false, relativePrecision, nIterMax, angDistComputer);
        double zDxDyEq1 = Math.sin(latRad);
        if (Healpix.isLatInNorthPolarCap(latRad)) {
            resultSize = this.edgesNEWinNPC(coneCenterLonRad, coneCenterLatRad, coneRadiusRad, hashComputer, angDistComputer, relativePrecision, nIterMax, cosConeCenterLat, sinConeCenterLat, twoSineOfHalfConeRadius, squareOfsinOfHalfR, sinOfConeRadius, vertices, result, resultSize);
        } else if (Healpix.isLatInSouthPolarCap(latRad)) {
            resultSize = this.edgesNEWinSPC(coneCenterLonRad, coneCenterLatRad, coneRadiusRad, hashComputer, angDistComputer, relativePrecision, nIterMax, cosConeCenterLat, sinConeCenterLat, twoSineOfHalfConeRadius, squareOfsinOfHalfR, sinOfConeRadius, vertices, result, resultSize);
        } else {
            double deltaLon = angDistComputer.coneDeltaLon(squareOfsinOfHalfR, cosConeCenterLat, latRad - coneCenterLatRad, zDxDyEq1);
            result[resultSize++] = Math.isFinite(deltaLon) ? hashComputer.hash(coneCenterLonRad + deltaLon, latRad) : -1L;
            result[resultSize++] = Math.isFinite(deltaLon) ? hashComputer.hash(coneCenterLonRad - deltaLon, latRad) : -1L;
        }
        return resultSize;
    }

    private final int edgesSEWinEQR(double coneCenterLonRad, double coneCenterLatRad, double coneRadiusRad, HashComputer hashComputer, AngularDistanceComputer angDistComputer, double relativePrecision, int nIterMax, double cosConeCenterLat, double sinConeCenterLat, double twoSineOfHalfConeRadius, double squareOfsinOfHalfR, double sinOfConeRadius, EnumMap<CompassPoint.Cardinal, double[]> vertices, long[] result, int resultSize) {
        double[] lonLatS = vertices.get((Object)CompassPoint.Cardinal.S);
        double[] lonLatE = vertices.get((Object)CompassPoint.Cardinal.E);
        double latRad = this.latOfParallelLineTangentToCone(sinOfConeRadius, coneCenterLonRad, coneCenterLatRad, cosConeCenterLat, sinConeCenterLat, lonLatS[0], lonLatS[1], lonLatE[0], lonLatE[1], false, angDistComputer);
        latRad = NewtonMethod.newtonSolveEquatorialZone(latRad, coneCenterLatRad, cosConeCenterLat, squareOfsinOfHalfR, true, relativePrecision, nIterMax, angDistComputer);
        double zDxDyEq1 = Math.sin(latRad);
        if (Healpix.isLatInNorthPolarCap(latRad)) {
            resultSize = this.edgesSEWinNPC(coneCenterLonRad, coneCenterLatRad, coneRadiusRad, hashComputer, angDistComputer, relativePrecision, nIterMax, cosConeCenterLat, sinConeCenterLat, twoSineOfHalfConeRadius, squareOfsinOfHalfR, sinOfConeRadius, vertices, result, resultSize);
        } else if (Healpix.isLatInSouthPolarCap(latRad)) {
            resultSize = this.edgesSEWinSPC(coneCenterLonRad, coneCenterLatRad, coneRadiusRad, hashComputer, angDistComputer, relativePrecision, nIterMax, cosConeCenterLat, sinConeCenterLat, twoSineOfHalfConeRadius, squareOfsinOfHalfR, sinOfConeRadius, vertices, result, resultSize);
        } else {
            double deltaLon = angDistComputer.coneDeltaLon(squareOfsinOfHalfR, cosConeCenterLat, coneCenterLatRad - latRad, zDxDyEq1);
            result[resultSize++] = Math.isFinite(deltaLon) ? hashComputer.hash(coneCenterLonRad + deltaLon, latRad) : -1L;
            result[resultSize++] = Math.isFinite(deltaLon) ? hashComputer.hash(coneCenterLonRad - deltaLon, latRad) : -1L;
        }
        return resultSize;
    }

    private final int edgesNEWinNPC(double coneCenterLonRad, double coneCenterLatRad, double coneRadiusRad, HashComputer hashComputer, AngularDistanceComputer angDistComputer, double relativePrecision, int nIterMax, double cosConeCenterLat, double sinConeCenterLat, double twoSineOfHalfConeRadius, double squareOfsinOfHalfR, double sinOfConeRadius, EnumMap<CompassPoint.Cardinal, double[]> vertices, long[] result, int resultSize) {
        boolean containsNorthPole;
        double[] lonLatN = vertices.get((Object)CompassPoint.Cardinal.N);
        double[] lonLatE = vertices.get((Object)CompassPoint.Cardinal.E);
        double[] lonLatW = vertices.get((Object)CompassPoint.Cardinal.W);
        double coneCenterLonModHalfPi = coneCenterLonRad % 1.5707963267948966;
        boolean bl = containsNorthPole = coneCenterLatRad + coneRadiusRad > 1.5707963267948966;
        if (containsNorthPole) {
            double dCN = 1.5707963267948966 - coneCenterLatRad;
            double d1 = coneRadiusRad + dCN;
            double d2 = coneRadiusRad - dCN;
            double cosL = java.lang.Math.cos(coneCenterLonModHalfPi);
            double sinL = java.lang.Math.sin(coneCenterLonModHalfPi);
            double latStart = 0.5 * (d1 * cosL + d2 * sinL);
            double latRad = NewtonMethod.newtonSolveNorthPolarCapZone(latStart, true, coneCenterLonModHalfPi - 1.5707963267948966, coneCenterLatRad, cosConeCenterLat, squareOfsinOfHalfR, false, relativePrecision, nIterMax, angDistComputer);
            double zDxDyEq1 = Math.sin(latRad);
            double deltaLon = angDistComputer.coneDeltaLon(squareOfsinOfHalfR, cosConeCenterLat, coneCenterLatRad - latRad, zDxDyEq1);
            result[resultSize++] = Math.isFinite(deltaLon) ? hashComputer.hash(coneCenterLonRad + deltaLon, latRad) : -1L;
            latStart = 0.5 * (d2 * cosL + d1 * sinL);
            latRad = NewtonMethod.newtonSolveNorthPolarCapZone(latStart, false, 1.5707963267948966 + coneCenterLonModHalfPi, coneCenterLatRad, cosConeCenterLat, squareOfsinOfHalfR, true, relativePrecision, nIterMax, angDistComputer);
            zDxDyEq1 = Math.sin(latRad);
            deltaLon = angDistComputer.coneDeltaLon(squareOfsinOfHalfR, cosConeCenterLat, coneCenterLatRad - latRad, zDxDyEq1);
            result[resultSize++] = Math.isFinite(deltaLon) ? hashComputer.hash(coneCenterLonRad - deltaLon, latRad) : -1L;
        } else {
            double zDxDyEq1;
            double latRad = this.latOfParallelLineTangentToCone(sinOfConeRadius, coneCenterLonRad, coneCenterLatRad, cosConeCenterLat, sinConeCenterLat, lonLatN[0], lonLatN[1], lonLatE[0], lonLatE[1], true, angDistComputer);
            double deltaLon = angDistComputer.coneDeltaLon(squareOfsinOfHalfR, cosConeCenterLat, (latRad = NewtonMethod.newtonSolveNorthPolarCapZone(latRad, true, coneCenterLonModHalfPi, coneCenterLatRad, cosConeCenterLat, squareOfsinOfHalfR, true, relativePrecision, nIterMax, angDistComputer)) - coneCenterLatRad, zDxDyEq1 = Math.sin(latRad));
            if (Math.isFinite(deltaLon) && coneCenterLonModHalfPi + deltaLon <= 1.5707963267948966) {
                result[resultSize++] = hashComputer.hash(coneCenterLonRad + deltaLon, latRad);
            } else {
                latRad = this.latOfParallelLineTangentToCone(sinOfConeRadius, coneCenterLonRad, coneCenterLatRad, cosConeCenterLat, sinConeCenterLat, lonLatN[0], lonLatN[1], 2.0 * lonLatN[0] - lonLatW[0], lonLatW[1], true, angDistComputer);
                deltaLon = angDistComputer.coneDeltaLon(squareOfsinOfHalfR, cosConeCenterLat, (latRad = NewtonMethod.newtonSolveNorthPolarCapZone(latRad, true, coneCenterLonModHalfPi - 1.5707963267948966, coneCenterLatRad, cosConeCenterLat, squareOfsinOfHalfR, true, relativePrecision, nIterMax, angDistComputer)) - coneCenterLatRad, zDxDyEq1 = Math.sin(latRad));
                if (Math.isFinite(deltaLon)) {
                    result[resultSize++] = hashComputer.hash(coneCenterLonRad + deltaLon, latRad);
                } else {
                    latRad = this.latOfParallelLineTangentToCone(sinOfConeRadius, coneCenterLonRad, coneCenterLatRad, cosConeCenterLat, sinConeCenterLat, lonLatN[0], lonLatN[1], lonLatE[0], lonLatE[1], false, angDistComputer);
                    latRad = NewtonMethod.newtonSolveNorthPolarCapZone(latRad, true, coneCenterLonModHalfPi - 1.5707963267948966, coneCenterLatRad, cosConeCenterLat, squareOfsinOfHalfR, false, relativePrecision, nIterMax, angDistComputer);
                    zDxDyEq1 = Math.sin(latRad);
                    deltaLon = angDistComputer.coneDeltaLon(squareOfsinOfHalfR, cosConeCenterLat, coneCenterLatRad - latRad, zDxDyEq1);
                    result[resultSize++] = Math.isFinite(deltaLon) ? hashComputer.hash(coneCenterLonRad + deltaLon, latRad) : -1L;
                }
            }
            latRad = this.latOfParallelLineTangentToCone(sinOfConeRadius, coneCenterLonRad, coneCenterLatRad, cosConeCenterLat, sinConeCenterLat, lonLatW[0], lonLatW[1], lonLatN[0], lonLatN[1], true, angDistComputer);
            latRad = NewtonMethod.newtonSolveNorthPolarCapZone(latRad, false, coneCenterLonModHalfPi, coneCenterLatRad, cosConeCenterLat, squareOfsinOfHalfR, false, relativePrecision, nIterMax, angDistComputer);
            zDxDyEq1 = Math.sin(latRad);
            deltaLon = angDistComputer.coneDeltaLon(squareOfsinOfHalfR, cosConeCenterLat, latRad - coneCenterLatRad, zDxDyEq1);
            if (Math.isFinite(deltaLon) && coneCenterLonModHalfPi - deltaLon >= 0.0) {
                result[resultSize++] = hashComputer.hash(coneCenterLonRad - deltaLon, latRad);
            } else {
                latRad = this.latOfParallelLineTangentToCone(sinOfConeRadius, coneCenterLonRad, coneCenterLatRad, cosConeCenterLat, sinConeCenterLat, 2.0 * lonLatN[0] - lonLatE[0], lonLatE[1], lonLatN[0], lonLatN[1], true, angDistComputer);
                latRad = NewtonMethod.newtonSolveNorthPolarCapZone(latRad, false, 1.5707963267948966 + coneCenterLonModHalfPi, coneCenterLatRad, cosConeCenterLat, squareOfsinOfHalfR, true, relativePrecision, nIterMax, angDistComputer);
                zDxDyEq1 = Math.sin(latRad);
                deltaLon = angDistComputer.coneDeltaLon(squareOfsinOfHalfR, cosConeCenterLat, (latRad = Math.asin(zDxDyEq1)) - coneCenterLatRad, zDxDyEq1);
                if (Math.isFinite(deltaLon)) {
                    result[resultSize++] = hashComputer.hash(coneCenterLonRad - deltaLon, latRad);
                } else {
                    latRad = this.latOfParallelLineTangentToCone(sinOfConeRadius, coneCenterLonRad, coneCenterLatRad, cosConeCenterLat, sinConeCenterLat, lonLatW[0], lonLatW[1], lonLatN[0], lonLatN[1], false, angDistComputer);
                    latRad = NewtonMethod.newtonSolveNorthPolarCapZone(latRad, false, 1.5707963267948966 + coneCenterLonModHalfPi, coneCenterLatRad, cosConeCenterLat, squareOfsinOfHalfR, true, relativePrecision, nIterMax, angDistComputer);
                    zDxDyEq1 = Math.sin(latRad);
                    deltaLon = angDistComputer.coneDeltaLon(squareOfsinOfHalfR, cosConeCenterLat, coneCenterLatRad - latRad, zDxDyEq1);
                    result[resultSize++] = Math.isFinite(deltaLon) ? hashComputer.hash(coneCenterLonRad - deltaLon, latRad) : -1L;
                }
            }
        }
        return resultSize;
    }

    private final int edgesSEWinNPC(double coneCenterLonRad, double coneCenterLatRad, double coneRadiusRad, HashComputer hashComputer, AngularDistanceComputer angDistComputer, double relativePrecision, int nIterMax, double cosConeCenterLat, double sinConeCenterLat, double twoSineOfHalfConeRadius, double squareOfsinOfHalfR, double sinOfConeRadius, EnumMap<CompassPoint.Cardinal, double[]> vertices, long[] result, int resultSize) {
        double[] lonLatN;
        double zDxDyEq1;
        double coneCenterLonModHalfPi = coneCenterLonRad % 1.5707963267948966;
        double[] lonLatS = vertices.get((Object)CompassPoint.Cardinal.S);
        double[] lonLatE = vertices.get((Object)CompassPoint.Cardinal.E);
        double[] lonLatW = vertices.get((Object)CompassPoint.Cardinal.W);
        double latRad = this.latOfParallelLineTangentToCone(sinOfConeRadius, coneCenterLonRad, coneCenterLatRad, cosConeCenterLat, sinConeCenterLat, lonLatS[0], lonLatS[1], lonLatE[0], lonLatE[1], false, angDistComputer);
        double deltaLon = angDistComputer.coneDeltaLon(squareOfsinOfHalfR, cosConeCenterLat, coneCenterLatRad - (latRad = NewtonMethod.newtonSolveNorthPolarCapZone(latRad, true, coneCenterLonModHalfPi, coneCenterLatRad, cosConeCenterLat, squareOfsinOfHalfR, false, relativePrecision, nIterMax, angDistComputer)), zDxDyEq1 = Math.sin(latRad));
        if (Math.isFinite(deltaLon) && coneCenterLonModHalfPi + deltaLon <= 1.5707963267948966) {
            result[resultSize++] = hashComputer.hash(coneCenterLonRad + deltaLon, latRad);
        } else {
            lonLatN = vertices.get((Object)CompassPoint.Cardinal.S);
            latRad = this.latOfParallelLineTangentToCone(sinOfConeRadius, coneCenterLonRad, coneCenterLatRad, cosConeCenterLat, sinConeCenterLat, lonLatN[0], lonLatN[1], lonLatE[0], lonLatE[1], true, angDistComputer);
            latRad = NewtonMethod.newtonSolveNorthPolarCapZone(latRad, true, coneCenterLonModHalfPi - 1.5707963267948966, coneCenterLatRad, cosConeCenterLat, squareOfsinOfHalfR, false, relativePrecision, nIterMax, angDistComputer);
            zDxDyEq1 = Math.sin(latRad);
            deltaLon = angDistComputer.coneDeltaLon(squareOfsinOfHalfR, cosConeCenterLat, coneCenterLatRad - latRad, zDxDyEq1);
            result[resultSize++] = Math.isFinite(deltaLon) ? hashComputer.hash(coneCenterLonRad + deltaLon, latRad) : -1L;
        }
        latRad = this.latOfParallelLineTangentToCone(sinOfConeRadius, coneCenterLonRad, coneCenterLatRad, cosConeCenterLat, sinConeCenterLat, lonLatW[0], lonLatW[1], lonLatS[0], lonLatS[1], false, angDistComputer);
        latRad = NewtonMethod.newtonSolveNorthPolarCapZone(latRad, false, coneCenterLonModHalfPi, coneCenterLatRad, cosConeCenterLat, squareOfsinOfHalfR, true, relativePrecision, nIterMax, angDistComputer);
        zDxDyEq1 = Math.sin(latRad);
        deltaLon = angDistComputer.coneDeltaLon(squareOfsinOfHalfR, cosConeCenterLat, coneCenterLatRad - latRad, zDxDyEq1);
        if (Math.isFinite(deltaLon) && coneCenterLonModHalfPi - deltaLon >= 0.0) {
            result[resultSize++] = hashComputer.hash(coneCenterLonRad - deltaLon, latRad);
        } else {
            lonLatN = vertices.get((Object)CompassPoint.Cardinal.S);
            latRad = this.latOfParallelLineTangentToCone(sinOfConeRadius, coneCenterLonRad, coneCenterLatRad, cosConeCenterLat, sinConeCenterLat, lonLatN[0], lonLatN[1], lonLatW[0], lonLatW[1], true, angDistComputer);
            latRad = NewtonMethod.newtonSolveNorthPolarCapZone(latRad, false, 1.5707963267948966 + coneCenterLonModHalfPi, coneCenterLatRad, cosConeCenterLat, squareOfsinOfHalfR, true, relativePrecision, nIterMax, angDistComputer);
            zDxDyEq1 = Math.sin(latRad);
            deltaLon = angDistComputer.coneDeltaLon(squareOfsinOfHalfR, cosConeCenterLat, coneCenterLatRad - latRad, zDxDyEq1);
            result[resultSize++] = Math.isFinite(deltaLon) ? hashComputer.hash(coneCenterLonRad - deltaLon, latRad) : -1L;
        }
        return resultSize;
    }

    private final int edgesSEWinSPC(double coneCenterLonRad, double coneCenterLatRad, double coneRadiusRad, HashComputer hashComputer, AngularDistanceComputer angDistComputer, double relativePrecision, int nIterMax, double cosConeCenterLat, double sinConeCenterLat, double twoSineOfHalfConeRadius, double squareOfsinOfHalfR, double sinOfConeRadius, EnumMap<CompassPoint.Cardinal, double[]> vertices, long[] result, int resultSize) {
        boolean containsSouthPole;
        double[] lonLatS = vertices.get((Object)CompassPoint.Cardinal.S);
        double[] lonLatE = vertices.get((Object)CompassPoint.Cardinal.E);
        double[] lonLatW = vertices.get((Object)CompassPoint.Cardinal.W);
        double coneCenterLonModHalfPi = coneCenterLonRad % 1.5707963267948966;
        boolean bl = containsSouthPole = coneRadiusRad - cosConeCenterLat > 1.5707963267948966;
        if (containsSouthPole) {
            double dCS = 1.5707963267948966 + coneCenterLatRad;
            double d1 = coneRadiusRad + dCS;
            double d2 = coneRadiusRad - dCS;
            double cosL = java.lang.Math.cos(coneCenterLonModHalfPi);
            double sinL = java.lang.Math.sin(coneCenterLonModHalfPi);
            double latStart = 0.5 * (d1 * cosL + d2 * sinL);
            double latRad = -NewtonMethod.newtonSolveNorthPolarCapZone(latStart, true, coneCenterLonModHalfPi - 1.5707963267948966, -coneCenterLatRad, cosConeCenterLat, squareOfsinOfHalfR, false, relativePrecision, nIterMax, angDistComputer);
            double zDxDyEq1 = Math.sin(latRad);
            double deltaLon = angDistComputer.coneDeltaLon(squareOfsinOfHalfR, cosConeCenterLat, coneCenterLatRad - latRad, zDxDyEq1);
            result[resultSize++] = Math.isFinite(deltaLon) ? hashComputer.hash(coneCenterLonRad + deltaLon, latRad) : -1L;
            latStart = 0.5 * (d2 * cosL + d1 * sinL);
            latRad = -NewtonMethod.newtonSolveNorthPolarCapZone(latStart, false, 1.5707963267948966 + coneCenterLonModHalfPi, -coneCenterLatRad, cosConeCenterLat, squareOfsinOfHalfR, true, relativePrecision, nIterMax, angDistComputer);
            zDxDyEq1 = Math.sin(latRad);
            deltaLon = angDistComputer.coneDeltaLon(squareOfsinOfHalfR, cosConeCenterLat, coneCenterLatRad - latRad, zDxDyEq1);
            result[resultSize++] = Math.isFinite(deltaLon) ? hashComputer.hash(coneCenterLonRad - deltaLon, latRad) : -1L;
        } else {
            double zDxDyEq1;
            double latRad = this.latOfParallelLineTangentToCone(sinOfConeRadius, coneCenterLonRad, coneCenterLatRad, cosConeCenterLat, sinConeCenterLat, lonLatS[0], lonLatS[1], lonLatE[0], lonLatE[1], false, angDistComputer);
            double deltaLon = angDistComputer.coneDeltaLon(squareOfsinOfHalfR, cosConeCenterLat, coneCenterLatRad - (latRad = -NewtonMethod.newtonSolveNorthPolarCapZone(-latRad, true, coneCenterLonModHalfPi, -coneCenterLatRad, cosConeCenterLat, squareOfsinOfHalfR, true, relativePrecision, nIterMax, angDistComputer)), zDxDyEq1 = Math.sin(latRad));
            if (Math.isFinite(deltaLon) && coneCenterLonModHalfPi + deltaLon <= 1.5707963267948966) {
                result[resultSize++] = hashComputer.hash(coneCenterLonRad + deltaLon, latRad);
            } else {
                latRad = this.latOfParallelLineTangentToCone(sinOfConeRadius, coneCenterLonRad, coneCenterLatRad, cosConeCenterLat, sinConeCenterLat, lonLatS[0], lonLatS[1], 2.0 * lonLatS[0] - lonLatW[0], lonLatW[1], false, angDistComputer);
                deltaLon = angDistComputer.coneDeltaLon(squareOfsinOfHalfR, cosConeCenterLat, coneCenterLatRad - (latRad = -NewtonMethod.newtonSolveNorthPolarCapZone(-latRad, true, coneCenterLonModHalfPi - 1.5707963267948966, -coneCenterLatRad, cosConeCenterLat, squareOfsinOfHalfR, true, relativePrecision, nIterMax, angDistComputer)), zDxDyEq1 = Math.sin(latRad));
                if (Math.isFinite(deltaLon)) {
                    result[resultSize++] = hashComputer.hash(coneCenterLonRad + deltaLon, latRad);
                } else {
                    latRad = this.latOfParallelLineTangentToCone(sinOfConeRadius, coneCenterLonRad, coneCenterLatRad, cosConeCenterLat, sinConeCenterLat, lonLatS[0], lonLatS[1], lonLatE[0], lonLatE[1], true, angDistComputer);
                    latRad = -NewtonMethod.newtonSolveNorthPolarCapZone(-latRad, true, coneCenterLonModHalfPi - 1.5707963267948966, -coneCenterLatRad, cosConeCenterLat, squareOfsinOfHalfR, false, relativePrecision, nIterMax, angDistComputer);
                    zDxDyEq1 = Math.sin(latRad);
                    deltaLon = angDistComputer.coneDeltaLon(squareOfsinOfHalfR, cosConeCenterLat, coneCenterLatRad - latRad, zDxDyEq1);
                    result[resultSize++] = Math.isFinite(deltaLon) ? hashComputer.hash(coneCenterLonRad + deltaLon, latRad) : -1L;
                }
            }
            latRad = this.latOfParallelLineTangentToCone(sinOfConeRadius, coneCenterLonRad, coneCenterLatRad, cosConeCenterLat, sinConeCenterLat, lonLatW[0], lonLatW[1], lonLatS[0], lonLatS[1], false, angDistComputer);
            latRad = -NewtonMethod.newtonSolveNorthPolarCapZone(-latRad, false, coneCenterLonModHalfPi, -coneCenterLatRad, cosConeCenterLat, squareOfsinOfHalfR, false, relativePrecision, nIterMax, angDistComputer);
            zDxDyEq1 = Math.sin(latRad);
            deltaLon = angDistComputer.coneDeltaLon(squareOfsinOfHalfR, cosConeCenterLat, latRad - coneCenterLatRad, zDxDyEq1);
            if (Math.isFinite(deltaLon) && coneCenterLonModHalfPi - deltaLon >= 0.0) {
                result[resultSize++] = hashComputer.hash(coneCenterLonRad - deltaLon, latRad);
            } else {
                latRad = this.latOfParallelLineTangentToCone(sinOfConeRadius, coneCenterLonRad, coneCenterLatRad, cosConeCenterLat, sinConeCenterLat, 2.0 * lonLatS[0] - lonLatE[0], lonLatE[1], lonLatS[0], lonLatS[1], false, angDistComputer);
                deltaLon = angDistComputer.coneDeltaLon(squareOfsinOfHalfR, cosConeCenterLat, (latRad = -NewtonMethod.newtonSolveNorthPolarCapZone(-latRad, false, 1.5707963267948966 + coneCenterLonModHalfPi, -coneCenterLatRad, cosConeCenterLat, squareOfsinOfHalfR, true, relativePrecision, nIterMax, angDistComputer)) - coneCenterLatRad, zDxDyEq1 = Math.sin(latRad));
                if (Math.isFinite(deltaLon)) {
                    result[resultSize++] = hashComputer.hash(coneCenterLonRad - deltaLon, latRad);
                } else {
                    latRad = this.latOfParallelLineTangentToCone(sinOfConeRadius, coneCenterLonRad, coneCenterLatRad, cosConeCenterLat, sinConeCenterLat, lonLatW[0], lonLatW[1], lonLatS[0], lonLatS[1], true, angDistComputer);
                    latRad = -NewtonMethod.newtonSolveNorthPolarCapZone(-latRad, false, 1.5707963267948966 + coneCenterLonModHalfPi, -coneCenterLatRad, cosConeCenterLat, squareOfsinOfHalfR, true, relativePrecision, nIterMax, angDistComputer);
                    zDxDyEq1 = Math.sin(latRad);
                    deltaLon = angDistComputer.coneDeltaLon(squareOfsinOfHalfR, cosConeCenterLat, coneCenterLatRad - latRad, zDxDyEq1);
                    result[resultSize++] = Math.isFinite(deltaLon) ? hashComputer.hash(coneCenterLonRad - deltaLon, latRad) : -1L;
                }
            }
        }
        return resultSize;
    }

    private final int edgesNEWinSPC(double coneCenterLonRad, double coneCenterLatRad, double coneRadiusRad, HashComputer hashComputer, AngularDistanceComputer angDistComputer, double relativePrecision, int nIterMax, double cosConeCenterLat, double sinConeCenterLat, double twoSineOfHalfConeRadius, double squareOfsinOfHalfR, double sinOfConeRadius, EnumMap<CompassPoint.Cardinal, double[]> vertices, long[] result, int resultSize) {
        double[] lonLatS;
        double zDxDyEq1;
        double coneCenterLonModHalfPi = coneCenterLonRad % 1.5707963267948966;
        double[] lonLatN = vertices.get((Object)CompassPoint.Cardinal.N);
        double[] lonLatE = vertices.get((Object)CompassPoint.Cardinal.E);
        double[] lonLatW = vertices.get((Object)CompassPoint.Cardinal.W);
        double latRad = this.latOfParallelLineTangentToCone(sinOfConeRadius, coneCenterLonRad, coneCenterLatRad, cosConeCenterLat, sinConeCenterLat, lonLatN[0], lonLatN[1], lonLatE[0], lonLatE[1], true, angDistComputer);
        double deltaLon = angDistComputer.coneDeltaLon(squareOfsinOfHalfR, cosConeCenterLat, coneCenterLatRad - (latRad = -NewtonMethod.newtonSolveNorthPolarCapZone(-latRad, true, coneCenterLonModHalfPi, -coneCenterLatRad, cosConeCenterLat, squareOfsinOfHalfR, false, relativePrecision, nIterMax, angDistComputer)), zDxDyEq1 = Math.sin(latRad));
        if (Math.isFinite(deltaLon) && coneCenterLonModHalfPi + deltaLon <= 1.5707963267948966) {
            result[resultSize++] = hashComputer.hash(coneCenterLonRad + deltaLon, latRad);
        } else {
            lonLatS = vertices.get((Object)CompassPoint.Cardinal.S);
            latRad = this.latOfParallelLineTangentToCone(sinOfConeRadius, coneCenterLonRad, coneCenterLatRad, cosConeCenterLat, sinConeCenterLat, lonLatS[0], lonLatS[1], lonLatE[0], lonLatE[1], false, angDistComputer);
            latRad = -NewtonMethod.newtonSolveNorthPolarCapZone(-latRad, true, coneCenterLonModHalfPi - 1.5707963267948966, -coneCenterLatRad, cosConeCenterLat, squareOfsinOfHalfR, false, relativePrecision, nIterMax, angDistComputer);
            zDxDyEq1 = Math.sin(latRad);
            deltaLon = angDistComputer.coneDeltaLon(squareOfsinOfHalfR, cosConeCenterLat, coneCenterLatRad - latRad, zDxDyEq1);
            result[resultSize++] = Math.isFinite(deltaLon) ? hashComputer.hash(coneCenterLonRad + deltaLon, latRad) : -1L;
        }
        latRad = this.latOfParallelLineTangentToCone(sinOfConeRadius, coneCenterLonRad, coneCenterLatRad, cosConeCenterLat, sinConeCenterLat, lonLatW[0], lonLatW[1], lonLatN[0], lonLatN[1], true, angDistComputer);
        latRad = -NewtonMethod.newtonSolveNorthPolarCapZone(-latRad, false, coneCenterLonModHalfPi, -coneCenterLatRad, cosConeCenterLat, squareOfsinOfHalfR, true, relativePrecision, nIterMax, angDistComputer);
        zDxDyEq1 = Math.sin(latRad);
        deltaLon = angDistComputer.coneDeltaLon(squareOfsinOfHalfR, cosConeCenterLat, coneCenterLatRad - latRad, zDxDyEq1);
        if (Math.isFinite(deltaLon) && coneCenterLonModHalfPi - deltaLon >= 0.0) {
            result[resultSize++] = hashComputer.hash(coneCenterLonRad - deltaLon, latRad);
        } else {
            lonLatS = vertices.get((Object)CompassPoint.Cardinal.S);
            latRad = this.latOfParallelLineTangentToCone(sinOfConeRadius, coneCenterLonRad, coneCenterLatRad, cosConeCenterLat, sinConeCenterLat, lonLatS[0], lonLatS[1], lonLatW[0], lonLatW[1], false, angDistComputer);
            latRad = -NewtonMethod.newtonSolveNorthPolarCapZone(-latRad, false, 1.5707963267948966 + coneCenterLonModHalfPi, -coneCenterLatRad, cosConeCenterLat, squareOfsinOfHalfR, true, relativePrecision, nIterMax, angDistComputer);
            zDxDyEq1 = Math.sin(latRad);
            deltaLon = angDistComputer.coneDeltaLon(squareOfsinOfHalfR, cosConeCenterLat, coneCenterLatRad - latRad, zDxDyEq1);
            result[resultSize++] = Math.isFinite(deltaLon) ? hashComputer.hash(coneCenterLonRad - deltaLon, latRad) : -1L;
        }
        return resultSize;
    }
}

