% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.robu.R
\name{predict.robu}
\alias{predict.robu}
\title{Prediction method for a robumeta object.}
\usage{
\method{predict}{robu}(object, pred.vector, level = 0.95, ...)
}
\arguments{
\item{object}{A fitted robumeta model object.}

\item{pred.vector}{A prediction vector containing the new covariate values.}

\item{level}{Confidence level.}

\item{...}{Additional arguments to predict.}
}
\value{
\code{prediction} the predicted value based on the prediction vector.

\code{se} The standard error for the  predicted mean.

\code{t} The t-statistic calculated based on the predicted mean.

\code{df} The small sample corrected degrees of freedom of the distribution of the t-statistic.

\code{lower} The lower bound of the confidence interval for the predicted mean.

\code{upper} The upper bound of the confidence interval for the predicted mean.
}
\description{
\code{predict.robu} produces the predicted mean and confidence interval of a fitted robumeta model object given a prediction vector.
}
\details{
\itemize{
   \item{\code{intercept}} {
     If an intercept is included in the robumeta model, 
     the first element should always be 1, representing the intercept, 
     followed by the covariate values in appropriate order. 
     If the robumeta model does not have an intercept, the prediction 
     vector should begin with the first covariate value.
   }
   \item{\code{variable}} {
     For continuous variables, use the variable value as the 
     corresponding element value in \code{ pred.vector}. 
     For a categorical variable the original variable value should 
     be transformed to match the coding system used in the robumeta 
     model (e.g. dummy coding, deviation coding, etc.).
   }
   \item{\code{NA}} {
     If the vector contains NAs, \code{predict.robu} will remove the 
     corresponding covariates from the original data, and refit a new 
     robumeta model. The prediction and confidence interval will be 
     estimated based on the new model. 
   }
}

\preformatted{
  robu_mod <- robu(LOR1 ~ study_design + duration + service_hrs, 
                   data = dropoutPrevention, 
                   studynum = studyID, 
                   var.eff.size = varLOR, 
                   modelweights = "HIER",
                   small = TRUE)
}

In this robumeta model, the first covariate is a categorical variable 
that contains three levels: "Matched" (33 percent, dummy code: 00), 
"Randomized"(24 percent, 01) and "non-match non-randomized"(43 percent, 
10). The corresponding prediction vector begins with 1 (intercept), 
and followed by 0, 0, the dummy code for "Matched". The last two elements
are 38 and 5, the values for duration and sevice_hrs.
 
\preformatted{                                          
  predict(object = robu_mod, pred.vector = c(1,0,0,38,5),level = 0.95)
}

If we do not know the value of duration, the prediction vector should 
be c(1,0,0,NA,5). predict.robu() will refit a new model without the 
covariate duration, and the prediction will be based on it.

\preformatted{
  predict(object = robu_mod, pred.vector = c(1,0,0,NA,5),level = 0.95)
}
}
