# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.desktopvirtualization import DesktopVirtualizationMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestDesktopVirtualizationMgmtAppAttachPackageOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(DesktopVirtualizationMgmtClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_get(self, resource_group):
        response = self.client.app_attach_package.get(
            resource_group_name=resource_group.name,
            app_attach_package_name="str",
            api_version="2024-04-03",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_create_or_update(self, resource_group):
        response = self.client.app_attach_package.create_or_update(
            resource_group_name=resource_group.name,
            app_attach_package_name="str",
            app_attach_package={
                "location": "str",
                "properties": {
                    "failHealthCheckOnStagingFailure": "str",
                    "hostPoolReferences": ["str"],
                    "image": {
                        "certificateExpiry": "2020-02-20 00:00:00",
                        "certificateName": "str",
                        "displayName": "str",
                        "imagePath": "str",
                        "isActive": bool,
                        "isPackageTimestamped": "str",
                        "isRegularRegistration": bool,
                        "lastUpdated": "2020-02-20 00:00:00",
                        "packageAlias": "str",
                        "packageApplications": [
                            {
                                "appId": "str",
                                "appUserModelID": "str",
                                "description": "str",
                                "friendlyName": "str",
                                "iconImageName": "str",
                                "rawIcon": bytes("bytes", encoding="utf-8"),
                                "rawPng": bytes("bytes", encoding="utf-8"),
                            }
                        ],
                        "packageDependencies": [{"dependencyName": "str", "minVersion": "str", "publisher": "str"}],
                        "packageFamilyName": "str",
                        "packageFullName": "str",
                        "packageName": "str",
                        "packageRelativePath": "str",
                        "version": "str",
                    },
                    "keyVaultURL": "str",
                    "provisioningState": "str",
                },
                "id": "str",
                "name": "str",
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
            },
            api_version="2024-04-03",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_delete(self, resource_group):
        response = self.client.app_attach_package.delete(
            resource_group_name=resource_group.name,
            app_attach_package_name="str",
            api_version="2024-04-03",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_update(self, resource_group):
        response = self.client.app_attach_package.update(
            resource_group_name=resource_group.name,
            app_attach_package_name="str",
            api_version="2024-04-03",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list_by_resource_group(self, resource_group):
        response = self.client.app_attach_package.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2024-04-03",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list_by_subscription(self, resource_group):
        response = self.client.app_attach_package.list_by_subscription(
            api_version="2024-04-03",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
