# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from typing import Any, Callable, Dict, IO, List, Optional, TypeVar, Union, cast, overload

from ...._lro import AnalyzeActionsLROPoller, AnalyzeActionsLROPollingMethod, AnalyzeHealthcareEntitiesLROPoller, AnalyzeHealthcareEntitiesLROPollingMethod
from azure.core.exceptions import ClientAuthenticationError, HttpResponseError, ResourceExistsError, ResourceNotFoundError, map_error
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import HttpResponse
from azure.core.polling import LROPoller, NoPolling, PollingMethod
from azure.core.polling.base_polling import LROBasePolling
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.utils import case_insensitive_dict

from .. import models as _models
from ..._serialization import Serializer
from .._vendor import MixinABC, _convert_request, _format_url_section
T = TypeVar('T')
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

_SERIALIZER = Serializer()
_SERIALIZER.client_side_validation = False

def build_analyze_request(
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop('content_type', _headers.pop('Content-Type', None))  # type: Optional[str]
    accept = _headers.pop('Accept', "application/json, text/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/analyze")

    # Construct headers
    if content_type is not None:
        _headers['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    _headers['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="POST",
        url=_url,
        headers=_headers,
        **kwargs
    )


def build_analyze_status_request(
    job_id: str,
    *,
    show_stats: Optional[bool] = None,
    top: int = 20,
    skip: int = 0,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop('Accept', "application/json, text/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/analyze/jobs/{jobId}")
    path_format_arguments = {
        "jobId": _SERIALIZER.url("job_id", job_id, 'str'),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    if show_stats is not None:
        _params['showStats'] = _SERIALIZER.query("show_stats", show_stats, 'bool')
    if top is not None:
        _params['$top'] = _SERIALIZER.query("top", top, 'int', maximum=50, minimum=1)
    if skip is not None:
        _params['$skip'] = _SERIALIZER.query("skip", skip, 'int', minimum=0)

    # Construct headers
    _headers['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=_url,
        params=_params,
        headers=_headers,
        **kwargs
    )


def build_health_status_request(
    job_id: str,
    *,
    top: int = 20,
    skip: int = 0,
    show_stats: Optional[bool] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop('Accept', "application/json, text/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/entities/health/jobs/{jobId}")
    path_format_arguments = {
        "jobId": _SERIALIZER.url("job_id", job_id, 'str'),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    if top is not None:
        _params['$top'] = _SERIALIZER.query("top", top, 'int', maximum=50, minimum=1)
    if skip is not None:
        _params['$skip'] = _SERIALIZER.query("skip", skip, 'int', minimum=0)
    if show_stats is not None:
        _params['showStats'] = _SERIALIZER.query("show_stats", show_stats, 'bool')

    # Construct headers
    _headers['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=_url,
        params=_params,
        headers=_headers,
        **kwargs
    )


def build_cancel_health_job_request(
    job_id: str,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop('Accept', "application/json, text/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/entities/health/jobs/{jobId}")
    path_format_arguments = {
        "jobId": _SERIALIZER.url("job_id", job_id, 'str'),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="DELETE",
        url=_url,
        headers=_headers,
        **kwargs
    )


def build_health_request(
    *,
    model_version: Optional[str] = None,
    string_index_type: Optional[Union[str, "_models.StringIndexType"]] = None,
    logging_opt_out: Optional[bool] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type = kwargs.pop('content_type', _headers.pop('Content-Type', None))  # type: Optional[str]
    accept = _headers.pop('Accept', "application/json, text/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/entities/health/jobs")

    # Construct parameters
    if model_version is not None:
        _params['model-version'] = _SERIALIZER.query("model_version", model_version, 'str')
    if string_index_type is not None:
        _params['stringIndexType'] = _SERIALIZER.query("string_index_type", string_index_type, 'str')
    if logging_opt_out is not None:
        _params['loggingOptOut'] = _SERIALIZER.query("logging_opt_out", logging_opt_out, 'bool')

    # Construct headers
    if content_type is not None:
        _headers['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    _headers['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="POST",
        url=_url,
        params=_params,
        headers=_headers,
        **kwargs
    )


def build_entities_recognition_general_request(
    *,
    model_version: Optional[str] = None,
    show_stats: Optional[bool] = None,
    logging_opt_out: Optional[bool] = None,
    string_index_type: Optional[Union[str, "_models.StringIndexType"]] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type = kwargs.pop('content_type', _headers.pop('Content-Type', None))  # type: Optional[str]
    accept = _headers.pop('Accept', "application/json, text/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/entities/recognition/general")

    # Construct parameters
    if model_version is not None:
        _params['model-version'] = _SERIALIZER.query("model_version", model_version, 'str')
    if show_stats is not None:
        _params['showStats'] = _SERIALIZER.query("show_stats", show_stats, 'bool')
    if logging_opt_out is not None:
        _params['loggingOptOut'] = _SERIALIZER.query("logging_opt_out", logging_opt_out, 'bool')
    if string_index_type is not None:
        _params['stringIndexType'] = _SERIALIZER.query("string_index_type", string_index_type, 'str')

    # Construct headers
    if content_type is not None:
        _headers['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    _headers['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="POST",
        url=_url,
        params=_params,
        headers=_headers,
        **kwargs
    )


def build_entities_recognition_pii_request(
    *,
    model_version: Optional[str] = None,
    show_stats: Optional[bool] = None,
    logging_opt_out: Optional[bool] = None,
    domain: Optional[str] = None,
    string_index_type: Optional[Union[str, "_models.StringIndexType"]] = None,
    pii_categories: Optional[List[Union[str, "_models.PiiCategory"]]] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type = kwargs.pop('content_type', _headers.pop('Content-Type', None))  # type: Optional[str]
    accept = _headers.pop('Accept', "application/json, text/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/entities/recognition/pii")

    # Construct parameters
    if model_version is not None:
        _params['model-version'] = _SERIALIZER.query("model_version", model_version, 'str')
    if show_stats is not None:
        _params['showStats'] = _SERIALIZER.query("show_stats", show_stats, 'bool')
    if logging_opt_out is not None:
        _params['loggingOptOut'] = _SERIALIZER.query("logging_opt_out", logging_opt_out, 'bool')
    if domain is not None:
        _params['domain'] = _SERIALIZER.query("domain", domain, 'str')
    if string_index_type is not None:
        _params['stringIndexType'] = _SERIALIZER.query("string_index_type", string_index_type, 'str')
    if pii_categories is not None:
        _params['piiCategories'] = _SERIALIZER.query("pii_categories", pii_categories, '[str]', div=',')

    # Construct headers
    if content_type is not None:
        _headers['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    _headers['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="POST",
        url=_url,
        params=_params,
        headers=_headers,
        **kwargs
    )


def build_entities_linking_request(
    *,
    model_version: Optional[str] = None,
    show_stats: Optional[bool] = None,
    logging_opt_out: Optional[bool] = None,
    string_index_type: Optional[Union[str, "_models.StringIndexType"]] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type = kwargs.pop('content_type', _headers.pop('Content-Type', None))  # type: Optional[str]
    accept = _headers.pop('Accept', "application/json, text/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/entities/linking")

    # Construct parameters
    if model_version is not None:
        _params['model-version'] = _SERIALIZER.query("model_version", model_version, 'str')
    if show_stats is not None:
        _params['showStats'] = _SERIALIZER.query("show_stats", show_stats, 'bool')
    if logging_opt_out is not None:
        _params['loggingOptOut'] = _SERIALIZER.query("logging_opt_out", logging_opt_out, 'bool')
    if string_index_type is not None:
        _params['stringIndexType'] = _SERIALIZER.query("string_index_type", string_index_type, 'str')

    # Construct headers
    if content_type is not None:
        _headers['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    _headers['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="POST",
        url=_url,
        params=_params,
        headers=_headers,
        **kwargs
    )


def build_key_phrases_request(
    *,
    model_version: Optional[str] = None,
    show_stats: Optional[bool] = None,
    logging_opt_out: Optional[bool] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type = kwargs.pop('content_type', _headers.pop('Content-Type', None))  # type: Optional[str]
    accept = _headers.pop('Accept', "application/json, text/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/keyPhrases")

    # Construct parameters
    if model_version is not None:
        _params['model-version'] = _SERIALIZER.query("model_version", model_version, 'str')
    if show_stats is not None:
        _params['showStats'] = _SERIALIZER.query("show_stats", show_stats, 'bool')
    if logging_opt_out is not None:
        _params['loggingOptOut'] = _SERIALIZER.query("logging_opt_out", logging_opt_out, 'bool')

    # Construct headers
    if content_type is not None:
        _headers['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    _headers['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="POST",
        url=_url,
        params=_params,
        headers=_headers,
        **kwargs
    )


def build_languages_request(
    *,
    model_version: Optional[str] = None,
    show_stats: Optional[bool] = None,
    logging_opt_out: Optional[bool] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type = kwargs.pop('content_type', _headers.pop('Content-Type', None))  # type: Optional[str]
    accept = _headers.pop('Accept', "application/json, text/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/languages")

    # Construct parameters
    if model_version is not None:
        _params['model-version'] = _SERIALIZER.query("model_version", model_version, 'str')
    if show_stats is not None:
        _params['showStats'] = _SERIALIZER.query("show_stats", show_stats, 'bool')
    if logging_opt_out is not None:
        _params['loggingOptOut'] = _SERIALIZER.query("logging_opt_out", logging_opt_out, 'bool')

    # Construct headers
    if content_type is not None:
        _headers['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    _headers['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="POST",
        url=_url,
        params=_params,
        headers=_headers,
        **kwargs
    )


def build_sentiment_request(
    *,
    model_version: Optional[str] = None,
    show_stats: Optional[bool] = None,
    logging_opt_out: Optional[bool] = None,
    opinion_mining: Optional[bool] = None,
    string_index_type: Optional[Union[str, "_models.StringIndexType"]] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type = kwargs.pop('content_type', _headers.pop('Content-Type', None))  # type: Optional[str]
    accept = _headers.pop('Accept', "application/json, text/json")

    # Construct URL
    _url = kwargs.pop("template_url", "/sentiment")

    # Construct parameters
    if model_version is not None:
        _params['model-version'] = _SERIALIZER.query("model_version", model_version, 'str')
    if show_stats is not None:
        _params['showStats'] = _SERIALIZER.query("show_stats", show_stats, 'bool')
    if logging_opt_out is not None:
        _params['loggingOptOut'] = _SERIALIZER.query("logging_opt_out", logging_opt_out, 'bool')
    if opinion_mining is not None:
        _params['opinionMining'] = _SERIALIZER.query("opinion_mining", opinion_mining, 'bool')
    if string_index_type is not None:
        _params['stringIndexType'] = _SERIALIZER.query("string_index_type", string_index_type, 'str')

    # Construct headers
    if content_type is not None:
        _headers['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    _headers['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="POST",
        url=_url,
        params=_params,
        headers=_headers,
        **kwargs
    )

class TextAnalyticsClientOperationsMixin(MixinABC):

    def _analyze_initial(
        self,
        body: Optional[Union[_models.AnalyzeBatchInput, IO]] = None,
        **kwargs: Any
    ) -> Optional[_models.AnalyzeJobState]:
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop('content_type', _headers.pop('Content-Type', None))  # type: Optional[str]
        cls = kwargs.pop('cls', None)  # type: ClsType[Optional[_models.AnalyzeJobState]]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IO, bytes)):
            _content = body
        else:
            if body is not None:
                _json = self._serialize.body(body, 'AnalyzeBatchInput')
            else:
                _json = None

        request = build_analyze_request(
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self._analyze_initial.metadata['url'],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = None
        response_headers = {}
        if response.status_code == 200:
            deserialized = self._deserialize('AnalyzeJobState', pipeline_response)

        if response.status_code == 202:
            response_headers['Operation-Location']=self._deserialize('str', response.headers.get('Operation-Location'))
            

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized

    _analyze_initial.metadata = {'url': "/analyze"}  # type: ignore


    @overload
    def begin_analyze(
        self,
        body: Optional[_models.AnalyzeBatchInput] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AnalyzeActionsLROPoller[_models.AnalyzeJobState]:
        """Submit analysis job.

        Submit a collection of text documents for analysis. Specify one or more unique tasks to be
        executed.

        :param body: Collection of documents to analyze and tasks to execute. Default value is None.
        :type body: ~azure.ai.textanalytics.v3_1.models.AnalyzeBatchInput
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AnalyzeActionsLROPollingMethod. Pass
         in False for this operation to not poll, or pass in your own initialized polling object for a
         personal polling strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AnalyzeActionsLROPoller that returns either AnalyzeJobState or the
         result of cls(response)
        :rtype: ~...._lro.AnalyzeActionsLROPoller[~azure.ai.textanalytics.v3_1.models.AnalyzeJobState]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def begin_analyze(
        self,
        body: Optional[IO] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AnalyzeActionsLROPoller[_models.AnalyzeJobState]:
        """Submit analysis job.

        Submit a collection of text documents for analysis. Specify one or more unique tasks to be
        executed.

        :param body: Collection of documents to analyze and tasks to execute. Default value is None.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Known values are: 'application/json', 'text/json'. Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AnalyzeActionsLROPollingMethod. Pass
         in False for this operation to not poll, or pass in your own initialized polling object for a
         personal polling strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AnalyzeActionsLROPoller that returns either AnalyzeJobState or the
         result of cls(response)
        :rtype: ~...._lro.AnalyzeActionsLROPoller[~azure.ai.textanalytics.v3_1.models.AnalyzeJobState]
        :raises ~azure.core.exceptions.HttpResponseError:
        """


    @distributed_trace
    def begin_analyze(
        self,
        body: Optional[Union[_models.AnalyzeBatchInput, IO]] = None,
        **kwargs: Any
    ) -> AnalyzeActionsLROPoller[_models.AnalyzeJobState]:
        """Submit analysis job.

        Submit a collection of text documents for analysis. Specify one or more unique tasks to be
        executed.

        :param body: Collection of documents to analyze and tasks to execute. Is either a model type or
         a IO type. Default value is None.
        :type body: ~azure.ai.textanalytics.v3_1.models.AnalyzeBatchInput or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json',
         'text/json'. Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be AnalyzeActionsLROPollingMethod. Pass
         in False for this operation to not poll, or pass in your own initialized polling object for a
         personal polling strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AnalyzeActionsLROPoller that returns either AnalyzeJobState or the
         result of cls(response)
        :rtype: ~...._lro.AnalyzeActionsLROPoller[~azure.ai.textanalytics.v3_1.models.AnalyzeJobState]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop('content_type', _headers.pop('Content-Type', None))  # type: Optional[str]
        cls = kwargs.pop('cls', None)  # type: ClsType[_models.AnalyzeJobState]
        polling = kwargs.pop('polling', True)  # type: Union[bool, PollingMethod]
        lro_delay = kwargs.pop(
            'polling_interval',
            self._config.polling_interval
        )
        cont_token = kwargs.pop('continuation_token', None)  # type: Optional[str]
        if cont_token is None:
            raw_result = self._analyze_initial(  # type: ignore
                body=body,
                content_type=content_type,
                cls=lambda x,y,z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop('error_map', None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize('AnalyzeJobState', pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized


        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }

        if polling is True:
            polling_method = cast(PollingMethod, AnalyzeActionsLROPollingMethod(
                lro_delay,
                
                path_format_arguments=path_format_arguments,
                **kwargs
        ))  # type: PollingMethod
        elif polling is False: polling_method = cast(PollingMethod, NoPolling())
        else: polling_method = polling
        if cont_token:
            return AnalyzeActionsLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output
            )
        return AnalyzeActionsLROPoller(self._client, raw_result, get_long_running_output, polling_method)

    begin_analyze.metadata = {'url': "/analyze"}  # type: ignore

    @distributed_trace
    def analyze_status(
        self,
        job_id: str,
        show_stats: Optional[bool] = None,
        top: int = 20,
        skip: int = 0,
        **kwargs: Any
    ) -> _models.AnalyzeJobState:
        """Get analysis status and results.

        Get the status of an analysis job.  A job may consist of one or more tasks.  Once all tasks are
        completed, the job will transition to the completed state and results will be available for
        each task.

        :param job_id: Job ID for Analyze. Required.
        :type job_id: str
        :param show_stats: (Optional) if set to true, response will contain request and document level
         statistics. Default value is None.
        :type show_stats: bool
        :param top: (Optional) Set the maximum number of results per task. When both $top and $skip are
         specified, $skip is applied first. Default value is 20.
        :type top: int
        :param skip: (Optional) Set the number of elements to offset in the response. When both $top
         and $skip are specified, $skip is applied first. Default value is 0.
        :type skip: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: AnalyzeJobState or the result of cls(response)
        :rtype: ~azure.ai.textanalytics.v3_1.models.AnalyzeJobState
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop('cls', None)  # type: ClsType[_models.AnalyzeJobState]

        
        request = build_analyze_status_request(
            job_id=job_id,
            show_stats=show_stats,
            top=top,
            skip=skip,
            template_url=self.analyze_status.metadata['url'],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('AnalyzeJobState', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    analyze_status.metadata = {'url': "/analyze/jobs/{jobId}"}  # type: ignore


    @distributed_trace
    def health_status(
        self,
        job_id: str,
        top: int = 20,
        skip: int = 0,
        show_stats: Optional[bool] = None,
        **kwargs: Any
    ) -> _models.HealthcareJobState:
        """Get healthcare analysis job status and results.

        Get details of the healthcare prediction job specified by the jobId.

        :param job_id: Job ID. Required.
        :type job_id: str
        :param top: (Optional) Set the maximum number of results per task. When both $top and $skip are
         specified, $skip is applied first. Default value is 20.
        :type top: int
        :param skip: (Optional) Set the number of elements to offset in the response. When both $top
         and $skip are specified, $skip is applied first. Default value is 0.
        :type skip: int
        :param show_stats: (Optional) if set to true, response will contain request and document level
         statistics. Default value is None.
        :type show_stats: bool
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: HealthcareJobState or the result of cls(response)
        :rtype: ~azure.ai.textanalytics.v3_1.models.HealthcareJobState
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop('cls', None)  # type: ClsType[_models.HealthcareJobState]

        
        request = build_health_status_request(
            job_id=job_id,
            top=top,
            skip=skip,
            show_stats=show_stats,
            template_url=self.health_status.metadata['url'],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('HealthcareJobState', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    health_status.metadata = {'url': "/entities/health/jobs/{jobId}"}  # type: ignore


    def _cancel_health_job_initial(  # pylint: disable=inconsistent-return-statements
        self,
        job_id: str,
        **kwargs: Any
    ) -> None:
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop('cls', None)  # type: ClsType[None]

        
        request = build_cancel_health_job_request(
            job_id=job_id,
            template_url=self._cancel_health_job_initial.metadata['url'],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['Operation-Location']=self._deserialize('str', response.headers.get('Operation-Location'))


        if cls:
            return cls(pipeline_response, None, response_headers)

    _cancel_health_job_initial.metadata = {'url': "/entities/health/jobs/{jobId}"}  # type: ignore


    @distributed_trace
    def begin_cancel_health_job(
        self,
        job_id: str,
        **kwargs: Any
    ) -> LROPoller[None]:
        """Cancel healthcare prediction job.

        Cancel healthcare prediction job.

        :param job_id: Job ID. Required.
        :type job_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be LROBasePolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns either None or the result of cls(response)
        :rtype: ~azure.core.polling.LROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        polling = kwargs.pop('polling', True)  # type: Union[bool, PollingMethod]
        lro_delay = kwargs.pop(
            'polling_interval',
            self._config.polling_interval
        )
        cont_token = kwargs.pop('continuation_token', None)  # type: Optional[str]
        if cont_token is None:
            raw_result = self._cancel_health_job_initial(  # type: ignore
                job_id=job_id,
                cls=lambda x,y,z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop('error_map', None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})


        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }

        if polling is True:
            polling_method = cast(PollingMethod, LROBasePolling(
                lro_delay,
                
                path_format_arguments=path_format_arguments,
                **kwargs
        ))  # type: PollingMethod
        elif polling is False: polling_method = cast(PollingMethod, NoPolling())
        else: polling_method = polling
        if cont_token:
            return LROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output
            )
        return LROPoller(self._client, raw_result, get_long_running_output, polling_method)

    begin_cancel_health_job.metadata = {'url': "/entities/health/jobs/{jobId}"}  # type: ignore

    def _health_initial(
        self,
        documents: List[_models.MultiLanguageInput],
        model_version: Optional[str] = None,
        string_index_type: Optional[Union[str, "_models.StringIndexType"]] = None,
        logging_opt_out: Optional[bool] = None,
        **kwargs: Any
    ) -> Optional[_models.HealthcareJobState]:
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop('content_type', _headers.pop('Content-Type', "application/json"))  # type: str
        cls = kwargs.pop('cls', None)  # type: ClsType[Optional[_models.HealthcareJobState]]

        _input = _models.MultiLanguageBatchInput(documents=documents)
        _json = self._serialize.body(_input, 'MultiLanguageBatchInput')

        request = build_health_request(
            model_version=model_version,
            string_index_type=string_index_type,
            logging_opt_out=logging_opt_out,
            content_type=content_type,
            json=_json,
            template_url=self._health_initial.metadata['url'],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = None
        response_headers = {}
        if response.status_code == 200:
            deserialized = self._deserialize('HealthcareJobState', pipeline_response)

        if response.status_code == 202:
            response_headers['Operation-Location']=self._deserialize('str', response.headers.get('Operation-Location'))
            

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized

    _health_initial.metadata = {'url': "/entities/health/jobs"}  # type: ignore


    @distributed_trace
    def begin_health(
        self,
        documents: List[_models.MultiLanguageInput],
        model_version: Optional[str] = None,
        string_index_type: Optional[Union[str, "_models.StringIndexType"]] = None,
        logging_opt_out: Optional[bool] = None,
        **kwargs: Any
    ) -> AnalyzeHealthcareEntitiesLROPoller[_models.HealthcareJobState]:
        """Submit healthcare analysis job.

        Start a healthcare analysis job to recognize healthcare related entities (drugs, conditions,
        symptoms, etc) and their relations.

        :param documents: The set of documents to process as part of this batch. Required.
        :type documents: list[~azure.ai.textanalytics.v3_1.models.MultiLanguageInput]
        :param model_version: (Optional) This value indicates which model will be used for scoring. If
         a model-version is not specified, the API should default to the latest, non-preview version.
         Default value is None.
        :type model_version: str
        :param string_index_type: (Optional) Specifies the method used to interpret string offsets.
         Defaults to Text Elements (Graphemes) according to Unicode v8.0.0. For additional information
         see https://aka.ms/text-analytics-offsets. Known values are: "TextElement_v8",
         "UnicodeCodePoint", and "Utf16CodeUnit". Default value is None.
        :type string_index_type: str or ~azure.ai.textanalytics.v3_1.models.StringIndexType
        :param logging_opt_out: (Optional) If set to true, you opt-out of having your text input logged
         for troubleshooting. By default, Text Analytics logs your input text for 48 hours, solely to
         allow for troubleshooting issues in providing you with the Text Analytics natural language
         processing functions. Setting this parameter to true, disables input logging and may limit our
         ability to remediate issues that occur.  Please see Cognitive Services Compliance and Privacy
         notes at https://aka.ms/cs-compliance for additional details, and Microsoft Responsible AI
         principles at https://www.microsoft.com/en-us/ai/responsible-ai. Default value is None.
        :type logging_opt_out: bool
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be
         AnalyzeHealthcareEntitiesLROPollingMethod. Pass in False for this operation to not poll, or
         pass in your own initialized polling object for a personal polling strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of AnalyzeHealthcareEntitiesLROPoller that returns either
         HealthcareJobState or the result of cls(response)
        :rtype:
         ~...._lro.AnalyzeHealthcareEntitiesLROPoller[~azure.ai.textanalytics.v3_1.models.HealthcareJobState]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop('content_type', _headers.pop('Content-Type', "application/json"))  # type: str
        cls = kwargs.pop('cls', None)  # type: ClsType[_models.HealthcareJobState]
        polling = kwargs.pop('polling', True)  # type: Union[bool, PollingMethod]
        lro_delay = kwargs.pop(
            'polling_interval',
            self._config.polling_interval
        )
        cont_token = kwargs.pop('continuation_token', None)  # type: Optional[str]
        if cont_token is None:
            raw_result = self._health_initial(  # type: ignore
                documents=documents,
                model_version=model_version,
                string_index_type=string_index_type,
                logging_opt_out=logging_opt_out,
                content_type=content_type,
                cls=lambda x,y,z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
        kwargs.pop('error_map', None)

        def get_long_running_output(pipeline_response):
            deserialized = self._deserialize('HealthcareJobState', pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized


        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }

        if polling is True:
            polling_method = cast(PollingMethod, AnalyzeHealthcareEntitiesLROPollingMethod(
                lro_delay,
                
                path_format_arguments=path_format_arguments,
                **kwargs
        ))  # type: PollingMethod
        elif polling is False: polling_method = cast(PollingMethod, NoPolling())
        else: polling_method = polling
        if cont_token:
            return AnalyzeHealthcareEntitiesLROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output
            )
        return AnalyzeHealthcareEntitiesLROPoller(self._client, raw_result, get_long_running_output, polling_method)

    begin_health.metadata = {'url': "/entities/health/jobs"}  # type: ignore

    @distributed_trace
    def entities_recognition_general(
        self,
        documents: List[_models.MultiLanguageInput],
        model_version: Optional[str] = None,
        show_stats: Optional[bool] = None,
        logging_opt_out: Optional[bool] = None,
        string_index_type: Optional[Union[str, "_models.StringIndexType"]] = None,
        **kwargs: Any
    ) -> _models.EntitiesResult:
        """Named Entity Recognition.

        The API returns a list of general named entities in a given document. For the list of supported
        entity types, check :code:`<a href="https://aka.ms/taner">Supported Entity Types in Text
        Analytics API</a>`. See the :code:`<a href="https://aka.ms/talangs">Supported languages in Text
        Analytics API</a>` for the list of enabled languages.

        :param documents: The set of documents to process as part of this batch. Required.
        :type documents: list[~azure.ai.textanalytics.v3_1.models.MultiLanguageInput]
        :param model_version: (Optional) This value indicates which model will be used for scoring. If
         a model-version is not specified, the API should default to the latest, non-preview version.
         Default value is None.
        :type model_version: str
        :param show_stats: (Optional) if set to true, response will contain request and document level
         statistics. Default value is None.
        :type show_stats: bool
        :param logging_opt_out: (Optional) If set to true, you opt-out of having your text input logged
         for troubleshooting. By default, Text Analytics logs your input text for 48 hours, solely to
         allow for troubleshooting issues in providing you with the Text Analytics natural language
         processing functions. Setting this parameter to true, disables input logging and may limit our
         ability to remediate issues that occur.  Please see Cognitive Services Compliance and Privacy
         notes at https://aka.ms/cs-compliance for additional details, and Microsoft Responsible AI
         principles at https://www.microsoft.com/en-us/ai/responsible-ai. Default value is None.
        :type logging_opt_out: bool
        :param string_index_type: (Optional) Specifies the method used to interpret string offsets.
         Defaults to Text Elements (Graphemes) according to Unicode v8.0.0. For additional information
         see https://aka.ms/text-analytics-offsets. Known values are: "TextElement_v8",
         "UnicodeCodePoint", and "Utf16CodeUnit". Default value is None.
        :type string_index_type: str or ~azure.ai.textanalytics.v3_1.models.StringIndexType
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: EntitiesResult or the result of cls(response)
        :rtype: ~azure.ai.textanalytics.v3_1.models.EntitiesResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop('content_type', _headers.pop('Content-Type', "application/json"))  # type: str
        cls = kwargs.pop('cls', None)  # type: ClsType[_models.EntitiesResult]

        _input = _models.MultiLanguageBatchInput(documents=documents)
        _json = self._serialize.body(_input, 'MultiLanguageBatchInput')

        request = build_entities_recognition_general_request(
            model_version=model_version,
            show_stats=show_stats,
            logging_opt_out=logging_opt_out,
            string_index_type=string_index_type,
            content_type=content_type,
            json=_json,
            template_url=self.entities_recognition_general.metadata['url'],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('EntitiesResult', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    entities_recognition_general.metadata = {'url': "/entities/recognition/general"}  # type: ignore


    @distributed_trace
    def entities_recognition_pii(
        self,
        documents: List[_models.MultiLanguageInput],
        model_version: Optional[str] = None,
        show_stats: Optional[bool] = None,
        logging_opt_out: Optional[bool] = None,
        domain: Optional[str] = None,
        string_index_type: Optional[Union[str, "_models.StringIndexType"]] = None,
        pii_categories: Optional[List[Union[str, "_models.PiiCategory"]]] = None,
        **kwargs: Any
    ) -> _models.PiiResult:
        """Entities containing personal information.

        The API returns a list of entities with personal information (\"SSN\", \"Bank Account\" etc) in
        the document. For the list of supported entity types, check :code:`<a
        href="https://aka.ms/tanerpii">Supported Entity Types in Text Analytics API</a>`. See the
        :code:`<a href="https://aka.ms/talangs">Supported languages in Text Analytics API</a>` for the
        list of enabled languages.

        :param documents: The set of documents to process as part of this batch. Required.
        :type documents: list[~azure.ai.textanalytics.v3_1.models.MultiLanguageInput]
        :param model_version: (Optional) This value indicates which model will be used for scoring. If
         a model-version is not specified, the API should default to the latest, non-preview version.
         Default value is None.
        :type model_version: str
        :param show_stats: (Optional) if set to true, response will contain request and document level
         statistics. Default value is None.
        :type show_stats: bool
        :param logging_opt_out: (Optional) If set to true, you opt-out of having your text input logged
         for troubleshooting. By default, Text Analytics logs your input text for 48 hours, solely to
         allow for troubleshooting issues in providing you with the Text Analytics natural language
         processing functions. Setting this parameter to true, disables input logging and may limit our
         ability to remediate issues that occur.  Please see Cognitive Services Compliance and Privacy
         notes at https://aka.ms/cs-compliance for additional details, and Microsoft Responsible AI
         principles at https://www.microsoft.com/en-us/ai/responsible-ai. Default value is None.
        :type logging_opt_out: bool
        :param domain: (Optional) if specified, will set the PII domain to include only a subset of the
         entity categories. Possible values include: 'PHI', 'none'. Default value is None.
        :type domain: str
        :param string_index_type: (Optional) Specifies the method used to interpret string offsets.
         Defaults to Text Elements (Graphemes) according to Unicode v8.0.0. For additional information
         see https://aka.ms/text-analytics-offsets. Known values are: "TextElement_v8",
         "UnicodeCodePoint", and "Utf16CodeUnit". Default value is None.
        :type string_index_type: str or ~azure.ai.textanalytics.v3_1.models.StringIndexType
        :param pii_categories: (Optional) describes the PII categories to return. Default value is
         None.
        :type pii_categories: list[str or ~azure.ai.textanalytics.v3_1.models.PiiCategory]
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: PiiResult or the result of cls(response)
        :rtype: ~azure.ai.textanalytics.v3_1.models.PiiResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop('content_type', _headers.pop('Content-Type', "application/json"))  # type: str
        cls = kwargs.pop('cls', None)  # type: ClsType[_models.PiiResult]

        _input = _models.MultiLanguageBatchInput(documents=documents)
        _json = self._serialize.body(_input, 'MultiLanguageBatchInput')

        request = build_entities_recognition_pii_request(
            model_version=model_version,
            show_stats=show_stats,
            logging_opt_out=logging_opt_out,
            domain=domain,
            string_index_type=string_index_type,
            pii_categories=pii_categories,
            content_type=content_type,
            json=_json,
            template_url=self.entities_recognition_pii.metadata['url'],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('PiiResult', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    entities_recognition_pii.metadata = {'url': "/entities/recognition/pii"}  # type: ignore


    @distributed_trace
    def entities_linking(
        self,
        documents: List[_models.MultiLanguageInput],
        model_version: Optional[str] = None,
        show_stats: Optional[bool] = None,
        logging_opt_out: Optional[bool] = None,
        string_index_type: Optional[Union[str, "_models.StringIndexType"]] = None,
        **kwargs: Any
    ) -> _models.EntityLinkingResult:
        """Linked entities from a well known knowledge base.

        The API returns a list of recognized entities with links to a well known knowledge base. See
        the :code:`<a href="https://aka.ms/talangs">Supported languages in Text Analytics API</a>` for
        the list of enabled languages.

        :param documents: The set of documents to process as part of this batch. Required.
        :type documents: list[~azure.ai.textanalytics.v3_1.models.MultiLanguageInput]
        :param model_version: (Optional) This value indicates which model will be used for scoring. If
         a model-version is not specified, the API should default to the latest, non-preview version.
         Default value is None.
        :type model_version: str
        :param show_stats: (Optional) if set to true, response will contain request and document level
         statistics. Default value is None.
        :type show_stats: bool
        :param logging_opt_out: (Optional) If set to true, you opt-out of having your text input logged
         for troubleshooting. By default, Text Analytics logs your input text for 48 hours, solely to
         allow for troubleshooting issues in providing you with the Text Analytics natural language
         processing functions. Setting this parameter to true, disables input logging and may limit our
         ability to remediate issues that occur.  Please see Cognitive Services Compliance and Privacy
         notes at https://aka.ms/cs-compliance for additional details, and Microsoft Responsible AI
         principles at https://www.microsoft.com/en-us/ai/responsible-ai. Default value is None.
        :type logging_opt_out: bool
        :param string_index_type: (Optional) Specifies the method used to interpret string offsets.
         Defaults to Text Elements (Graphemes) according to Unicode v8.0.0. For additional information
         see https://aka.ms/text-analytics-offsets. Known values are: "TextElement_v8",
         "UnicodeCodePoint", and "Utf16CodeUnit". Default value is None.
        :type string_index_type: str or ~azure.ai.textanalytics.v3_1.models.StringIndexType
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: EntityLinkingResult or the result of cls(response)
        :rtype: ~azure.ai.textanalytics.v3_1.models.EntityLinkingResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop('content_type', _headers.pop('Content-Type', "application/json"))  # type: str
        cls = kwargs.pop('cls', None)  # type: ClsType[_models.EntityLinkingResult]

        _input = _models.MultiLanguageBatchInput(documents=documents)
        _json = self._serialize.body(_input, 'MultiLanguageBatchInput')

        request = build_entities_linking_request(
            model_version=model_version,
            show_stats=show_stats,
            logging_opt_out=logging_opt_out,
            string_index_type=string_index_type,
            content_type=content_type,
            json=_json,
            template_url=self.entities_linking.metadata['url'],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('EntityLinkingResult', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    entities_linking.metadata = {'url': "/entities/linking"}  # type: ignore


    @distributed_trace
    def key_phrases(
        self,
        documents: List[_models.MultiLanguageInput],
        model_version: Optional[str] = None,
        show_stats: Optional[bool] = None,
        logging_opt_out: Optional[bool] = None,
        **kwargs: Any
    ) -> _models.KeyPhraseResult:
        """Key Phrases.

        The API returns a list of strings denoting the key phrases in the input text. See the :code:`<a
        href="https://aka.ms/talangs">Supported languages in Text Analytics API</a>` for the list of
        enabled languages.

        :param documents: The set of documents to process as part of this batch. Required.
        :type documents: list[~azure.ai.textanalytics.v3_1.models.MultiLanguageInput]
        :param model_version: (Optional) This value indicates which model will be used for scoring. If
         a model-version is not specified, the API should default to the latest, non-preview version.
         Default value is None.
        :type model_version: str
        :param show_stats: (Optional) if set to true, response will contain request and document level
         statistics. Default value is None.
        :type show_stats: bool
        :param logging_opt_out: (Optional) If set to true, you opt-out of having your text input logged
         for troubleshooting. By default, Text Analytics logs your input text for 48 hours, solely to
         allow for troubleshooting issues in providing you with the Text Analytics natural language
         processing functions. Setting this parameter to true, disables input logging and may limit our
         ability to remediate issues that occur.  Please see Cognitive Services Compliance and Privacy
         notes at https://aka.ms/cs-compliance for additional details, and Microsoft Responsible AI
         principles at https://www.microsoft.com/en-us/ai/responsible-ai. Default value is None.
        :type logging_opt_out: bool
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyPhraseResult or the result of cls(response)
        :rtype: ~azure.ai.textanalytics.v3_1.models.KeyPhraseResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop('content_type', _headers.pop('Content-Type', "application/json"))  # type: str
        cls = kwargs.pop('cls', None)  # type: ClsType[_models.KeyPhraseResult]

        _input = _models.MultiLanguageBatchInput(documents=documents)
        _json = self._serialize.body(_input, 'MultiLanguageBatchInput')

        request = build_key_phrases_request(
            model_version=model_version,
            show_stats=show_stats,
            logging_opt_out=logging_opt_out,
            content_type=content_type,
            json=_json,
            template_url=self.key_phrases.metadata['url'],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('KeyPhraseResult', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    key_phrases.metadata = {'url': "/keyPhrases"}  # type: ignore


    @distributed_trace
    def languages(
        self,
        documents: List[_models.LanguageInput],
        model_version: Optional[str] = None,
        show_stats: Optional[bool] = None,
        logging_opt_out: Optional[bool] = None,
        **kwargs: Any
    ) -> _models.LanguageResult:
        """Detect Language.

        The API returns the detected language and a numeric score between 0 and 1. Scores close to 1
        indicate 100% certainty that the identified language is true. See the :code:`<a
        href="https://aka.ms/talangs">Supported languages in Text Analytics API</a>` for the list of
        enabled languages.

        :param documents: Required.
        :type documents: list[~azure.ai.textanalytics.v3_1.models.LanguageInput]
        :param model_version: (Optional) This value indicates which model will be used for scoring. If
         a model-version is not specified, the API should default to the latest, non-preview version.
         Default value is None.
        :type model_version: str
        :param show_stats: (Optional) if set to true, response will contain request and document level
         statistics. Default value is None.
        :type show_stats: bool
        :param logging_opt_out: (Optional) If set to true, you opt-out of having your text input logged
         for troubleshooting. By default, Text Analytics logs your input text for 48 hours, solely to
         allow for troubleshooting issues in providing you with the Text Analytics natural language
         processing functions. Setting this parameter to true, disables input logging and may limit our
         ability to remediate issues that occur.  Please see Cognitive Services Compliance and Privacy
         notes at https://aka.ms/cs-compliance for additional details, and Microsoft Responsible AI
         principles at https://www.microsoft.com/en-us/ai/responsible-ai. Default value is None.
        :type logging_opt_out: bool
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: LanguageResult or the result of cls(response)
        :rtype: ~azure.ai.textanalytics.v3_1.models.LanguageResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop('content_type', _headers.pop('Content-Type', "application/json"))  # type: str
        cls = kwargs.pop('cls', None)  # type: ClsType[_models.LanguageResult]

        _input = _models.LanguageBatchInput(documents=documents)
        _json = self._serialize.body(_input, 'LanguageBatchInput')

        request = build_languages_request(
            model_version=model_version,
            show_stats=show_stats,
            logging_opt_out=logging_opt_out,
            content_type=content_type,
            json=_json,
            template_url=self.languages.metadata['url'],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('LanguageResult', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    languages.metadata = {'url': "/languages"}  # type: ignore


    @distributed_trace
    def sentiment(
        self,
        documents: List[_models.MultiLanguageInput],
        model_version: Optional[str] = None,
        show_stats: Optional[bool] = None,
        logging_opt_out: Optional[bool] = None,
        opinion_mining: Optional[bool] = None,
        string_index_type: Optional[Union[str, "_models.StringIndexType"]] = None,
        **kwargs: Any
    ) -> _models.SentimentResponse:
        """Sentiment.

        The API returns a detailed sentiment analysis for the input text. The analysis is done in
        multiple levels of granularity, start from the a document level, down to sentence and key terms
        (targets and assessments).

        :param documents: The set of documents to process as part of this batch. Required.
        :type documents: list[~azure.ai.textanalytics.v3_1.models.MultiLanguageInput]
        :param model_version: (Optional) This value indicates which model will be used for scoring. If
         a model-version is not specified, the API should default to the latest, non-preview version.
         Default value is None.
        :type model_version: str
        :param show_stats: (Optional) if set to true, response will contain request and document level
         statistics. Default value is None.
        :type show_stats: bool
        :param logging_opt_out: (Optional) If set to true, you opt-out of having your text input logged
         for troubleshooting. By default, Text Analytics logs your input text for 48 hours, solely to
         allow for troubleshooting issues in providing you with the Text Analytics natural language
         processing functions. Setting this parameter to true, disables input logging and may limit our
         ability to remediate issues that occur.  Please see Cognitive Services Compliance and Privacy
         notes at https://aka.ms/cs-compliance for additional details, and Microsoft Responsible AI
         principles at https://www.microsoft.com/en-us/ai/responsible-ai. Default value is None.
        :type logging_opt_out: bool
        :param opinion_mining: (Optional) if set to true, response will contain not only sentiment
         prediction but also opinion mining (aspect-based sentiment analysis) results. Default value is
         None.
        :type opinion_mining: bool
        :param string_index_type: (Optional) Specifies the method used to interpret string offsets.
         Defaults to Text Elements (Graphemes) according to Unicode v8.0.0. For additional information
         see https://aka.ms/text-analytics-offsets. Known values are: "TextElement_v8",
         "UnicodeCodePoint", and "Utf16CodeUnit". Default value is None.
        :type string_index_type: str or ~azure.ai.textanalytics.v3_1.models.StringIndexType
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SentimentResponse or the result of cls(response)
        :rtype: ~azure.ai.textanalytics.v3_1.models.SentimentResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop('content_type', _headers.pop('Content-Type', "application/json"))  # type: str
        cls = kwargs.pop('cls', None)  # type: ClsType[_models.SentimentResponse]

        _input = _models.MultiLanguageBatchInput(documents=documents)
        _json = self._serialize.body(_input, 'MultiLanguageBatchInput')

        request = build_sentiment_request(
            model_version=model_version,
            show_stats=show_stats,
            logging_opt_out=logging_opt_out,
            opinion_mining=opinion_mining,
            string_index_type=string_index_type,
            content_type=content_type,
            json=_json,
            template_url=self.sentiment.metadata['url'],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('SentimentResponse', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    sentiment.metadata = {'url': "/sentiment"}  # type: ignore

