/***************************************************************************
 *   Copyright (C) 2005-2008 by Eugene V. Lyubimkin aka jackyf             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License                  *
 *   (version 3 or above) as published by the Free Software Foundation.    *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU GPL                        *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA               *
 ***************************************************************************/
#ifndef yf_KEYBOARD_WIDGET_HPP_INCLUDED
#define yf_KEYBOARD_WIDGET_HPP_INCLUDED

#include <QFrame>

#include "Layout.hpp"

class QPixmap;

class KeyboardWidget: public QFrame
{
	Q_OBJECT

 public:
	KeyboardWidget(const Layout& layout, QWidget* parent = NULL);
	~KeyboardWidget();

 public slots:
	void markSymbol(QChar symbol);

 private:
	const Layout layout;

	QPixmap* keyboardImage;
	QChar symbolToMark;

	void drawLettersOnPixmap();
	void paintEvent(QPaintEvent* event);
};

#endif // yf_KEYBOARD_WIDGET_HPP_INCLUDED

