# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.abstract_array import AbstractArray


class DataArray(AbstractArray):
    r"""
    DataArray - abstract superclass for arrays of numeric data
    
    Superclass: AbstractArray
    
    DataArray is an abstract superclass for data array objects
    containing numeric data.  It extends the API defined in
    AbstractArray.  DataArray is an abstract superclass for data
    array objects. This class defines an API that all array objects must
    support. Note that the concrete subclasses of this class represent
    data in native form (char, int, etc.) and often have specialized more
    efficient methods for operating on this data (for example, getting
    pointers to data or getting/inserting data in native form). 
    Subclasses of DataArray are assumed to contain data whose
    components are meaningful when cast to and from double.
    
    @sa
    BitArray GenericDataArray
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkDataArray, obj, update, **traits)
    
    def get_component(self, *args):
        """
        get_component(self, tupleIdx:int, compIdx:int) -> float
        C++: virtual double get_component(IdType tupleIdx, int compIdx)
        Return the data component at the location specified by tupleIdx
        and compIdx.
        """
        ret = self._wrap_call(self._vtk_obj.GetComponent, *args)
        return ret

    def set_component(self, *args):
        """
        set_component(self, tupleIdx:int, compIdx:int, value:float) -> None
        C++: virtual void set_component(IdType tupleIdx, int compIdx,
            double value)
        Set the data component at the location specified by tupleIdx and
        compIdx to value. Note that i is less than number_of_tuples and j
        is less than number_of_components. Make sure enough memory has been
        allocated (use set_number_of_tuples() and set_number_of_components()).
        """
        ret = self._wrap_call(self._vtk_obj.SetComponent, *args)
        return ret

    def _get_lookup_table(self):
        return wrap_vtk(self._vtk_obj.GetLookupTable())
    def _set_lookup_table(self, arg):
        old_val = self._get_lookup_table()
        self._wrap_call(self._vtk_obj.SetLookupTable,
                        deref_vtk(arg))
        self.trait_property_changed('lookup_table', old_val, arg)
    lookup_table = traits.Property(_get_lookup_table, _set_lookup_table, desc=\
        r"""
        
        """
    )

    def get_tuple(self, *args):
        """
        get_tuple(self, tupleIdx:int) -> (float, ...)
        C++: virtual double *get_tuple(IdType tupleIdx)
        get_tuple(self, tupleIdx:int, tuple:[float, ...]) -> None
        C++: virtual void get_tuple(IdType tupleIdx, double *tuple)
        Get the data tuple at tupleIdx. Return it as a pointer to an
        array. Note: this method is not thread-safe, and the pointer is
        only valid as long as another method invocation to a vtk object
        is not performed.
        """
        ret = self._wrap_call(self._vtk_obj.GetTuple, *args)
        return ret

    def set_tuple(self, *args):
        """
        set_tuple(self, dstTupleIdx:int, srcTupleIdx:int,
            source:AbstractArray) -> None
        C++: void set_tuple(IdType dstTupleIdx, IdType srcTupleIdx,
            AbstractArray *source) override;
        set_tuple(self, tupleIdx:int, tuple:(float, ...)) -> None
        C++: virtual void set_tuple(IdType tupleIdx,
            const double *tuple)
        Set the tuple at dsttuple_idx in this array to the tuple at
        srctuple_idx in the source array. This method assumes that the two
        arrays have the same type and structure. Note that range checking
        and memory allocation is not performed; use in conjunction with
        set_number_of_tuples() to allocate space.
        """
        my_args = deref_array(args, [('int', 'int', 'vtkAbstractArray'), ('int', 'tuple')])
        ret = self._wrap_call(self._vtk_obj.SetTuple, *my_args)
        return ret

    def get_tuple1(self, *args):
        """
        get_tuple1(self, tupleIdx:int) -> float
        C++: double get_tuple1(IdType tupleIdx)
        These methods are included as convenience for the wrappers.
        get_tuple() and set_tuple() which return/take arrays can not be
        used from wrapped languages. These methods can be used instead.
        """
        ret = self._wrap_call(self._vtk_obj.GetTuple1, *args)
        return ret

    def set_tuple1(self, *args):
        """
        set_tuple1(self, tupleIdx:int, value:float) -> None
        C++: void set_tuple1(IdType tupleIdx, double value)
        These methods are included as convenience for the wrappers.
        get_tuple() and set_tuple() which return/take arrays can not be
        used from wrapped languages. These methods can be used instead.
        """
        ret = self._wrap_call(self._vtk_obj.SetTuple1, *args)
        return ret

    def get_tuple2(self, *args):
        """
        get_tuple2(self, tupleIdx:int) -> (float, float)
        C++: double *get_tuple2(IdType tupleIdx)"""
        ret = self._wrap_call(self._vtk_obj.GetTuple2, *args)
        return ret

    def set_tuple2(self, *args):
        """
        set_tuple2(self, tupleIdx:int, val0:float, val1:float) -> None
        C++: void set_tuple2(IdType tupleIdx, double val0, double val1)"""
        ret = self._wrap_call(self._vtk_obj.SetTuple2, *args)
        return ret

    def get_tuple3(self, *args):
        """
        get_tuple3(self, tupleIdx:int) -> (float, float, float)
        C++: double *get_tuple3(IdType tupleIdx)"""
        ret = self._wrap_call(self._vtk_obj.GetTuple3, *args)
        return ret

    def set_tuple3(self, *args):
        """
        set_tuple3(self, tupleIdx:int, val0:float, val1:float, val2:float)
            -> None
        C++: void set_tuple3(IdType tupleIdx, double val0, double val1,
            double val2)"""
        ret = self._wrap_call(self._vtk_obj.SetTuple3, *args)
        return ret

    def get_tuple4(self, *args):
        """
        get_tuple4(self, tupleIdx:int) -> (float, float, float, float)
        C++: double *get_tuple4(IdType tupleIdx)"""
        ret = self._wrap_call(self._vtk_obj.GetTuple4, *args)
        return ret

    def set_tuple4(self, *args):
        """
        set_tuple4(self, tupleIdx:int, val0:float, val1:float, val2:float,
            val3:float) -> None
        C++: void set_tuple4(IdType tupleIdx, double val0, double val1,
            double val2, double val3)"""
        ret = self._wrap_call(self._vtk_obj.SetTuple4, *args)
        return ret

    def get_tuple6(self, *args):
        """
        get_tuple6(self, tupleIdx:int) -> (float, float, float, float,
            float, float)
        C++: double *get_tuple6(IdType tupleIdx)"""
        ret = self._wrap_call(self._vtk_obj.GetTuple6, *args)
        return ret

    def set_tuple6(self, *args):
        """
        set_tuple6(self, tupleIdx:int, val0:float, val1:float, val2:float,
            val3:float, val4:float, val5:float) -> None
        C++: void set_tuple6(IdType tupleIdx, double val0, double val1,
            double val2, double val3, double val4, double val5)"""
        ret = self._wrap_call(self._vtk_obj.SetTuple6, *args)
        return ret

    def get_tuple9(self, *args):
        """
        get_tuple9(self, tupleIdx:int) -> (float, float, float, float,
            float, float, float, float, float)
        C++: double *get_tuple9(IdType tupleIdx)"""
        ret = self._wrap_call(self._vtk_obj.GetTuple9, *args)
        return ret

    def set_tuple9(self, *args):
        """
        set_tuple9(self, tupleIdx:int, val0:float, val1:float, val2:float,
            val3:float, val4:float, val5:float, val6:float, val7:float,
            val8:float) -> None
        C++: void set_tuple9(IdType tupleIdx, double val0, double val1,
            double val2, double val3, double val4, double val5,
            double val6, double val7, double val8)"""
        ret = self._wrap_call(self._vtk_obj.SetTuple9, *args)
        return ret

    def get_data(self, *args):
        """
        get_data(self, tupleMin:int, tupleMax:int, compMin:int,
            compMax:int, data:DoubleArray) -> None
        C++: virtual void get_data(IdType tupleMin, IdType tupleMax,
            int compMin, int compMax, DoubleArray *data)
        Get the data as a double array in the range (tupleMin,tupleMax)
        and (compMin, compMax). The resulting double array consists of
        all data in the tuple range specified and only the component
        range specified. This process typically requires casting the data
        from native form into doubleing point values. This method is
        provided as a convenience for data exchange, and is not very
        fast.
        """
        my_args = deref_array(args, [('int', 'int', 'int', 'int', 'vtkDoubleArray')])
        ret = self._wrap_call(self._vtk_obj.GetData, *my_args)
        return ret

    def _get_data_type_max(self):
        return self._vtk_obj.GetDataTypeMax()
    data_type_max = traits.Property(_get_data_type_max, desc=\
        r"""
        
        """
    )

    def get_data_type_max(self, *args):
        """
        get_data_type_max(self) -> float
        C++: double get_data_type_max()
        get_data_type_max(type:int) -> float
        C++: static double get_data_type_max(int type)"""
        ret = self._wrap_call(self._vtk_obj.GetDataTypeMax, *args)
        return ret

    def _get_data_type_min(self):
        return self._vtk_obj.GetDataTypeMin()
    data_type_min = traits.Property(_get_data_type_min, desc=\
        r"""
        
        """
    )

    def get_data_type_min(self, *args):
        """
        get_data_type_min(self) -> float
        C++: double get_data_type_min()
        get_data_type_min(type:int) -> float
        C++: static double get_data_type_min(int type)"""
        ret = self._wrap_call(self._vtk_obj.GetDataTypeMin, *args)
        return ret

    def get_data_type_range(self, *args):
        """
        get_data_type_range(self, range:[float, float]) -> None
        C++: void get_data_type_range(double range[2])
        get_data_type_range(type:int, range:[float, float]) -> None
        C++: static void get_data_type_range(int type, double range[2])
        These methods return the Min and Max possible range of the native
        data type. For example if a Scalars consists of unsigned char
        data these will return (0,255).
        """
        ret = self._wrap_call(self._vtk_obj.GetDataTypeRange, *args)
        return ret

    def _get_finite_range(self):
        return self._vtk_obj.GetFiniteRange()
    finite_range = traits.Property(_get_finite_range, desc=\
        r"""
        The range of the data array values for the given component will
        be returned in the provided range array argument. If comp is -1,
        the range of the magnitude (L2 norm) over all components will be
        provided. The range is computed and then cached, and will not be
        re-computed on subsequent calls to get_range() unless the array is
        modified or the requested component changes. THIS METHOD IS NOT
        THREAD SAFE.
        """
    )

    def get_finite_range(self, *args):
        """
        get_finite_range(self, range:[float, float], comp:int) -> None
        C++: void get_finite_range(double range[2], int comp)
        get_finite_range(self, comp:int) -> (float, float)
        C++: double *get_finite_range(int comp)
        get_finite_range(self) -> (float, float)
        C++: double *get_finite_range()
        get_finite_range(self, range:[float, float]) -> None
        C++: void get_finite_range(double range[2])
        The range of the data array values for the given component will
        be returned in the provided range array argument. If comp is -1,
        the range of the magnitude (L2 norm) over all components will be
        provided. The range is computed and then cached, and will not be
        re-computed on subsequent calls to get_range() unless the array is
        modified or the requested component changes. THIS METHOD IS NOT
        THREAD SAFE.
        """
        ret = self._wrap_call(self._vtk_obj.GetFiniteRange, *args)
        return ret

    def _get_max_norm(self):
        return self._vtk_obj.GetMaxNorm()
    max_norm = traits.Property(_get_max_norm, desc=\
        r"""
        Return the maximum norm for the tuples. Note that the max. is
        computed every time get_max_norm is called.
        """
    )

    def _get_range(self):
        return self._vtk_obj.GetRange()
    range = traits.Property(_get_range, desc=\
        r"""
        The range of the data array values for the given component will
        be returned in the provided range array argument. If comp is -1,
        the range of the magnitude (L2 norm) over all components will be
        provided. The range is computed and then cached, and will not be
        re-computed on subsequent calls to get_range() unless the array is
        modified or the requested component changes. THIS METHOD IS NOT
        THREAD SAFE.
        """
    )

    def get_range(self, *args):
        """
        get_range(self, range:[float, float], comp:int) -> None
        C++: void get_range(double range[2], int comp)
        get_range(self, comp:int) -> (float, float)
        C++: double *get_range(int comp)
        get_range(self) -> (float, float)
        C++: double *get_range()
        get_range(self, range:[float, float]) -> None
        C++: void get_range(double range[2])
        The range of the data array values for the given component will
        be returned in the provided range array argument. If comp is -1,
        the range of the magnitude (L2 norm) over all components will be
        provided. The range is computed and then cached, and will not be
        re-computed on subsequent calls to get_range() unless the array is
        modified or the requested component changes. THIS METHOD IS NOT
        THREAD SAFE.
        """
        ret = self._wrap_call(self._vtk_obj.GetRange, *args)
        return ret

    def COMPONENT_RANGE(self):
        """
        component__range() -> InformationDoubleVectorKey
        C++: static InformationDoubleVectorKey *component__range()
        This key is used to hold tight bounds on the range of one
        component over all tuples of the array. Two values (a minimum and
        maximum) are stored for each component. When get_range() is called
        when no tuples are present in the array this value is set to {
        VTK_DOUBLE_MAX, VTK_DOUBLE_MIN }.
        """
        ret = wrap_vtk(self._vtk_obj.COMPONENT_RANGE())
        return ret
        

    def copy_component(self, *args):
        """
        copy_component(self, dstComponent:int, src:DataArray,
            srcComponent:int) -> None
        C++: virtual void copy_component(int dstComponent,
            DataArray *src, int srcComponent)
        Copy a component from one data array into a component on this
        data array. This method copies the specified component
        ("srcComponent") from the specified data array ("src") to the
        specified component ("dstComponent") over all the tuples in this
        data array.  This method can be used to extract a component
        (column) from one data array and paste that data into a component
        on this data array.
        """
        my_args = deref_array(args, [('int', 'vtkDataArray', 'int')])
        ret = self._wrap_call(self._vtk_obj.CopyComponent, *my_args)
        return ret

    def create_data_array(self, *args):
        """
        create_data_array(dataType:int) -> DataArray
        C++: static DataArray *create_data_array(int dataType)
        Creates an array for dataType where dataType is one of VTK_BIT,
        VTK_CHAR, VTK_SIGNED_CHAR, VTK_UNSIGNED_CHAR, VTK_SHORT,
        VTK_UNSIGNED_SHORT, VTK_INT, VTK_UNSIGNED_INT, VTK_LONG,
        VTK_UNSIGNED_LONG, VTK_FLOAT, VTK_DOUBLE, VTK_ID_TYPE. Note that
        the data array returned has be deleted by the user.
        """
        ret = self._wrap_call(self._vtk_obj.CreateDataArray, *args)
        return wrap_vtk(ret)

    def create_default_lookup_table(self):
        """
        create_default_lookup_table(self) -> None
        C++: void create_default_lookup_table()
        Create default lookup table. Generally used to create one when
        none is available.
        """
        ret = self._vtk_obj.CreateDefaultLookupTable()
        return ret
        

    def fast_down_cast(self, *args):
        """
        fast_down_cast(source:AbstractArray) -> DataArray
        C++: static DataArray *fast_down_cast(AbstractArray *source)
        Perform a fast, safe cast from a AbstractArray to a
        DataArray. This method checks if source->get_array_type()
        returns data_array or a more derived type, and performs a
        static_cast to return source as a DataArray pointer.
        Otherwise, nullptr is returned.
        """
        my_args = deref_array(args, [['vtkAbstractArray']])
        ret = self._wrap_call(self._vtk_obj.FastDownCast, *my_args)
        return wrap_vtk(ret)

    def fill(self, *args):
        """
        fill(self, value:float) -> None
        C++: virtual void fill(double value)
        Fill all values of a data array with a specified value.
        """
        ret = self._wrap_call(self._vtk_obj.Fill, *args)
        return ret

    def fill_component(self, *args):
        """
        fill_component(self, compIdx:int, value:float) -> None
        C++: virtual void fill_component(int compIdx, double value)
        Fill a component of a data array with a specified value. This
        method sets the specified component to specified value for all
        tuples in the data array.  This methods can be used to initialize
        or reinitialize a single component of a multi-component array.
        """
        ret = self._wrap_call(self._vtk_obj.FillComponent, *args)
        return ret

    def insert_component(self, *args):
        """
        insert_component(self, tupleIdx:int, compIdx:int, value:float)
            -> None
        C++: virtual void insert_component(IdType tupleIdx, int compIdx,
             double value)
        Insert value at the location specified by tupleIdx and compIdx.
        Note that memory allocation is performed as necessary to hold the
        data.
        """
        ret = self._wrap_call(self._vtk_obj.InsertComponent, *args)
        return ret

    def insert_next_tuple1(self, *args):
        """
        insert_next_tuple1(self, value:float) -> None
        C++: void insert_next_tuple1(double value)
        These methods are included as convenience for the wrappers.
        insert_tuple() which takes arrays can not be used from wrapped
        languages. These methods can be used instead.
        """
        ret = self._wrap_call(self._vtk_obj.InsertNextTuple1, *args)
        return ret

    def insert_next_tuple2(self, *args):
        """
        insert_next_tuple2(self, val0:float, val1:float) -> None
        C++: void insert_next_tuple2(double val0, double val1)"""
        ret = self._wrap_call(self._vtk_obj.InsertNextTuple2, *args)
        return ret

    def insert_next_tuple3(self, *args):
        """
        insert_next_tuple3(self, val0:float, val1:float, val2:float) -> None
        C++: void insert_next_tuple3(double val0, double val1, double val2)"""
        ret = self._wrap_call(self._vtk_obj.InsertNextTuple3, *args)
        return ret

    def insert_next_tuple4(self, *args):
        """
        insert_next_tuple4(self, val0:float, val1:float, val2:float,
            val3:float) -> None
        C++: void insert_next_tuple4(double val0, double val1, double val2,
            double val3)"""
        ret = self._wrap_call(self._vtk_obj.InsertNextTuple4, *args)
        return ret

    def insert_next_tuple6(self, *args):
        """
        insert_next_tuple6(self, val0:float, val1:float, val2:float,
            val3:float, val4:float, val5:float) -> None
        C++: void insert_next_tuple6(double val0, double val1, double val2,
            double val3, double val4, double val5)"""
        ret = self._wrap_call(self._vtk_obj.InsertNextTuple6, *args)
        return ret

    def insert_next_tuple9(self, *args):
        """
        insert_next_tuple9(self, val0:float, val1:float, val2:float,
            val3:float, val4:float, val5:float, val6:float, val7:float,
            val8:float) -> None
        C++: void insert_next_tuple9(double val0, double val1, double val2,
            double val3, double val4, double val5, double val6,
            double val7, double val8)"""
        ret = self._wrap_call(self._vtk_obj.InsertNextTuple9, *args)
        return ret

    def insert_tuple1(self, *args):
        """
        insert_tuple1(self, tupleIdx:int, value:float) -> None
        C++: void insert_tuple1(IdType tupleIdx, double value)
        These methods are included as convenience for the wrappers.
        insert_tuple() which takes arrays can not be used from wrapped
        languages. These methods can be used instead.
        """
        ret = self._wrap_call(self._vtk_obj.InsertTuple1, *args)
        return ret

    def insert_tuple2(self, *args):
        """
        insert_tuple2(self, tupleIdx:int, val0:float, val1:float) -> None
        C++: void insert_tuple2(IdType tupleIdx, double val0,
            double val1)"""
        ret = self._wrap_call(self._vtk_obj.InsertTuple2, *args)
        return ret

    def insert_tuple3(self, *args):
        """
        insert_tuple3(self, tupleIdx:int, val0:float, val1:float,
            val2:float) -> None
        C++: void insert_tuple3(IdType tupleIdx, double val0,
            double val1, double val2)"""
        ret = self._wrap_call(self._vtk_obj.InsertTuple3, *args)
        return ret

    def insert_tuple4(self, *args):
        """
        insert_tuple4(self, tupleIdx:int, val0:float, val1:float,
            val2:float, val3:float) -> None
        C++: void insert_tuple4(IdType tupleIdx, double val0,
            double val1, double val2, double val3)"""
        ret = self._wrap_call(self._vtk_obj.InsertTuple4, *args)
        return ret

    def insert_tuple6(self, *args):
        """
        insert_tuple6(self, tupleIdx:int, val0:float, val1:float,
            val2:float, val3:float, val4:float, val5:float) -> None
        C++: void insert_tuple6(IdType tupleIdx, double val0,
            double val1, double val2, double val3, double val4,
            double val5)"""
        ret = self._wrap_call(self._vtk_obj.InsertTuple6, *args)
        return ret

    def insert_tuple9(self, *args):
        """
        insert_tuple9(self, tupleIdx:int, val0:float, val1:float,
            val2:float, val3:float, val4:float, val5:float, val6:float,
            val7:float, val8:float) -> None
        C++: void insert_tuple9(IdType tupleIdx, double val0,
            double val1, double val2, double val3, double val4,
            double val5, double val6, double val7, double val8)"""
        ret = self._wrap_call(self._vtk_obj.InsertTuple9, *args)
        return ret

    def L2_NORM_FINITE_RANGE(self):
        """
        l2__norm__finite__range() -> InformationDoubleVectorKey
        C++: static InformationDoubleVectorKey *l2__norm__finite__range()
        This key is used to hold tight bounds on the $L_2$ norm of tuples
        in the array. Two values (a minimum and maximum) are stored for
        each component. When get_finite_range() is called when no tuples
        are present in the array this value is set to { VTK_DOUBLE_MAX,
        VTK_DOUBLE_MIN }.
        """
        ret = wrap_vtk(self._vtk_obj.L2_NORM_FINITE_RANGE())
        return ret
        

    def L2_NORM_RANGE(self):
        """
        l2__norm__range() -> InformationDoubleVectorKey
        C++: static InformationDoubleVectorKey *l2__norm__range()
        This key is used to hold tight bounds on the $L_2$ norm of tuples
        in the array. Two values (a minimum and maximum) are stored for
        each component. When get_range() is called when no tuples are
        present in the array this value is set to { VTK_DOUBLE_MAX,
        VTK_DOUBLE_MIN }.
        """
        ret = wrap_vtk(self._vtk_obj.L2_NORM_RANGE())
        return ret
        

    def remove_first_tuple(self):
        """
        remove_first_tuple(self) -> None
        C++: virtual void remove_first_tuple()"""
        ret = self._vtk_obj.RemoveFirstTuple()
        return ret
        

    def remove_last_tuple(self):
        """
        remove_last_tuple(self) -> None
        C++: virtual void remove_last_tuple()"""
        ret = self._vtk_obj.RemoveLastTuple()
        return ret
        

    def remove_tuple(self, *args):
        """
        remove_tuple(self, tupleIdx:int) -> None
        C++: virtual void remove_tuple(IdType tupleIdx)
        These methods remove tuples from the data array. They shift data
        and resize array, so the data array is still valid after this
        operation. Note, this operation is fairly slow.
        """
        ret = self._wrap_call(self._vtk_obj.RemoveTuple, *args)
        return ret

    def shallow_copy(self, *args):
        """
        shallow_copy(self, other:DataArray) -> None
        C++: virtual void shallow_copy(DataArray *other)
        Create a shallow copy of other into this, if possible. Shallow
        copies are only possible: (a) if both arrays are the same data
        type (b) if both arrays are the same array type (e.g. AOS vs.
        SOA) (c) if both arrays support shallow copies (e.g. BitArray
        currently does not.) If a shallow copy is not possible, a deep
        copy will be performed instead.
        """
        my_args = deref_array(args, [['vtkDataArray']])
        ret = self._wrap_call(self._vtk_obj.ShallowCopy, *my_args)
        return ret

    def UNITS_LABEL(self):
        """
        units__label() -> InformationStringKey
        C++: static InformationStringKey *units__label()
        A human-readable string indicating the units for the array data.
        """
        ret = wrap_vtk(self._vtk_obj.UNITS_LABEL())
        return ret
        

    def write_void_pointer(self, *args):
        """
        write_void_pointer(self, valueIdx:int, numValues:int) -> Pointer
        C++: virtual void *write_void_pointer(IdType valueIdx,
            IdType numValues)
        Get the address of a particular data index. Make sure data is
        allocated for the number of items requested. If needed, increase
        max_id to mark any new value ranges as in-use.
        """
        ret = self._wrap_call(self._vtk_obj.WriteVoidPointer, *args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('max_discrete_values',
    'GetMaxDiscreteValues'), ('name', 'GetName'), ('number_of_components',
    'GetNumberOfComponents'), ('number_of_tuples', 'GetNumberOfTuples'),
    ('number_of_values', 'GetNumberOfValues'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'max_discrete_values', 'name',
    'number_of_components', 'number_of_tuples', 'number_of_values'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(DataArray, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit DataArray properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['max_discrete_values', 'name', 'number_of_components',
            'number_of_tuples', 'number_of_values']),
            title='Edit DataArray properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit DataArray properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            
    def __len__(self):
        return self._vtk_obj.GetNumberOfTuples()
    
    def __iter__(self):
        obj = self._vtk_obj
        n = obj.GetNumberOfTuples()
        nc = obj.GetNumberOfComponents()
        if nc in [1,2,3,4,9]:
            meth = getattr(obj, 'GetTuple%d'%nc)
            for i in range(n):
                yield meth(i)
        else:
            for i in range(n):
                yield tuple([obj.GetComponent(i, x) for x in range(nc)])
    
    def _check_key(self, key, n):
        if type(key) not in [int, long]:
            raise TypeError("Only integers are valid keys.")
        if key < 0:
            key =  n + key
        if key < 0 or key >= n:
            raise IndexError("Index %s out of range."%key)
        return key
    
    def __getitem__(self, key):
        obj = self._vtk_obj
        n = obj.GetNumberOfTuples()
        key = self._check_key(key, n)
        nc = obj.GetNumberOfComponents()
        if nc in [1,2,3,4,9]:
            return getattr(obj, 'GetTuple%d'%nc)(key)
        else:
            return tuple([obj.GetComponent(key, x) for x in range(nc)])
    
    def __setitem__(self, key, val):
        obj = self._vtk_obj
        n = obj.GetNumberOfTuples()
        key = self._check_key(key, n)
        nc = obj.GetNumberOfComponents()
        if nc == 1:
            obj.SetValue(key, val)
        elif nc in [2,3,4,9]:
            getattr(obj, 'SetTuple%d'%nc)(key, *val)
        else:
            assert len(val) == nc,                        'length of %s != %s.'%(val, nc)
            for x in range(nc):
                obj.SetComponent(key, x, val[x])
    
    def __repr__(self):
        obj = self._vtk_obj
        n = obj.GetNumberOfTuples()
        if n <= 10:
            return repr([x for x in self])
        else:
            first, last = self[0], self[-1]
            return '[%s, ..., %s], length = %s'%(first, last, n)
    
    def append(self, val):
        obj = self._vtk_obj
        nc = obj.GetNumberOfComponents()
        if nc == 1:
            obj.InsertNextTuple1(val)
        elif nc in [2,3,4,9]:
            meth = getattr(obj, 'InsertNextTuple%d'%nc)
            meth(*val)
        else:
            n = obj.GetNumberOfTuples()
            for x in range(nc):
                obj.InsertComponent(n, x, val[x])
        self.update_traits()
    
    def extend(self, arr):
        obj = self._vtk_obj
        nc = obj.GetNumberOfComponents()
        if nc == 1:
            for i in arr:
                obj.InsertNextTuple1(i)
        elif nc in [2,3,4,9]:
            meth = getattr(obj, 'InsertNextTuple%d'%nc)
            for i in arr:
                meth(*i)
        else:
            n = obj.GetNumberOfTuples()
            for i in range(len(arr)):
                for x in range(nc):
                    obj.InsertComponent(n+i, x, arr[i][x])
        self.update_traits()
    
    def from_array(self, arr):
        '''Set the value of the data array using the passed
        Numeric array or Python list.  This is implemented
        efficiently.
        '''
        array_handler.array2vtk(arr, self._vtk_obj)
        self.update_traits()
    
    def to_array(self):
        '''Return the object as a Numeric array.'''
        return array_handler.vtk2array(self._vtk_obj)
    

