/**
 * Copyright 2011 The Open Source Research Group,
 *                University of Erlangen-Nürnberg
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package de.fau.cs.osr.ptk.common.ast;

import static org.junit.Assert.assertEquals;

import org.junit.Test;

public class NativeAstLocationTest
{
	@Test
	public void testStringSerializationOfLocation() throws Exception
	{
		AstLocation loc = new AstLocation("tes\\t:", 42, 43);
		String expected = "tes%5Ct%3A:42:43";
		assertEquals(expected, loc.toString());
		assertEquals(loc, AstLocation.valueOf(expected));
	}
}
