/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.netbeans.modules.java.editor.codegen.ui;

import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.List;
import javax.lang.model.element.Element;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.modules.java.editor.codegen.ToStringGenerator;
import org.openide.util.NbBundle;

/**
 *
 * @author  Dusan Balek
 */
public class ToStringPanel extends JPanel {

    private final ElementSelectorPanel elementSelector;
    private final JCheckBox useStringBuilderCheckBox = new JCheckBox();

    /** Creates new form GetterSetterPanel */
    public ToStringPanel(ElementNode.Description description, boolean useStringBuilder, boolean supportsStringBuilder) {
        initComponents();
        elementSelector = new ElementSelectorPanel(description, false);
        java.awt.GridBagConstraints gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 12, 0, 12);
        add(elementSelector, gridBagConstraints);
        selectorLabel.setText(NbBundle.getMessage(ToStringGenerator.class, "LBL_tostring_select")); //NOI18N
        selectorLabel.setLabelFor(elementSelector);
        elementSelector.doInitialExpansion(1);
        useStringBuilderCheckBox.setSelected(false);
        if (supportsStringBuilder) {
            useStringBuilderCheckBox.setSelected(useStringBuilder);
            org.openide.awt.Mnemonics.setLocalizedText(useStringBuilderCheckBox, NbBundle.getMessage(ToStringGenerator.class, "LBL_tostring_use_stringbuilder")); // NOI18N
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.fill = GridBagConstraints.BOTH;
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.insets = new Insets(0, 12, 0, 12);
            gbc.anchor = GridBagConstraints.WEST;
            add(useStringBuilderCheckBox, gbc);
        }
	this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ToStringGenerator.class, "A11Y_Generate_ToString"));
    }

    public List<ElementHandle<? extends Element>> getVariables() {
        return ((ElementSelectorPanel)elementSelector).getSelectedElements();
    }

    public boolean useStringBuilder() {
        return useStringBuilderCheckBox.isSelected();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        selectorLabel = new javax.swing.JLabel();

        setLayout(new java.awt.GridBagLayout());
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(12, 12, 6, 12);
        add(selectorLabel, gridBagConstraints);
    }// </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel selectorLabel;
    // End of variables declaration//GEN-END:variables

}
