/*
 * Decompiled with CFR 0.152.
 */
package javax.naming.directory;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.Attribute;
import javax.naming.directory.BasicNamingEnumeration;
import javax.naming.directory.DirContext;
import org.apache.harmony.jndi.internal.nls.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicAttribute
implements Attribute {
    static final long serialVersionUID = 6743528196119291326L;
    protected String attrID;
    protected boolean ordered;
    protected transient Vector<Object> values = new Vector();

    public BasicAttribute(String id) {
        this(id, false);
    }

    public BasicAttribute(String id, boolean flag) {
        this.attrID = id;
        this.ordered = flag;
    }

    public BasicAttribute(String id, Object val) {
        this(id, val, false);
    }

    public BasicAttribute(String id, Object val, boolean flag) {
        this(id, flag);
        this.values.add(val);
    }

    private boolean compareValueClasses(Class<? extends Object> c1, Class<? extends Object> c2) {
        if ((c1.getName().startsWith("[L") || c1.getName().startsWith("[[")) && (c2.getName().startsWith("[L") || c2.getName().startsWith("[["))) {
            return true;
        }
        return c1.getName().equals(c2.getName());
    }

    private boolean compareValues(Object obj1, Object obj2) {
        if (obj1 == null && obj2 == null) {
            return true;
        }
        if (obj1 != null && obj2 != null) {
            if (obj1.getClass().isArray() && obj2.getClass().isArray()) {
                if (this.compareValueClasses(obj1.getClass(), obj2.getClass())) {
                    int i = Array.getLength(obj1);
                    if (Array.getLength(obj2) == i) {
                        --i;
                        while (i >= 0) {
                            Object val1 = Array.get(obj1, i);
                            Object val2 = Array.get(obj2, i);
                            if (val1 == null ? val2 != null : !val1.equals(val2)) {
                                return false;
                            }
                            --i;
                        }
                        return true;
                    }
                    return false;
                }
                return false;
            }
            return obj1.equals(obj2);
        }
        return false;
    }

    private int hashCodeOfValue(Object obj) {
        int hashcode = 0;
        if (obj != null) {
            if (obj.getClass().isArray()) {
                Object element = null;
                int i = Array.getLength(obj) - 1;
                while (i >= 0) {
                    element = Array.get(obj, i);
                    if (element != null) {
                        hashcode += element.hashCode();
                    }
                    --i;
                }
            } else {
                hashcode = obj.hashCode();
            }
        }
        return hashcode;
    }

    @Override
    public void add(int index, Object val) {
        if (this.ordered) {
            this.values.add(index, val);
        } else {
            if (this.contains(val)) {
                throw new IllegalStateException(Messages.getString("jndi.16"));
            }
            this.values.add(index, val);
        }
    }

    @Override
    public boolean add(Object val) {
        if (this.ordered) {
            return this.values.add(val);
        }
        if (this.contains(val)) {
            return false;
        }
        return this.values.add(val);
    }

    @Override
    public void clear() {
        this.values.clear();
    }

    @Override
    public Object clone() {
        try {
            BasicAttribute attr = (BasicAttribute)super.clone();
            attr.values = (Vector)this.values.clone();
            return attr;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)Messages.getString("jndi.17"));
        }
    }

    @Override
    public boolean contains(Object val) {
        Enumeration<Object> e = this.values.elements();
        while (e.hasMoreElements()) {
            if (!this.compareValues(e.nextElement(), val)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object get() throws NamingException {
        if (this.values.size() == 0) {
            throw new NoSuchElementException(Messages.getString("jndi.18"));
        }
        return this.values.get(0);
    }

    @Override
    public Object get(int index) throws NamingException {
        return this.values.get(index);
    }

    @Override
    public NamingEnumeration<?> getAll() throws NamingException {
        return new BasicNamingEnumeration<Object>(this.values.elements());
    }

    @Override
    public DirContext getAttributeDefinition() throws NamingException {
        throw new OperationNotSupportedException(Messages.getString("jndi.19"));
    }

    @Override
    public DirContext getAttributeSyntaxDefinition() throws NamingException {
        throw new OperationNotSupportedException(Messages.getString("jndi.19"));
    }

    @Override
    public String getID() {
        return this.attrID;
    }

    @Override
    public boolean isOrdered() {
        return this.ordered;
    }

    @Override
    public Object remove(int index) {
        return this.values.remove(index);
    }

    @Override
    public boolean remove(Object val) {
        int total = this.values.size();
        int i = 0;
        while (i < total) {
            if (this.compareValues(this.values.get(i), val)) {
                this.values.remove(i);
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public Object set(int index, Object val) {
        if (!this.ordered && this.contains(val)) {
            throw new IllegalStateException(Messages.getString("jndi.16"));
        }
        return this.values.set(index, val);
    }

    @Override
    public int size() {
        return this.values.size();
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        int size = ois.readInt();
        this.values = new Vector();
        int i = 0;
        while (i < size) {
            this.values.add(ois.readObject());
            ++i;
        }
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        oos.writeInt(this.values.size());
        for (Object object : this.values) {
            oos.writeObject(object);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof BasicAttribute) {
            BasicAttribute a = (BasicAttribute)obj;
            if (!this.attrID.equals(a.attrID)) {
                return false;
            }
            if (this.ordered != a.ordered) {
                return false;
            }
            if (this.values.size() != a.values.size()) {
                return false;
            }
            if (this.ordered) {
                Enumeration<Object> e1 = this.values.elements();
                Enumeration<Object> e2 = a.values.elements();
                while (e1.hasMoreElements()) {
                    if (this.compareValues(e1.nextElement(), e2.nextElement())) continue;
                    return false;
                }
                return true;
            }
            Enumeration<Object> e = this.values.elements();
            while (e.hasMoreElements()) {
                if (a.contains(e.nextElement())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int i = this.attrID.hashCode();
        Enumeration<Object> e = this.values.elements();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            if (o == null) continue;
            i += this.hashCodeOfValue(o);
        }
        return i;
    }

    public String toString() {
        Enumeration<Object> e = this.values.elements();
        String s = "Attribute ID: " + this.attrID;
        s = String.valueOf(s) + "\nAttribute values: ";
        if (!e.hasMoreElements()) {
            s = String.valueOf(s) + "This Attribute does not have any values.";
        } else {
            s = String.valueOf(s) + e.nextElement();
            while (e.hasMoreElements()) {
                s = String.valueOf(s) + "," + e.nextElement();
            }
        }
        return String.valueOf(s) + "\n";
    }
}

