# ipaserver.plugins.serverroles

## serverroles backend

The serverroles backend has access to all roles and attributes stored in
module-level lists exposed in ipaserver/servroles.py module. It uses these
lists to populate populate its internal stores with instances of the
roles/attributes. The information contained in them can be accessed by
the following methods:


* api.Backend.serverroles.server_role_search(
server_server=None, role_servrole=None status=None)

search for roles matching the given substrings and return the status of
the matched roles. Optionally filter the result by role status. If
server_server is not None, the search is limited to a single master.
Otherwise, the status is computed for all masters in the topology. If
role_servrole is None, the all configured roled are queried.


* api.Backend.serverroles.server_role_retrieve(server_server, role_servrole)

retrieve the status of a single role on a given master.


* api.Backend.serverroles.config_retrieve(role_servrole)

return a configuration object given role name. This object is a
dictionary containing a list of enabled masters and all attributes
associated with the role along with master(s) on which they are set.


* api.Backend.serverroles.config_update(\*\*attrs_values)

update configuration object. Since server roles are currently
immutable, only attributes can be set.

Note that attribute/role names are searched/matched case-insensitively. Also
note that the serverroles backend does not create/destroy any LDAP connection
by itself, so make sure ldap2 backend connections are taken care of
in the calling code.

### Classes

| `serverroles`(api_instance)

 | This Backend can be used to query various information about server roles and attributes configured in the topology.

 |
