#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# Fenrir TTY screen reader
# By Chrys, Storm Dragon, and contributors.


from fenrirscreenreader.core.i18n import _


class command:
    def __init__(self):
        pass

    def initialize(self, environment):
        self.env = environment

    def shutdown(self):
        pass

    def get_description(self):
        return "No Description found"

    def run(self):
        if not self.env["runtime"]["SettingsManager"].get_setting_as_bool(
            "speech", "autoReadIncoming"
        ):
            return
        # is there something to read?
        if not self.env["runtime"]["ScreenManager"].is_delta(ignoreSpace=True):
            return

        # this must be a keyecho or something
        # if len(self.env['screen']['new_delta'].strip(' \n\t')) <= 1:
        x_move = abs(
            self.env["screen"]["new_cursor"]["x"]
            - self.env["screen"]["old_cursor"]["x"]
        )
        y_move = abs(
            self.env["screen"]["new_cursor"]["y"]
            - self.env["screen"]["old_cursor"]["y"]
        )

        if (x_move >= 1) and x_move == len(self.env["screen"]["new_delta"]):
            # if len(self.env['screen']['new_delta'].strip(' \n\t0123456789'))
            # <= 2:
            if "\n" not in self.env["screen"]["new_delta"]:
                return
        # print(x_move, y_move, len(self.env['screen']['new_delta']), len(self.env['screen']['newNegativeDelta']))
        self.env["runtime"]["OutputManager"].present_text(
            self.env["screen"]["new_delta"], interrupt=False, flush=False
        )

    def set_callback(self, callback):
        pass
