/* SPDX-License-Identifier: GPL-2.0-only */

#include <soc/gpio.h>

#ifndef CFG_GPIO_EARLY_H
#define CFG_GPIO_EARLY_H

static const struct pad_config early_gpio_table[] = {
	/*  ------- GPIO Group South-West ------- */

	/* LPC_ILB_SERIRQ - LPC_ILB_SERIRQ */
	PAD_CFG_NF_IOSTANDBY_IGNORE(LPC_ILB_SERIRQ, UP_20K, DEEP, NF1),

	/* LPC_CLKOUT0 - LPC_CLKOUT0 */
	PAD_CFG_NF_IOSSTATE_IOSTERM(LPC_CLKOUT0, NONE, DEEP, NF1, HIZCRx1, DISPUPD),

	/* LPC_CLKOUT1 - LPC_CLKOUT1 */
	PAD_CFG_NF_IOSSTATE_IOSTERM(LPC_CLKOUT1, NONE, DEEP, NF1, HIZCRx1, DISPUPD),

	/* LPC_AD0 - LPC_AD0 */
	PAD_CFG_NF_IOSSTATE_IOSTERM(LPC_AD0, UP_20K, DEEP, NF1, HIZCRx1, DISPUPD),

	/* LPC_AD1 - LPC_AD1 */
	PAD_CFG_NF_IOSSTATE_IOSTERM(LPC_AD1, UP_20K, DEEP, NF1, HIZCRx1, DISPUPD),

	/* LPC_AD2 - LPC_AD2 */
	PAD_CFG_NF_IOSSTATE_IOSTERM(LPC_AD2, UP_20K, DEEP, NF1, HIZCRx1, DISPUPD),

	/* LPC_AD3 - LPC_AD3 */
	PAD_CFG_NF_IOSSTATE_IOSTERM(LPC_AD3, UP_20K, DEEP, NF1, HIZCRx1, DISPUPD),

	/* LPC_CLKRUNB - LPC_CLKRUNB */
	PAD_CFG_NF_IOSSTATE_IOSTERM(LPC_CLKRUNB, UP_20K, DEEP, NF1, HIZCRx1, DISPUPD),

	/* LPC_FRAMEB - LPC_FRAMEB */
	PAD_CFG_NF_IOSSTATE_IOSTERM(LPC_FRAMEB, UP_20K, DEEP, NF1, HIZCRx1, DISPUPD),

	/*  ------- GPIO Group North ------- */

	/* GPIO_38 - LPSS_UART0_RXD */
	PAD_CFG_NF_IOSSTATE_IOSTERM(GPIO_38, UP_20K, DEEP, NF1, HIZCRx1, DISPUPD),

	/* GPIO_39 - LPSS_UART0_TXD */
	PAD_CFG_NF_IOSSTATE_IOSTERM(GPIO_39, UP_20K, DEEP, NF1, TxLASTRxE, DISPUPD),

	/* GPIO_42 - LPSS_UART1_RXD */
	PAD_CFG_NF_IOSSTATE_IOSTERM(GPIO_42, UP_20K, DEEP, NF1, HIZCRx1, DISPUPD),

	/* GPIO_43 - LPSS_UART1_TXD */
	PAD_CFG_NF_IOSSTATE_IOSTERM(GPIO_43, UP_20K, DEEP, NF1, HIZCRx0, DISPUPD),
};

#endif /* CFG_GPIO_EARLY_H */
