*** Settings ***
Documentation       Network Fortinet Fortigate SNMP plugin

Resource            ${CURDIR}${/}..${/}..${/}..${/}..${/}resources/import.resource

Test Timeout        120s


*** Variables ***
${CMD}                                          ${CENTREON_PLUGINS} --plugin=network::fortinet::fortigate::snmp::plugin

*** Test Cases ***
Network Fortinet Fortigate SNMP link monitor ${tc}
    [Documentation]    Network Fortinet Fortigate SNMP link-monitor
    [Tags]    network    fortinet    fortigate    snmp
    ${command}    Catenate
    ...    ${CMD}
    ...    --mode=link-monitor
    ...    --hostname=${HOSTNAME}
    ...    --snmp-version=${SNMPVERSION}
    ...    --snmp-port=${SNMPPORT}
    ...    --snmp-community=network/fortinet/fortigate/snmp/linkmonitor
    ...    --filter-id=${filterid}
    ...    --filter-name=${filtername}
    ...    --filter-vdom=${filtervdom}
    ...    --custom-perfdata-instances=${customperfdatainstances}
    ...    --unknown-status=${unknownstatus}
    ...    --warning-status=${warningstatus}
    ...    --critical-status=${criticalstatus}
    ...    --warning-latency=${warninglatency}
    ...    --critical-latency=${criticallatency}
    ...    --warning-jitter=${warningjitter}
    ...    --critical-jitter=${criticaljitter}
    ...    --warning-packet-loss=${warningpacketloss}
    ...    --critical-packet-loss=${criticalpacketloss}
  
    Ctn Run Command And Check Result As Strings    ${command}    ${expected_result}

    Examples:         tc   filterid         filtername        filtervdom     customperfdatainstances    unknownstatus                warningstatus                criticalstatus                warninglatency    criticallatency    warningjitter    criticaljitter    warningpacketloss    criticalpacketloss    expected_result    --
            ...       1    ${EMPTY}         ${EMPTY}          ${EMPTY}       ${EMPTY}                   ${EMPTY}                     ${EMPTY}                     ${EMPTY}                      ${EMPTY}          ${EMPTY}           ${EMPTY}         ${EMPTY}          ${EMPTY}             ${EMPTY}              OK: All link monitors are ok | 'MonitorWAN1~root#linkmonitor.latency.milliseconds'=39.739;;;0; 'MonitorWAN1~root#linkmonitor.jitter.milliseconds'=0.096;;;0; 'MonitorWAN1~root#linkmonitor.packet.loss.percentage'=0;;;0; 'MonitorWAN2~root#linkmonitor.latency.milliseconds'=46.446;;;0; 'MonitorWAN2~root#linkmonitor.jitter.milliseconds'=1.868;;;0; 'MonitorWAN2~root#linkmonitor.packet.loss.percentage'=1;;;0; 'MonitorWAN3~root#linkmonitor.latency.milliseconds'=0.000;;;0; 'MonitorWAN3~root#linkmonitor.jitter.milliseconds'=0.000;;;0; 'MonitorWAN3~root#linkmonitor.packet.loss.percentage'=100;;;0; 
            ...       2    3                ${EMPTY}          ${EMPTY}       ${EMPTY}                   ${EMPTY}                     ${EMPTY}                     ${EMPTY}                      ${EMPTY}          ${EMPTY}           ${EMPTY}         ${EMPTY}          ${EMPTY}             ${EMPTY}              OK: Link monitor 'MonitorWAN3' [vdom: root] [id: 3] state: dead, latency: 0.000ms, jitter: 0.000ms, packet loss: 100.000% | 'MonitorWAN3~root#linkmonitor.latency.milliseconds'=0.000;;;0; 'MonitorWAN3~root#linkmonitor.jitter.milliseconds'=0.000;;;0; 'MonitorWAN3~root#linkmonitor.packet.loss.percentage'=100;;;0;
            ...       3    ${EMPTY}         'MonitorWAN1'     ${EMPTY}       ${EMPTY}                   ${EMPTY}                     ${EMPTY}                     ${EMPTY}                      ${EMPTY}          ${EMPTY}           ${EMPTY}         ${EMPTY}          ${EMPTY}             ${EMPTY}              OK: Link monitor 'MonitorWAN1' [vdom: root] [id: 1] state: alive, latency: 39.739ms, jitter: 0.096ms, packet loss: 0.000% | 'MonitorWAN1~root#linkmonitor.latency.milliseconds'=39.739;;;0; 'MonitorWAN1~root#linkmonitor.jitter.milliseconds'=0.096;;;0; 'MonitorWAN1~root#linkmonitor.packet.loss.percentage'=0;;;0;
            ...       4    ${EMPTY}         ${EMPTY}         'root'          ${EMPTY}                   ${EMPTY}                     ${EMPTY}                     ${EMPTY}                      ${EMPTY}          ${EMPTY}           ${EMPTY}         ${EMPTY}          ${EMPTY}             ${EMPTY}              OK: All link monitors are ok | 'MonitorWAN1~root#linkmonitor.latency.milliseconds'=39.739;;;0; 'MonitorWAN1~root#linkmonitor.jitter.milliseconds'=0.096;;;0; 'MonitorWAN1~root#linkmonitor.packet.loss.percentage'=0;;;0; 'MonitorWAN2~root#linkmonitor.latency.milliseconds'=46.446;;;0; 'MonitorWAN2~root#linkmonitor.jitter.milliseconds'=1.868;;;0; 'MonitorWAN2~root#linkmonitor.packet.loss.percentage'=1;;;0; 'MonitorWAN3~root#linkmonitor.latency.milliseconds'=0.000;;;0; 'MonitorWAN3~root#linkmonitor.jitter.milliseconds'=0.000;;;0; 'MonitorWAN3~root#linkmonitor.packet.loss.percentage'=100;;;0;
            ...       5    ${EMPTY}         ${EMPTY}          ${EMPTY}       '\\\%(name) %(id)'         ${EMPTY}                     ${EMPTY}                     ${EMPTY}                      ${EMPTY}          ${EMPTY}           ${EMPTY}         ${EMPTY}          ${EMPTY}             ${EMPTY}              OK: All link monitors are ok | 'MonitorWAN1~1#linkmonitor.latency.milliseconds'=39.739;;;0; 'MonitorWAN1~1#linkmonitor.jitter.milliseconds'=0.096;;;0; 'MonitorWAN1~1#linkmonitor.packet.loss.percentage'=0;;;0; 'MonitorWAN2~2#linkmonitor.latency.milliseconds'=46.446;;;0; 'MonitorWAN2~2#linkmonitor.jitter.milliseconds'=1.868;;;0; 'MonitorWAN2~2#linkmonitor.packet.loss.percentage'=1;;;0; 'MonitorWAN3~3#linkmonitor.latency.milliseconds'=0.000;;;0; 'MonitorWAN3~3#linkmonitor.jitter.milliseconds'=0.000;;;0; 'MonitorWAN3~3#linkmonitor.packet.loss.percentage'=100;;;0;
            ...       6    ${EMPTY}         ${EMPTY}          ${EMPTY}       ${EMPTY}                   '\\\%{state} =~ /alive/'     ${EMPTY}                     ${EMPTY}                      ${EMPTY}          ${EMPTY}           ${EMPTY}         ${EMPTY}          ${EMPTY}             ${EMPTY}              UNKNOWN: Link monitor 'MonitorWAN1' [vdom: root] [id: 1] state: alive - Link monitor 'MonitorWAN2' [vdom: root] [id: 2] state: alive | 'MonitorWAN1~root#linkmonitor.latency.milliseconds'=39.739;;;0; 'MonitorWAN1~root#linkmonitor.jitter.milliseconds'=0.096;;;0; 'MonitorWAN1~root#linkmonitor.packet.loss.percentage'=0;;;0; 'MonitorWAN2~root#linkmonitor.latency.milliseconds'=46.446;;;0; 'MonitorWAN2~root#linkmonitor.jitter.milliseconds'=1.868;;;0; 'MonitorWAN2~root#linkmonitor.packet.loss.percentage'=1;;;0; 'MonitorWAN3~root#linkmonitor.latency.milliseconds'=0.000;;;0; 'MonitorWAN3~root#linkmonitor.jitter.milliseconds'=0.000;;;0; 'MonitorWAN3~root#linkmonitor.packet.loss.percentage'=100;;;0;
            ...       7    ${EMPTY}         ${EMPTY}          ${EMPTY}       ${EMPTY}                   ${EMPTY}                     '\\\%{state} =~ /alive/'     ${EMPTY}                      ${EMPTY}          ${EMPTY}           ${EMPTY}         ${EMPTY}          ${EMPTY}             ${EMPTY}              WARNING: Link monitor 'MonitorWAN1' [vdom: root] [id: 1] state: alive - Link monitor 'MonitorWAN2' [vdom: root] [id: 2] state: alive | 'MonitorWAN1~root#linkmonitor.latency.milliseconds'=39.739;;;0; 'MonitorWAN1~root#linkmonitor.jitter.milliseconds'=0.096;;;0; 'MonitorWAN1~root#linkmonitor.packet.loss.percentage'=0;;;0; 'MonitorWAN2~root#linkmonitor.latency.milliseconds'=46.446;;;0; 'MonitorWAN2~root#linkmonitor.jitter.milliseconds'=1.868;;;0; 'MonitorWAN2~root#linkmonitor.packet.loss.percentage'=1;;;0; 'MonitorWAN3~root#linkmonitor.latency.milliseconds'=0.000;;;0; 'MonitorWAN3~root#linkmonitor.jitter.milliseconds'=0.000;;;0; 'MonitorWAN3~root#linkmonitor.packet.loss.percentage'=100;;;0;
            ...       8    ${EMPTY}         ${EMPTY}          ${EMPTY}       ${EMPTY}                   ${EMPTY}                     ${EMPTY}                     '\\\%{state} =~ /alive/'      ${EMPTY}          ${EMPTY}           ${EMPTY}         ${EMPTY}          ${EMPTY}             ${EMPTY}              CRITICAL: Link monitor 'MonitorWAN1' [vdom: root] [id: 1] state: alive - Link monitor 'MonitorWAN2' [vdom: root] [id: 2] state: alive | 'MonitorWAN1~root#linkmonitor.latency.milliseconds'=39.739;;;0; 'MonitorWAN1~root#linkmonitor.jitter.milliseconds'=0.096;;;0; 'MonitorWAN1~root#linkmonitor.packet.loss.percentage'=0;;;0; 'MonitorWAN2~root#linkmonitor.latency.milliseconds'=46.446;;;0; 'MonitorWAN2~root#linkmonitor.jitter.milliseconds'=1.868;;;0; 'MonitorWAN2~root#linkmonitor.packet.loss.percentage'=1;;;0; 'MonitorWAN3~root#linkmonitor.latency.milliseconds'=0.000;;;0; 'MonitorWAN3~root#linkmonitor.jitter.milliseconds'=0.000;;;0; 'MonitorWAN3~root#linkmonitor.packet.loss.percentage'=100;;;0;
            ...       9    ${EMPTY}         ${EMPTY}          ${EMPTY}       ${EMPTY}                   ${EMPTY}                     ${EMPTY}                     ${EMPTY}                      40                ${EMPTY}           ${EMPTY}         ${EMPTY}          ${EMPTY}             ${EMPTY}              WARNING: Link monitor 'MonitorWAN2' [vdom: root] [id: 2] latency: 46.446ms | 'MonitorWAN1~root#linkmonitor.latency.milliseconds'=39.739;0:40;;0; 'MonitorWAN1~root#linkmonitor.jitter.milliseconds'=0.096;;;0; 'MonitorWAN1~root#linkmonitor.packet.loss.percentage'=0;;;0; 'MonitorWAN2~root#linkmonitor.latency.milliseconds'=46.446;0:40;;0; 'MonitorWAN2~root#linkmonitor.jitter.milliseconds'=1.868;;;0; 'MonitorWAN2~root#linkmonitor.packet.loss.percentage'=1;;;0; 'MonitorWAN3~root#linkmonitor.latency.milliseconds'=0.000;0:40;;0; 'MonitorWAN3~root#linkmonitor.jitter.milliseconds'=0.000;;;0; 'MonitorWAN3~root#linkmonitor.packet.loss.percentage'=100;;;0;
            ...       10   ${EMPTY}         ${EMPTY}          ${EMPTY}       ${EMPTY}                   ${EMPTY}                     ${EMPTY}                     ${EMPTY}                      ${EMPTY}          40                 ${EMPTY}         ${EMPTY}          ${EMPTY}             ${EMPTY}              CRITICAL: Link monitor 'MonitorWAN2' [vdom: root] [id: 2] latency: 46.446ms | 'MonitorWAN1~root#linkmonitor.latency.milliseconds'=39.739;;0:40;0; 'MonitorWAN1~root#linkmonitor.jitter.milliseconds'=0.096;;;0; 'MonitorWAN1~root#linkmonitor.packet.loss.percentage'=0;;;0; 'MonitorWAN2~root#linkmonitor.latency.milliseconds'=46.446;;0:40;0; 'MonitorWAN2~root#linkmonitor.jitter.milliseconds'=1.868;;;0; 'MonitorWAN2~root#linkmonitor.packet.loss.percentage'=1;;;0; 'MonitorWAN3~root#linkmonitor.latency.milliseconds'=0.000;;0:40;0; 'MonitorWAN3~root#linkmonitor.jitter.milliseconds'=0.000;;;0; 'MonitorWAN3~root#linkmonitor.packet.loss.percentage'=100;;;0;
            ...       11   ${EMPTY}         ${EMPTY}          ${EMPTY}       ${EMPTY}                   ${EMPTY}                     ${EMPTY}                     ${EMPTY}                      ${EMPTY}          ${EMPTY}           1                ${EMPTY}          ${EMPTY}             ${EMPTY}              WARNING: Link monitor 'MonitorWAN2' [vdom: root] [id: 2] jitter: 1.868ms | 'MonitorWAN1~root#linkmonitor.latency.milliseconds'=39.739;;;0; 'MonitorWAN1~root#linkmonitor.jitter.milliseconds'=0.096;0:1;;0; 'MonitorWAN1~root#linkmonitor.packet.loss.percentage'=0;;;0; 'MonitorWAN2~root#linkmonitor.latency.milliseconds'=46.446;;;0; 'MonitorWAN2~root#linkmonitor.jitter.milliseconds'=1.868;0:1;;0; 'MonitorWAN2~root#linkmonitor.packet.loss.percentage'=1;;;0; 'MonitorWAN3~root#linkmonitor.latency.milliseconds'=0.000;;;0; 'MonitorWAN3~root#linkmonitor.jitter.milliseconds'=0.000;0:1;;0; 'MonitorWAN3~root#linkmonitor.packet.loss.percentage'=100;;;0;
            ...       12   ${EMPTY}         ${EMPTY}          ${EMPTY}       ${EMPTY}                   ${EMPTY}                     ${EMPTY}                     ${EMPTY}                      ${EMPTY}          ${EMPTY}           ${EMPTY}         1                 ${EMPTY}             ${EMPTY}              CRITICAL: Link monitor 'MonitorWAN2' [vdom: root] [id: 2] jitter: 1.868ms | 'MonitorWAN1~root#linkmonitor.latency.milliseconds'=39.739;;;0; 'MonitorWAN1~root#linkmonitor.jitter.milliseconds'=0.096;;0:1;0; 'MonitorWAN1~root#linkmonitor.packet.loss.percentage'=0;;;0; 'MonitorWAN2~root#linkmonitor.latency.milliseconds'=46.446;;;0; 'MonitorWAN2~root#linkmonitor.jitter.milliseconds'=1.868;;0:1;0; 'MonitorWAN2~root#linkmonitor.packet.loss.percentage'=1;;;0; 'MonitorWAN3~root#linkmonitor.latency.milliseconds'=0.000;;;0; 'MonitorWAN3~root#linkmonitor.jitter.milliseconds'=0.000;;0:1;0; 'MonitorWAN3~root#linkmonitor.packet.loss.percentage'=100;;;0;
            ...       13   ${EMPTY}         ${EMPTY}          ${EMPTY}       ${EMPTY}                   ${EMPTY}                     ${EMPTY}                     ${EMPTY}                      ${EMPTY}          ${EMPTY}           ${EMPTY}         ${EMPTY}          0.5                  ${EMPTY}              WARNING: Link monitor 'MonitorWAN2' [vdom: root] [id: 2] packet loss: 1.000% - Link monitor 'MonitorWAN3' [vdom: root] [id: 3] packet loss: 100.000% | 'MonitorWAN1~root#linkmonitor.latency.milliseconds'=39.739;;;0; 'MonitorWAN1~root#linkmonitor.jitter.milliseconds'=0.096;;;0; 'MonitorWAN1~root#linkmonitor.packet.loss.percentage'=0;0:0.5;;0; 'MonitorWAN2~root#linkmonitor.latency.milliseconds'=46.446;;;0; 'MonitorWAN2~root#linkmonitor.jitter.milliseconds'=1.868;;;0; 'MonitorWAN2~root#linkmonitor.packet.loss.percentage'=1;0:0.5;;0; 'MonitorWAN3~root#linkmonitor.latency.milliseconds'=0.000;;;0; 'MonitorWAN3~root#linkmonitor.jitter.milliseconds'=0.000;;;0; 'MonitorWAN3~root#linkmonitor.packet.loss.percentage'=100;0:0.5;;0;
            ...       14   ${EMPTY}         ${EMPTY}          ${EMPTY}       ${EMPTY}                   ${EMPTY}                     ${EMPTY}                     ${EMPTY}                      ${EMPTY}          ${EMPTY}           ${EMPTY}         ${EMPTY}          ${EMPTY}             0.5                   CRITICAL: Link monitor 'MonitorWAN2' [vdom: root] [id: 2] packet loss: 1.000% - Link monitor 'MonitorWAN3' [vdom: root] [id: 3] packet loss: 100.000% | 'MonitorWAN1~root#linkmonitor.latency.milliseconds'=39.739;;;0; 'MonitorWAN1~root#linkmonitor.jitter.milliseconds'=0.096;;;0; 'MonitorWAN1~root#linkmonitor.packet.loss.percentage'=0;;0:0.5;0; 'MonitorWAN2~root#linkmonitor.latency.milliseconds'=46.446;;;0; 'MonitorWAN2~root#linkmonitor.jitter.milliseconds'=1.868;;;0; 'MonitorWAN2~root#linkmonitor.packet.loss.percentage'=1;;0:0.5;0; 'MonitorWAN3~root#linkmonitor.latency.milliseconds'=0.000;;;0; 'MonitorWAN3~root#linkmonitor.jitter.milliseconds'=0.000;;;0; 'MonitorWAN3~root#linkmonitor.packet.loss.percentage'=100;;0:0.5;0;