bgpdump(1)

# NAME

bgpdump - translate MRT format files into readable output


# VERSION

Version 1.4.99.15+hg127


# SYNOPSIS

Usage:

```
bgpdump [-m|-M] [-t dump|-t change] [-O <output-file>] <input-file>
```


# OPTIONS

Output mode:

*-H*
	multi-line, human-readable (the default)

*-m*
	one-line per entry with unix timestamps

*-M*
	one-line per entry with human readable timestamps in the form
	MM/DD/YY HH:MM:SS (there are other differences between -m and -M)

Common options:

*-O* file
	output to 'file' instead of STDOUT

*-s*
	log to syslog (the default)

*-v*
	log to STDERR


Options for -m and -M modes:

*-t* _dump_
	timestamps for RIB dumps reflect the time of the dump (the default)

*-t* _change_
	timestamps for RIB dumps reflect the last route modification

*-p*
	show packet index at second position

Special options:

*-T*
	run internal tests and exit


# INPUT FORMATS

- MRT routing table dump entries in TABLE_DUMP or TABLE_DUMP_V2 types
- Zebra/Quagga BGP records:
	- BGP messages (OPEN, UPDATE, NOTIFY, KEEPALIVE)
	- BGP state changes
- File may be gzipped or bzip2'd and/or passed in through stdin


The file format is described in the Internet Draft grow-mrt-13:
<https://tools.ietf.org/html/draft-ietf-grow-mrt-13>


# BUGS

If a single update message contains more than 8192 added or
withdrawn prefixes, all those above that number are ignored.

Files with a name longer than 999 characters cannot be processed.

The bgpdump program is not y2038 compliant. This is inherited from
the file format.


# DEBIAN

Besides bug fixes, the following changes were done in the packaging
for the Debian distribution:

- The maximum number of prefixes processed from a single update
    messages was raised from 2050 to 8192.


# AUTHOR

bgpdump was originally written by Dan Ardelean and the RIPE NCC
took over maintenance in 2005.

bgpdump is Copyright (C) 2007-2011 RIPE NCC

This manpage is based on bgpdump's usage output, the bgpdump's
homepage, and other sources. It was written for the Debian project
by Christoph Biedl <debian.axhn@manchmal.in-ulm.de> but may be used
by others.
