/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *  
 *    https://www.apache.org/licenses/LICENSE-2.0
 *  
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License. 
 *  
 */
package org.apache.directory.api.ldap.model.csn;


/**
 * A {@link RuntimeException} which is thrown when a wrong string
 * representation is specified to create a new {@link Csn}.
 *
 * @author <a href="mailto:dev@directory.apache.org">Apache Directory Project</a>
 */
public class InvalidCSNException extends RuntimeException
{
    /**
     * Declares the Serial Version Uid.
     *
     * @see <a
     *      href="http://c2.com/cgi/wiki?AlwaysDeclareSerialVersionUid">Always
     *      Declare Serial Version Uid</a>
     */
    private static final long serialVersionUID = 1L;


    /**
     * Creates a new instance.
     */
    public InvalidCSNException()
    {
        super();
    }


    /**
     * Creates a new instance with the specified <tt>message</tt> and
     * <tt>cause</tt>.
     * 
     * @param message The message associated with the exception
     * @param cause The root cause for this exception
     */
    public InvalidCSNException( String message, Throwable cause )
    {
        super( message, cause );
    }


    /**
     * Creates a new instance with the specified <tt>message</tt>.
     * 
     * @param message The message associated with the exception
     */
    public InvalidCSNException( String message )
    {
        super( message );
    }


    /**
     * Creates a new instance with the specified <tt>cause</tt>.
     * 
     * @param cause The root cause for this exception
     */
    public InvalidCSNException( Throwable cause )
    {
        super( cause );
    }
}
